@extends('layouts.admin-sidebar')

@section('title', 'Virtual Cards Analytics')
@section('page-title', 'Virtual Cards Analytics')
@section('page-description', 'Analytics and insights for virtual cards')

@section('content')
<div class="space-y-6">
    <!-- Cards by Status -->
    <div class="stat-card rounded-xl p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Cards by Status</h3>
        @if(!empty($analytics['cards_by_status']))
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                @foreach($analytics['cards_by_status'] as $status => $count)
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <p class="text-2xl font-bold 
                            @if($status === 'active') text-emerald-600 
                            @elseif($status === 'frozen') text-amber-600 
                            @elseif($status === 'terminated') text-red-600 
                            @else text-gray-600 @endif">
                            {{ number_format($count) }}
                        </p>
                        <p class="text-sm text-gray-600 capitalize">{{ $status }}</p>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No data available</h3>
                <p class="mt-1 text-sm text-gray-500">No virtual cards found in the system.</p>
            </div>
        @endif
    </div>

    <!-- Cards by Type -->
    <div class="stat-card rounded-xl p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Cards by Type</h3>
        @if(!empty($analytics['cards_by_type']))
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @foreach($analytics['cards_by_type'] as $type => $count)
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <p class="text-2xl font-bold text-blue-600">{{ number_format($count) }}</p>
                        <p class="text-sm text-gray-600 capitalize">{{ $type }}</p>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No data available</h3>
                <p class="mt-1 text-sm text-gray-500">No virtual cards found in the system.</p>
            </div>
        @endif
    </div>

    <!-- Monthly Card Creations -->
    <div class="stat-card rounded-xl p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Monthly Card Creations (Last 12 Months)</h3>
        @if(!empty($analytics['monthly_creations']) && count($analytics['monthly_creations']) > 0)
            <div class="space-y-3">
                @foreach($analytics['monthly_creations'] as $month => $count)
                    @php
                        try {
                            $carbonDate = \Carbon\Carbon::createFromFormat('Y-m', $month);
                            $formattedMonth = $carbonDate->format('M Y');
                        } catch (\Exception $e) {
                            $formattedMonth = $month; // Fallback to original format
                        }
                    @endphp
                    <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                        <span class="text-sm font-medium text-gray-700">{{ $formattedMonth }}</span>
                        <span class="text-sm font-bold text-blue-600">{{ number_format($count) }} cards</span>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No data available</h3>
                <p class="mt-1 text-sm text-gray-500">No card creation data for the last 12 months.</p>
            </div>
        @endif
    </div>

    <!-- Transaction Volume -->
    <div class="stat-card rounded-xl p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Monthly Transaction Volume (Last 12 Months)</h3>
        @if(!empty($analytics['transaction_volume']) && count($analytics['transaction_volume']) > 0)
            <div class="space-y-3">
                @foreach($analytics['transaction_volume'] as $month => $volume)
                    @php
                        try {
                            $carbonDate = \Carbon\Carbon::createFromFormat('Y-m', $month);
                            $formattedMonth = $carbonDate->format('M Y');
                        } catch (\Exception $e) {
                            $formattedMonth = $month; // Fallback to original format
                        }
                    @endphp
                    <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                        <span class="text-sm font-medium text-gray-700">{{ $formattedMonth }}</span>
                        <span class="text-sm font-bold text-emerald-600">₦{{ number_format($volume, 2) }}</span>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No transaction data available</h3>
                <p class="mt-1 text-sm text-gray-500">No virtual card transaction data for the last 12 months. This may be because the virtual_card_id column is not yet available in the transactions table, or no transactions have been processed yet.</p>
            </div>
        @endif
    </div>

    <!-- Summary Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Virtual Cards</p>
                    <p class="text-2xl font-bold text-gray-900">
                        @php
                            $totalCards = is_array($analytics['cards_by_status'] ?? null) ? 
                                array_sum($analytics['cards_by_status']) : 0;
                        @endphp
                        {{ number_format($totalCards) }}
                    </p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">This Month's Creations</p>
                    <p class="text-2xl font-bold text-emerald-600">
                        @php
                            $currentMonth = now()->format('Y-m');
                            $thisMonthCount = isset($analytics['monthly_creations'][$currentMonth]) ? 
                                $analytics['monthly_creations'][$currentMonth] : 0;
                        @endphp
                        {{ number_format($thisMonthCount) }}
                    </p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Transaction Volume</p>
                    <p class="text-2xl font-bold text-purple-600">
                        @php
                            $totalVolume = is_array($analytics['transaction_volume'] ?? null) ? 
                                array_sum($analytics['transaction_volume']) : 0;
                        @endphp
                        ₦{{ number_format($totalVolume, 2) }}
                    </p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection