<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('currency', 3)->default('NGN');
            $table->decimal('balance', 15, 2)->default(0.00);
            $table->decimal('locked_balance', 15, 2)->default(0.00);
            $table->decimal('daily_transaction_limit', 15, 2)->default(1000000.00);
            $table->decimal('monthly_transaction_limit', 15, 2)->default(5000000.00);
            $table->decimal('daily_spent', 15, 2)->default(0.00);
            $table->decimal('monthly_spent', 15, 2)->default(0.00);
            $table->date('daily_spent_reset_date')->default(now()->toDateString());
            $table->date('monthly_spent_reset_date')->default(now()->toDateString());
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->unique(['user_id', 'currency']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallets');
    }
};