<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_configs', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., 'Paystack', 'Flutterwave'
            $table->string('slug')->unique(); // e.g., 'paystack', 'flutterwave'
            $table->enum('category', ['payment', 'identity', 'messaging', 'utilities', 'banking']);
            $table->string('provider_code')->nullable(); // Internal provider reference
            $table->text('description')->nullable();
            $table->string('base_url'); // API base URL
            $table->string('test_url')->nullable(); // Test/sandbox URL
            $table->string('live_url')->nullable(); // Live/production URL
            
            // Authentication credentials (encrypted)
            $table->text('api_key')->nullable();
            $table->text('secret_key')->nullable();
            $table->text('public_key')->nullable();
            $table->text('private_key')->nullable();
            $table->string('merchant_id')->nullable();
            $table->string('client_id')->nullable();
            $table->string('client_secret')->nullable();
            
            // Configuration settings
            $table->json('config')->nullable(); // Additional settings, timeouts, headers, etc.
            $table->json('endpoints')->nullable(); // Available endpoints for this provider
            $table->json('webhook_config')->nullable(); // Webhook settings
            
            // Status and mode
            $table->boolean('is_active')->default(false);
            $table->boolean('is_live_mode')->default(false);
            $table->datetime('last_tested_at')->nullable();
            $table->string('last_test_status')->nullable(); // 'success', 'failed', 'pending'
            $table->text('last_test_response')->nullable();
            
            // Callback URLs
            $table->string('webhook_url')->nullable();
            $table->string('callback_url')->nullable();
            $table->string('return_url')->nullable();
            
            $table->timestamps();
            
            $table->index(['category', 'is_active']);
            $table->index(['slug', 'is_active']);
            $table->index('provider_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_configs');
    }
};
