<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, integer, boolean, json
            $table->text('description')->nullable();
            $table->boolean('is_public')->default(false); // Whether setting can be accessed publicly
            $table->timestamps();
        });

        // Add some default settings
        $defaultSettings = [
            ['key' => 'business.name', 'value' => 'AbokiPay', 'type' => 'string', 'description' => 'Business name'],
            ['key' => 'business.tagline', 'value' => 'Your trusted fintech partner', 'type' => 'string', 'description' => 'Business tagline'],
            ['key' => 'features.wallet_funding', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable wallet funding'],
            ['key' => 'features.p2p_transfers', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable P2P transfers'],
            ['key' => 'features.virtual_cards', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable virtual cards'],
            ['key' => 'fees.transfer.type', 'value' => 'percentage', 'type' => 'string', 'description' => 'Transfer fee type'],
            ['key' => 'fees.transfer.value', 'value' => '1.5', 'type' => 'string', 'description' => 'Transfer fee value'],
            ['key' => 'limits.transfer.daily', 'value' => '500000', 'type' => 'integer', 'description' => 'Daily transfer limit'],
            ['key' => 'security.session_lifetime', 'value' => '120', 'type' => 'integer', 'description' => 'Session lifetime in minutes'],
        ];

        foreach ($defaultSettings as $setting) {
            DB::table('settings')->insert(array_merge($setting, [
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};