<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // For SQLite, we need to recreate the table with the new enum values
        // First, create a temporary table with the new structure
        Schema::create('transactions_temp', function (Blueprint $table) {
            $table->id();
            $table->string('reference')->unique();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('wallet_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['credit', 'debit']);
            $table->enum('category', [
                'wallet_funding',
                'p2p_transfer',
                'bank_transfer',
                'airtime_purchase',
                'data_purchase',
                'bill_payment',
                'card_transaction',
                'refund',
                'charge',
                'commission',
                'admin_adjustment' // Added this new category
            ]);
            $table->decimal('amount', 15, 2);
            $table->decimal('fee', 15, 2)->default(0.00);
            $table->decimal('total_amount', 15, 2);
            $table->string('currency', 3)->default('NGN');
            $table->enum('status', ['pending', 'processing', 'completed', 'failed', 'cancelled'])->default('pending');
            $table->string('description')->nullable();
            $table->json('metadata')->nullable();
            $table->string('external_reference')->nullable();
            $table->string('payment_method')->nullable();
            $table->foreignId('recipient_user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('recipient_account_number')->nullable();
            $table->string('recipient_bank_code')->nullable();
            $table->string('recipient_bank_name')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
            
            $table->index(['user_id', 'created_at']);
            $table->index(['status', 'created_at']);
            $table->index('reference');
            $table->index('external_reference');
        });

        // Copy data from original table to temporary table
        DB::statement('INSERT INTO transactions_temp SELECT * FROM transactions');

        // Drop the original table
        Schema::dropIfExists('transactions');

        // Rename temporary table to original name
        Schema::rename('transactions_temp', 'transactions');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Recreate the original table structure without admin_adjustment
        Schema::create('transactions_temp', function (Blueprint $table) {
            $table->id();
            $table->string('reference')->unique();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('wallet_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['credit', 'debit']);
            $table->enum('category', [
                'wallet_funding',
                'p2p_transfer',
                'bank_transfer',
                'airtime_purchase',
                'data_purchase',
                'bill_payment',
                'card_transaction',
                'refund',
                'charge',
                'commission'
            ]);
            $table->decimal('amount', 15, 2);
            $table->decimal('fee', 15, 2)->default(0.00);
            $table->decimal('total_amount', 15, 2);
            $table->string('currency', 3)->default('NGN');
            $table->enum('status', ['pending', 'processing', 'completed', 'failed', 'cancelled'])->default('pending');
            $table->string('description')->nullable();
            $table->json('metadata')->nullable();
            $table->string('external_reference')->nullable();
            $table->string('payment_method')->nullable();
            $table->foreignId('recipient_user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('recipient_account_number')->nullable();
            $table->string('recipient_bank_code')->nullable();
            $table->string('recipient_bank_name')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
            
            $table->index(['user_id', 'created_at']);
            $table->index(['status', 'created_at']);
            $table->index('reference');
            $table->index('external_reference');
        });

        // Copy data (excluding admin_adjustment records)
        DB::statement("INSERT INTO transactions_temp SELECT * FROM transactions WHERE category != 'admin_adjustment'");

        // Drop the current table
        Schema::dropIfExists('transactions');

        // Rename temporary table to original name
        Schema::rename('transactions_temp', 'transactions');
    }
};
