<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'content' => '<h1>Privacy Policy</h1>
<p>Last updated: ' . now()->format('F j, Y') . '</p>

<h2>Information We Collect</h2>
<p>We collect information you provide directly to us, such as when you create an account, make a transaction, or contact us for customer support.</p>

<h2>How We Use Your Information</h2>
<p>We use the information we collect to:</p>
<ul>
<li>Provide, maintain, and improve our services</li>
<li>Process transactions and send related information</li>
<li>Send technical notices and security alerts</li>
<li>Respond to comments, questions, and customer service requests</li>
</ul>

<h2>Information Sharing</h2>
<p>We do not sell, trade, or rent your personal information to third parties. We may share your information only in the following circumstances:</p>
<ul>
<li>With your consent</li>
<li>To comply with legal obligations</li>
<li>To protect our rights and safety</li>
</ul>

<h2>Data Security</h2>
<p>We implement appropriate security measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p>

<h2>Contact Us</h2>
<p>If you have any questions about this Privacy Policy, please contact us at privacy@swiftpay.ng</p>',
                'excerpt' => 'Learn how we collect, use, and protect your personal information.',
                'meta_title' => 'Privacy Policy - SwiftPay',
                'meta_description' => 'SwiftPay\'s privacy policy explains how we collect, use, and protect your personal information when you use our fintech services.',
                'status' => 'published',
                'published_at' => now(),
            ],
            [
                'title' => 'Terms & Conditions',
                'slug' => 'terms-conditions',
                'content' => '<h1>Terms & Conditions</h1>
<p>Last updated: ' . now()->format('F j, Y') . '</p>

<h2>Acceptance of Terms</h2>
<p>By accessing and using SwiftPay, you accept and agree to be bound by the terms and provisions of this agreement.</p>

<h2>Use of the Service</h2>
<p>You agree to use our service only for lawful purposes and in accordance with these Terms. You must not:</p>
<ul>
<li>Use the service for any unlawful or fraudulent activities</li>
<li>Attempt to gain unauthorized access to our systems</li>
<li>Transmit viruses or malicious code</li>
<li>Violate any applicable laws or regulations</li>
</ul>

<h2>Account Responsibilities</h2>
<p>You are responsible for:</p>
<ul>
<li>Maintaining the confidentiality of your account credentials</li>
<li>All activities that occur under your account</li>
<li>Providing accurate and complete information</li>
</ul>

<h2>Financial Services</h2>
<p>Our financial services are subject to additional terms and regulatory requirements. By using our financial services, you acknowledge that:</p>
<ul>
<li>Transactions may be subject to fees</li>
<li>Processing times may vary</li>
<li>Services are subject to regulatory compliance</li>
</ul>

<h2>Limitation of Liability</h2>
<p>To the maximum extent permitted by law, SwiftPay shall not be liable for any indirect, incidental, special, or consequential damages.</p>

<h2>Contact Information</h2>
<p>For questions about these Terms, please contact us at legal@swiftpay.ng</p>',
                'excerpt' => 'Terms and conditions governing the use of SwiftPay services.',
                'meta_title' => 'Terms & Conditions - SwiftPay',
                'meta_description' => 'Read SwiftPay\'s terms and conditions that govern the use of our fintech platform and services.',
                'status' => 'published',
                'published_at' => now(),
            ],
            [
                'title' => 'About Us',
                'slug' => 'about-us',
                'content' => '<h1>About SwiftPay</h1>
<p>SwiftPay is Nigeria\'s leading fintech platform, providing secure and innovative financial services to millions of users across the country.</p>

<h2>Our Mission</h2>
<p>To democratize access to financial services and empower Nigerians to achieve their financial goals through technology-driven solutions.</p>

<h2>What We Offer</h2>
<ul>
<li><strong>Digital Wallet:</strong> Secure money storage and transfers</li>
<li><strong>Bill Payments:</strong> Airtime, data, electricity, and more</li>
<li><strong>Virtual Cards:</strong> Safe online and offline payments</li>
<li><strong>P2P Transfers:</strong> Send money to friends and family instantly</li>
<li><strong>Merchant Services:</strong> Payment solutions for businesses</li>
</ul>

<h2>Our Values</h2>
<h3>Security First</h3>
<p>We prioritize the security of your funds and personal information with bank-grade security measures.</p>

<h3>Innovation</h3>
<p>We continuously innovate to provide cutting-edge financial solutions that meet your evolving needs.</p>

<h3>Accessibility</h3>
<p>We believe financial services should be accessible to everyone, regardless of their background or location.</p>

<h3>Transparency</h3>
<p>We maintain clear, honest communication about our services, fees, and policies.</p>

<h2>Contact Us</h2>
<p>Have questions or need support? Reach out to us:</p>
<ul>
<li>Email: support@swiftpay.ng</li>
<li>Phone: +234 (0) 1 234 5678</li>
<li>Address: Lagos, Nigeria</li>
</ul>',
                'excerpt' => 'Learn about SwiftPay\'s mission to democratize financial services in Nigeria.',
                'meta_title' => 'About SwiftPay - Leading Nigerian Fintech Platform',
                'meta_description' => 'Discover SwiftPay\'s mission to provide secure, innovative financial services to millions of Nigerians through our technology-driven platform.',
                'status' => 'published',
                'published_at' => now(),
                'is_featured' => true,
            ],
        ];

        foreach ($pages as $pageData) {
            Page::create($pageData);
        }
    }
}
