@extends('layouts.admin-sidebar')

@section('title', 'Add New Provider')
@section('page-title', 'Add New Service Provider')
@section('page-description', 'Configure a new airtime and data service provider')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-8">
        <form action="{{ route('admin.airtime.providers.store') }}" method="POST" class="space-y-6">
            @csrf
            
            <!-- Provider Basic Information -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Provider Name</label>
                    <input type="text" id="name" name="name" value="{{ old('name') }}" 
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                           placeholder="Enter provider name" required>
                    @error('name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="module" class="block text-sm font-medium text-gray-700 mb-2">Provider Module</label>
                    <select id="module" name="module" 
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" required>
                        <option value="">Select a module</option>
                        @foreach($supportedModules as $key => $label)
                            <option value="{{ $key }}" {{ old('module') === $key ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                        @endforeach
                    </select>
                    @error('module')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Priority and Status -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div>
                    <label for="priority" class="block text-sm font-medium text-gray-700 mb-2">Priority (0-100)</label>
                    <input type="number" id="priority" name="priority" value="{{ old('priority', 50) }}" 
                           min="0" max="100"
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                           placeholder="50" required>
                    <p class="mt-1 text-xs text-gray-500">Higher priority providers are tried first</p>
                    @error('priority')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex items-center space-x-3 pt-8">
                    <input type="hidden" name="is_test_mode" value="0">
                    <input type="checkbox" id="is_test_mode" name="is_test_mode" value="1" 
                           {{ old('is_test_mode') ? 'checked' : '' }}
                           class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                    <label for="is_test_mode" class="text-sm font-medium text-gray-700">Test Mode</label>
                </div>

                <div class="flex items-center space-x-3 pt-8">
                    <input type="hidden" name="is_active" value="0">
                    <input type="checkbox" id="is_active" name="is_active" value="1" 
                           {{ old('is_active', true) ? 'checked' : '' }}
                           class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                    <label for="is_active" class="text-sm font-medium text-gray-700">Active</label>
                </div>
            </div>

            <!-- Supported Services -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Supported Services</label>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                    @foreach($supportedServices as $key => $label)
                        <label class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer">
                            <input type="checkbox" name="supported_services[]" value="{{ $key }}" 
                                   {{ in_array($key, old('supported_services', [])) ? 'checked' : '' }}
                                   class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500 mr-3">
                            <span class="text-sm text-gray-700">{{ $label }}</span>
                        </label>
                    @endforeach
                </div>
                @error('supported_services')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Supported Networks -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Supported Networks</label>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                    @foreach($supportedNetworks as $key => $label)
                        <label class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer">
                            <input type="checkbox" name="supported_networks[]" value="{{ $key }}" 
                                   {{ in_array($key, old('supported_networks', [])) ? 'checked' : '' }}
                                   class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500 mr-3">
                            <span class="text-sm text-gray-700">{{ $label }}</span>
                        </label>
                    @endforeach
                </div>
                @error('supported_networks')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- API Credentials -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">API Credentials</label>
                <div id="api-credentials-container" class="space-y-3">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3 credential-pair">
                        <input type="text" name="api_credentials[api_key]" value="{{ old('api_credentials.api_key') }}" 
                               placeholder="API Key" 
                               class="px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                        <input type="text" name="api_credentials[api_secret]" value="{{ old('api_credentials.api_secret') }}" 
                               placeholder="API Secret" 
                               class="px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-3 credential-pair">
                        <input type="url" name="api_credentials[base_url]" value="{{ old('api_credentials.base_url') }}" 
                               placeholder="Base URL (https://api.provider.com)" 
                               class="px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                        <input type="text" name="api_credentials[environment]" value="{{ old('api_credentials.environment', 'sandbox') }}" 
                               placeholder="Environment (sandbox/live)" 
                               class="px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                    </div>
                </div>
                <button type="button" id="add-credential" class="mt-3 text-sm text-blue-600 hover:text-blue-800">+ Add More Credentials</button>
                @error('api_credentials')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Form Actions -->
            <div class="flex justify-between items-center pt-6 border-t border-gray-200">
                <a href="{{ route('admin.airtime.providers') }}" 
                   class="px-6 py-3 border border-gray-300 rounded-lg text-gray-700 font-medium hover:bg-gray-50 transition-colors">
                    Cancel
                </a>
                <button type="submit" 
                        class="px-8 py-3 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 focus:ring-4 focus:ring-blue-200 transition-all">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Create Provider
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('add-credential').addEventListener('click', function() {
    const container = document.getElementById('api-credentials-container');
    const newPair = document.createElement('div');
    newPair.className = 'grid grid-cols-1 md:grid-cols-2 gap-3 credential-pair';
    const uniqueId = Date.now();
    newPair.innerHTML = `
        <input type="text" name="api_credentials[custom_key_${uniqueId}]" 
               placeholder="Custom Key" 
               class="px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
        <div class="flex gap-2">
            <input type="text" name="api_credentials[custom_value_${uniqueId}]" 
                   placeholder="Custom Value" 
                   class="flex-1 px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
            <button type="button" onclick="this.closest('.credential-pair').remove()" 
                    class="px-3 py-3 text-red-600 hover:bg-red-50 rounded-lg transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
            </button>
        </div>
    `;
    container.appendChild(newPair);
});
</script>
@endsection