@extends('layouts.admin-sidebar')

@section('title', $page->title)
@section('page-title', 'View Page')
@section('page-description', 'Viewing: ' . $page->title)

@section('content')
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">{{ $page->title }}</h2>
            <p class="text-gray-600 mt-1">
                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                    {{ $page->status === 'published' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                    {{ ucfirst($page->status) }}
                </span>
                • Created {{ $page->created_at->format('M j, Y') }}
                • Last updated {{ $page->updated_at->format('M j, Y g:i A') }}
            </p>
        </div>
        <div class="flex space-x-3">
            <a href="{{ url($page->slug) }}" target="_blank" class="btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2M9 5h6m0 0v6m0-6L9 11"></path>
                </svg>
                View Live
            </a>
            <button onclick="editPage({{ $page->id }})" class="btn-primary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                </svg>
                Edit Page
            </button>
            <a href="{{ route('admin.settings.pages') }}" class="btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Pages
            </a>
        </div>
    </div>

    <!-- Page Details -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Page Content</h3>
                </div>
                <div class="px-6 py-6">
                    <div class="prose max-w-none">
                        {!! $page->content !!}
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Page Information -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h4 class="text-sm font-medium text-gray-900 mb-4">Page Information</h4>
                
                <div class="space-y-3">
                    <div>
                        <span class="text-sm font-medium text-gray-500">Slug:</span>
                        <p class="text-sm text-gray-900 font-mono bg-gray-50 px-2 py-1 rounded">{{ $page->slug }}</p>
                    </div>
                    
                    <div>
                        <span class="text-sm font-medium text-gray-500">Status:</span>
                        <p class="text-sm text-gray-900">{{ ucfirst($page->status) }}</p>
                    </div>
                    
                    <div>
                        <span class="text-sm font-medium text-gray-500">Published:</span>
                        <p class="text-sm text-gray-900">{{ $page->published ? 'Yes' : 'No' }}</p>
                    </div>
                    
                    @if($page->published_at)
                    <div>
                        <span class="text-sm font-medium text-gray-500">Published Date:</span>
                        <p class="text-sm text-gray-900">{{ $page->published_at->format('M j, Y g:i A') }}</p>
                    </div>
                    @endif
                    
                    <div>
                        <span class="text-sm font-medium text-gray-500">Featured:</span>
                        <p class="text-sm text-gray-900">{{ $page->is_featured ? 'Yes' : 'No' }}</p>
                    </div>
                </div>
            </div>

            <!-- SEO Information -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h4 class="text-sm font-medium text-gray-900 mb-4">SEO Information</h4>
                
                <div class="space-y-3">
                    <div>
                        <span class="text-sm font-medium text-gray-500">Meta Title:</span>
                        <p class="text-sm text-gray-900">{{ $page->meta_title ?: $page->title }}</p>
                    </div>
                    
                    @if($page->meta_description)
                    <div>
                        <span class="text-sm font-medium text-gray-500">Meta Description:</span>
                        <p class="text-sm text-gray-900">{{ $page->meta_description }}</p>
                    </div>
                    @endif
                    
                    @if($page->excerpt)
                    <div>
                        <span class="text-sm font-medium text-gray-500">Excerpt:</span>
                        <p class="text-sm text-gray-900">{{ $page->excerpt }}</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Author Information -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h4 class="text-sm font-medium text-gray-900 mb-4">Author Information</h4>
                
                <div class="space-y-3">
                    @if($page->creator)
                    <div>
                        <span class="text-sm font-medium text-gray-500">Created by:</span>
                        <p class="text-sm text-gray-900">{{ $page->creator->name }}</p>
                    </div>
                    @endif
                    
                    @if($page->updater)
                    <div>
                        <span class="text-sm font-medium text-gray-500">Last updated by:</span>
                        <p class="text-sm text-gray-900">{{ $page->updater->name }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function editPage(pageId) {
    // Redirect to pages list with edit modal
    window.location.href = '{{ route("admin.settings.pages") }}?edit=' + pageId;
}
</script>
@endsection