@extends('layouts.responsive')

@section('title', 'KYC Verification')

@section('content')
<div class="space-y-8">
    <!-- Header Section -->
    <div class="text-center">
        <div class="w-20 h-20 bg-gradient-to-br from-blue-500 to-blue-700 rounded-2xl flex items-center justify-center mx-auto mb-6">
            <i class="fas fa-shield-check text-white text-3xl"></i>
        </div>
        <h2 class="text-3xl font-bold text-white mb-4">Identity Verification</h2>
        <p class="text-gray-300 max-w-lg mx-auto">
            Complete your KYC verification to unlock all platform features including higher limits, virtual cards, and virtual accounts.
        </p>
    </div>

    <!-- Verification Status -->
    @if($kycVerifications->isNotEmpty())
    <div class="bg-dark-800/50 backdrop-blur-sm border border-dark-700/50 rounded-2xl p-6">
        <h3 class="text-xl font-bold text-white mb-6">Verification Status</h3>
        <div class="space-y-4">
            @foreach($kycVerifications as $verification)
            <div class="flex items-center justify-between p-4 bg-dark-700/50 rounded-xl border border-dark-600/50">
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center mr-4 {{ $verification->status === 'verified' ? 'bg-green-500/20 text-green-400' : ($verification->status === 'pending' ? 'bg-yellow-500/20 text-yellow-400' : 'bg-red-500/20 text-red-400') }}">
                        <i class="fas fa-{{ $verification->status === 'verified' ? 'check' : ($verification->status === 'pending' ? 'clock' : 'times') }}"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-white">{{ strtoupper($verification->type) }} Verification</p>
                        <p class="text-gray-400 text-sm">{{ $verification->created_at->format('M d, Y H:i') }}</p>
                    </div>
                </div>
                <div class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-semibold {{ $verification->status === 'verified' ? 'bg-green-500/20 text-green-400 border border-green-500/30' : ($verification->status === 'pending' ? 'bg-yellow-500/20 text-yellow-400 border border-yellow-500/30' : 'bg-red-500/20 text-red-400 border border-red-500/30') }}">
                    <i class="fas fa-circle text-[8px] mr-2"></i>
                    {{ ucfirst($verification->status) }}
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Verification Methods -->
    <div class="space-y-6">
        <h3 class="text-xl font-bold text-white">Choose Verification Method</h3>
        <div class="grid gap-6 md:grid-cols-3">
            <!-- BVN Verification -->
            <div class="bg-dark-800/50 backdrop-blur-sm border border-dark-700/50 rounded-2xl p-6 hover:border-blue-500/50 transition-all duration-200 group">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-700 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-200">
                        <i class="fas fa-university text-white text-2xl"></i>
                    </div>
                    <h4 class="text-lg font-bold text-white mb-3">BVN Verification</h4>
                    <p class="text-gray-400 text-sm mb-6">Verify your identity using your Bank Verification Number for instant verification</p>
                    <a href="{{ route('kyc.bvn') }}" class="w-full inline-flex items-center justify-center px-6 py-3 {{ $kycVerifications->where('type', 'bvn')->first()?->isVerified() ? 'bg-green-600 hover:bg-green-700' : 'bg-blue-600 hover:bg-blue-700' }} text-white font-semibold rounded-xl transition-colors duration-200">
                        @if($kycVerifications->where('type', 'bvn')->first()?->isVerified())
                            <i class="fas fa-check mr-2"></i>Verified
                        @else
                            <i class="fas fa-shield-check mr-2"></i>Verify BVN
                        @endif
                    </a>
                </div>
            </div>

            <!-- NIN Verification -->
            <div class="bg-dark-800/50 backdrop-blur-sm border border-dark-700/50 rounded-2xl p-6 hover:border-green-500/50 transition-all duration-200 group">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-700 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-200">
                        <i class="fas fa-id-card text-white text-2xl"></i>
                    </div>
                    <h4 class="text-lg font-bold text-white mb-3">NIN Verification</h4>
                    <p class="text-gray-400 text-sm mb-6">Verify using your National Identification Number for secure identity verification</p>
                    <a href="{{ route('kyc.nin') }}" class="w-full inline-flex items-center justify-center px-6 py-3 {{ $kycVerifications->where('type', 'nin')->first()?->isVerified() ? 'bg-green-600 hover:bg-green-700' : 'bg-green-600 hover:bg-green-700' }} text-white font-semibold rounded-xl transition-colors duration-200">
                        @if($kycVerifications->where('type', 'nin')->first()?->isVerified())
                            <i class="fas fa-check mr-2"></i>Verified
                        @else
                            <i class="fas fa-id-card mr-2"></i>Verify NIN
                        @endif
                    </a>
                </div>
            </div>

            <!-- Document Upload -->
            <div class="bg-dark-800/50 backdrop-blur-sm border border-dark-700/50 rounded-2xl p-6 hover:border-purple-500/50 transition-all duration-200 group">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-br from-purple-500 to-purple-700 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-200">
                        <i class="fas fa-file-upload text-white text-2xl"></i>
                    </div>
                    <h4 class="text-lg font-bold text-white mb-3">Document Upload</h4>
                    <p class="text-gray-400 text-sm mb-6">Upload your government-issued ID document with selfie verification</p>
                    <a href="{{ route('kyc.document') }}" class="w-full inline-flex items-center justify-center px-6 py-3 bg-purple-600 hover:bg-purple-700 text-white font-semibold rounded-xl transition-colors duration-200">
                        <i class="fas fa-upload mr-2"></i>Upload Document
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Messages -->
    @if(auth()->user()->hasCompletedKyc())
    <div class="bg-gradient-to-r from-green-500/20 to-emerald-500/20 border border-green-500/30 rounded-2xl p-6">
        <div class="flex items-center">
            <div class="w-12 h-12 bg-green-500/20 rounded-full flex items-center justify-center mr-4">
                <i class="fas fa-check-circle text-green-400 text-xl"></i>
            </div>
            <div class="flex-1">
                <h4 class="text-green-400 font-bold text-lg mb-1">Verification Complete!</h4>
                <p class="text-gray-300 text-sm mb-4">Your KYC verification is complete. You can now access all platform features including virtual accounts and higher transaction limits.</p>
                <a href="{{ route('dashboard') }}" class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-xl transition-colors duration-200">
                    <i class="fas fa-home mr-2"></i>Go to Dashboard
                </a>
            </div>
        </div>
    </div>
    @else
    <div class="bg-gradient-to-r from-orange-500/20 to-yellow-500/20 border border-orange-500/30 rounded-2xl p-6">
        <div class="flex items-center">
            <div class="w-12 h-12 bg-orange-500/20 rounded-full flex items-center justify-center mr-4">
                <i class="fas fa-exclamation-triangle text-orange-400 text-xl"></i>
            </div>
            <div>
                <h4 class="text-orange-400 font-bold text-lg mb-1">Verification Required</h4>
                <p class="text-gray-300 text-sm">Please complete at least one verification method to access all features including virtual accounts and higher transaction limits.</p>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection