<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ config('app.name', 'SwiftPay') }} Admin</title>

    @yield('meta')

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS with custom configuration -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Inter', 'ui-sans-serif', 'system-ui'],
                    },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            100: '#dbeafe',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8',
                            900: '#1e3a8a',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Alpine.js for interactivity -->
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Custom CSS -->
    <style>
        .sidebar-transition {
            transition: transform 0.3s ease-in-out, width 0.3s ease-in-out;
        }
        
        .menu-item-hover:hover {
            background: linear-gradient(90deg, rgba(59, 130, 246, 0.1) 0%, transparent 100%);
            border-right: 3px solid #3b82f6;
        }
        
        .menu-item-active {
            background: linear-gradient(90deg, rgba(59, 130, 246, 0.15) 0%, transparent 100%);
            border-right: 3px solid #3b82f6;
            color: #1d4ed8;
        }
        
        .glass-effect {
            backdrop-filter: blur(8px);
            background: rgba(255, 255, 255, 0.95);
        }
        
        .stat-card {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.9) 0%, rgba(255, 255, 255, 0.8) 100%);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
    </style>
</head>
<body class="bg-gray-50 font-sans antialiased" x-data="{ sidebarOpen: false, sidebarCollapsed: false }">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="sidebar-transition z-40 fixed inset-y-0 left-0 bg-white shadow-xl border-r border-gray-200"
             :class="{ 
                'w-64': !sidebarCollapsed, 
                'w-16': sidebarCollapsed,
                'transform translate-x-0': sidebarOpen || window.innerWidth >= 768,
                'transform -translate-x-full': !sidebarOpen && window.innerWidth < 768
             }">
            
            <!-- Sidebar Header -->
            <div class="flex items-center justify-between h-16 px-4 border-b border-gray-200">
                <div class="flex items-center" :class="{ 'hidden': sidebarCollapsed }">
                    <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <span class="ml-3 text-xl font-bold text-gray-900">SwiftPay</span>
                </div>
                <button @click="sidebarCollapsed = !sidebarCollapsed" 
                        class="p-1.5 rounded-lg hover:bg-gray-100 transition-colors duration-200 hidden md:block">
                    <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                              :d="sidebarCollapsed ? 'M13 5l7 7-7 7M5 5l7 7-7 7' : 'M11 19l-7-7 7-7M19 19l-7-7 7-7'"></path>
                    </svg>
                </button>
            </div>

            <!-- Navigation Menu -->
            <nav class="mt-8 px-3">
                <div class="space-y-1">
                    <!-- Dashboard -->
                    <a href="{{ route('admin.dashboard') }}" 
                       class="menu-item-hover flex items-center px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200 {{ request()->routeIs('admin.dashboard') ? 'menu-item-active' : '' }}">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v6H8V5z"></path>
                        </svg>
                        <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">Dashboard</span>
                    </a>

                    <!-- User Management -->
                    <div x-data="{ expanded: {{ request()->routeIs('admin.users.*') ? 'true' : 'false' }} }">
                        <button @click="expanded = !expanded" 
                                class="menu-item-hover w-full flex items-center justify-between px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200">
                            <div class="flex items-center">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                                <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">Users</span>
                            </div>
                            <svg class="w-4 h-4 transition-transform duration-200" :class="{ 'hidden': sidebarCollapsed, 'rotate-180': expanded }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div x-show="expanded && !sidebarCollapsed" x-transition class="ml-6 mt-1 space-y-1">
                            <a href="{{ route('admin.users.index') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">All Users</a>
                            <a href="{{ route('admin.users.index', ['status' => 'active']) }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Active Users</a>
                            <a href="{{ route('admin.users.index', ['status' => 'blocked']) }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Blocked Users</a>
                        </div>
                    </div>

                    <!-- KYC Management -->
                    <div x-data="{ expanded: {{ request()->routeIs('admin.kyc.*') ? 'true' : 'false' }} }">
                        <button @click="expanded = !expanded" 
                                class="menu-item-hover w-full flex items-center justify-between px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200">
                            <div class="flex items-center">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">KYC</span>
                            </div>
                            <svg class="w-4 h-4 transition-transform duration-200" :class="{ 'hidden': sidebarCollapsed, 'rotate-180': expanded }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div x-show="expanded && !sidebarCollapsed" x-transition class="ml-6 mt-1 space-y-1">
                            <a href="{{ route('admin.kyc.index') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">All Requests</a>
                            <a href="{{ route('admin.kyc.index', ['status' => 'pending']) }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Pending</a>
                            <a href="{{ route('admin.kyc.analytics') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Analytics</a>
                        </div>
                    </div>

                    <!-- Virtual Cards -->
                    <a href="{{ route('admin.virtual-cards.index') }}" class="menu-item-hover flex items-center px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200 {{ request()->routeIs('admin.virtual-cards.*') ? 'menu-item-active' : '' }}">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                        </svg>
                        <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">Virtual Cards</span>
                    </a>

                    <!-- Wallet & Transactions -->
                    <div x-data="{ expanded: {{ request()->routeIs('admin.wallets.*') ? 'true' : 'false' }} }">
                        <button @click="expanded = !expanded" 
                                class="menu-item-hover w-full flex items-center justify-between px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200">
                            <div class="flex items-center">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">Wallets</span>
                            </div>
                            <svg class="w-4 h-4 transition-transform duration-200" :class="{ 'hidden': sidebarCollapsed, 'rotate-180': expanded }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div x-show="expanded && !sidebarCollapsed" x-transition class="ml-6 mt-1 space-y-1">
                            <a href="{{ route('admin.wallets.index') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">All Wallets</a>
                            <a href="{{ route('admin.wallets.transactions') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Transactions</a>
                            <a href="{{ route('admin.wallets.pending-withdrawals') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Pending Withdrawals</a>
                        </div>
                    </div>

                    <!-- Airtime & Data -->
                    <div x-data="{ expanded: {{ request()->routeIs('admin.airtime.*') ? 'true' : 'false' }} }">
                        <button @click="expanded = !expanded" 
                                class="menu-item-hover w-full flex items-center justify-between px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200">
                            <div class="flex items-center">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                </svg>
                                <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">Airtime & Data</span>
                            </div>
                            <svg class="w-4 h-4 transition-transform duration-200" :class="{ 'hidden': sidebarCollapsed, 'rotate-180': expanded }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div x-show="expanded && !sidebarCollapsed" x-transition class="ml-6 mt-1 space-y-1">
                            <a href="{{ route('admin.airtime.orders') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">View Orders</a>
                            <a href="{{ route('admin.airtime.failed') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Failed Transactions</a>
                            <a href="{{ route('admin.airtime.providers') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Manage Providers</a>
                            <a href="{{ route('admin.airtime.margins') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Set Margins</a>
                        </div>
                    </div>

                    <!-- API Config -->
                    <a href="{{ route('admin.api-config.index') }}" class="menu-item-hover flex items-center px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200 {{ request()->routeIs('admin.api-config.*') ? 'menu-item-active' : '' }}">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">API Config</span>
                    </a>

                    <!-- Settings -->
                    <div x-data="{ expanded: {{ request()->routeIs('admin.settings.*') ? 'true' : 'false' }} }">
                        <button @click="expanded = !expanded" 
                                class="menu-item-hover w-full flex items-center justify-between px-3 py-3 text-sm font-medium text-gray-700 rounded-lg transition-all duration-200">
                            <div class="flex items-center">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                                </svg>
                                <span class="ml-3" :class="{ 'hidden': sidebarCollapsed }">Settings</span>
                            </div>
                            <svg class="w-4 h-4 transition-transform duration-200" :class="{ 'hidden': sidebarCollapsed, 'rotate-180': expanded }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div x-show="expanded && !sidebarCollapsed" x-transition class="ml-6 mt-1 space-y-1">
                            <a href="{{ route('admin.settings.fees') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Fees & Limits</a>
                            <a href="{{ route('admin.settings.site') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Site Settings</a>
                            <a href="{{ route('admin.settings.notifications') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Notifications</a>
                            <a href="{{ route('admin.settings.security-logs') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Security Logs</a>
                            <a href="{{ route('admin.settings.pages') }}" class="block px-3 py-2 text-sm text-gray-600 hover:text-blue-600 transition-colors">Pages</a>
                        </div>
                    </div>
                </div>
            </nav>
        </div>

        <!-- Main Content Area -->
        <div class="flex-1 flex flex-col" :class="{ 'md:ml-64': !sidebarCollapsed, 'md:ml-16': sidebarCollapsed }">
            <!-- Top Header -->
            <header class="glass-effect border-b border-gray-200 h-16 flex items-center justify-between px-6">
                <div class="flex items-center">
                    <button @click="sidebarOpen = !sidebarOpen" class="md:hidden p-2 rounded-lg hover:bg-gray-100 transition-colors">
                        <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                    <div class="ml-4 md:ml-0">
                        <h1 class="text-xl font-semibold text-gray-900">@yield('page-title', 'Dashboard')</h1>
                        <p class="text-sm text-gray-500">@yield('page-description', 'Welcome to your admin dashboard')</p>
                    </div>
                </div>

                <div class="flex items-center space-x-4">
                    <!-- Notifications -->
                    <button class="p-2 rounded-lg hover:bg-gray-100 transition-colors relative">
                        <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5-5V9a9 9 0 10-6 8.46V17z"></path>
                        </svg>
                        <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
                    </button>

                    <!-- Admin Profile -->
                    <div x-data="{ open: false }" class="relative">
                        <button @click="open = !open" class="flex items-center space-x-3 p-2 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center">
                                <span class="text-sm font-medium text-white">
                                    {{ substr(auth('admin')->user()->name, 0, 1) }}
                                </span>
                            </div>
                            <div class="hidden md:block text-left">
                                <p class="text-sm font-medium text-gray-900">{{ auth('admin')->user()->name }}</p>
                                <p class="text-xs text-gray-500">{{ ucfirst(auth('admin')->user()->role) }}</p>
                            </div>
                            <svg class="w-4 h-4 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>

                        <div x-show="open" @click.away="open = false" x-transition 
                             class="absolute right-0 mt-2 w-56 bg-white rounded-lg shadow-lg border border-gray-200 py-2">
                            <div class="px-4 py-2 border-b border-gray-100">
                                <p class="text-sm font-medium text-gray-900">{{ auth('admin')->user()->name }}</p>
                                <p class="text-xs text-gray-500">{{ auth('admin')->user()->email }}</p>
                            </div>
                            <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                                <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                                Profile Settings
                            </a>
                            <form method="POST" action="{{ route('admin.logout') }}">
                                @csrf
                                <button type="submit" class="flex items-center w-full px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                                    <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                                    </svg>
                                    Sign Out
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Main Content -->
            <main class="flex-1 overflow-auto p-6">
                @if(session('success'))
                    <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 text-green-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <p class="text-green-800">{{ session('success') }}</p>
                        </div>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 text-red-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <p class="text-red-800">{{ session('error') }}</p>
                        </div>
                    </div>
                @endif

                @if($errors->any())
                    <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg">
                        <div class="flex items-start">
                            <svg class="w-5 h-5 text-red-600 mr-3 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div class="flex-1">
                                @if($errors->has('error') && is_array($errors->get('error')))
                                    {{-- Enhanced error handling for structured errors --}}
                                    @php
                                        $errorData = $errors->get('error')[0];
                                        $isStructuredError = is_array($errorData) || (is_string($errorData) && isset($errors->get('config_errors')[0]));
                                    @endphp
                                    
                                    @if($isStructuredError)
                                        <p class="text-red-800 font-medium mb-2">Configuration Error:</p>
                                        <p class="text-red-700 text-sm mb-2">{{ is_array($errorData) ? $errorData['message'] ?? $errorData[0] : $errorData }}</p>
                                        
                                        @if($errors->has('config_errors'))
                                            <ul class="list-disc list-inside space-y-1 mb-3">
                                                @foreach($errors->get('config_errors')[0] as $configError)
                                                    <li class="text-red-700 text-sm">{{ $configError }}</li>
                                                @endforeach
                                            </ul>
                                        @endif
                                        
                                        @if($errors->has('config_url'))
                                            <a href="{{ $errors->get('config_url')[0] }}" 
                                               class="inline-flex items-center px-3 py-1 bg-red-600 text-white text-sm rounded-lg hover:bg-red-700 transition-colors">
                                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                </svg>
                                                Fix Configuration
                                            </a>
                                        @endif
                                    @else
                                        <p class="text-red-800 font-medium mb-2">Please fix the following errors:</p>
                                        <ul class="list-disc list-inside space-y-1">
                                            @foreach($errors->all() as $error)
                                                <li class="text-red-700 text-sm">{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    @endif
                                @else
                                    {{-- Standard error handling --}}
                                    <p class="text-red-800 font-medium mb-2">Please fix the following errors:</p>
                                    <ul class="list-disc list-inside space-y-1">
                                        @foreach($errors->all() as $error)
                                            <li class="text-red-700 text-sm">{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif

                @yield('content')
            </main>
        </div>
    </div>

    <!-- Mobile sidebar overlay -->
    <div x-show="sidebarOpen" @click="sidebarOpen = false" 
         class="md:hidden fixed inset-0 bg-black bg-opacity-50 z-30" 
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"></div>
</body>
</html>