<?php $__env->startSection('title', 'Verify Phone Number'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Verify your phone number to secure your SwiftPay account.">
<meta name="keywords" content="SwiftPay phone verification, account security">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen flex">
    <!-- Left side - Verification Form -->
    <div class="flex-1 flex items-center justify-center px-4 sm:px-6 lg:px-20 xl:px-24">
        <div class="mx-auto w-full max-w-sm lg:w-96">
            <div class="text-center mb-8">
                <div class="flex justify-center mb-6">
                    <div class="w-16 h-16 bg-green-600 rounded-full flex items-center justify-center">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                    </div>
                </div>
                <h2 class="text-3xl font-bold text-gray-900 mb-2">SwiftPay</h2>
                <h1 class="text-2xl font-semibold text-gray-700">Verify Your Phone</h1>
                <p class="text-gray-600 mt-2">
                    We've sent a 6-digit verification code to your phone number: 
                    <span class="font-semibold text-gray-900"><?php echo e(auth()->user()->phone); ?></span>
                </p>
            </div>
            
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="w-5 h-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-green-700"><?php echo e(session('success')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="<?php echo e(route('verify.phone')); ?>" class="space-y-6">
                <?php echo csrf_field(); ?>
                
                <div>
                    <label for="otp" class="block text-sm font-medium text-gray-700 mb-2">
                        Verification Code
                    </label>
                    <input id="otp" type="text" name="otp" value="<?php echo e(old('otp')); ?>" 
                           class="w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-green-500 <?php $__errorArgs = ['otp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> text-center text-2xl font-mono tracking-widest" 
                           placeholder="123456"
                           maxlength="6"
                           pattern="[0-9]{6}"
                           required autofocus>
                    <?php $__errorArgs = ['otp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <p class="mt-2 text-sm text-gray-500">Enter the 6-digit code sent to your phone</p>
                </div>

                <div>
                    <button type="submit" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition duration-200">
                        Verify Phone Number
                    </button>
                </div>
            </form>

            <!-- Resend Code -->
            <div class="mt-6 text-center">
                <p class="text-gray-600 text-sm">
                    Didn't receive the code? 
                    <button type="button" onclick="resendCode()" id="resend-btn" class="font-medium text-green-600 hover:text-green-500 transition duration-200">
                        Resend Code
                    </button>
                </p>
                <p class="text-xs text-gray-500 mt-2" id="countdown"></p>
            </div>

            <!-- Wrong Number -->
            <div class="mt-6 text-center">
                <p class="text-gray-600 text-sm">
                    Wrong phone number? 
                    <a href="<?php echo e(route('logout')); ?>" 
                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                       class="font-medium text-blue-600 hover:text-blue-500 transition duration-200">
                        Start over
                    </a>
                </p>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
                    <?php echo csrf_field(); ?>
                </form>
            </div>

            <!-- Security Notice -->
            <div class="mt-8 p-4 bg-blue-50 rounded-lg">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <svg class="w-5 h-5 text-blue-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-blue-800">Why verify your phone?</h3>
                        <p class="text-sm text-blue-700 mt-1">
                            Phone verification adds an extra layer of security and helps us notify you of important account activities.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Right side - Illustration (hidden on mobile) -->
    <div class="hidden lg:block relative w-0 flex-1">
        <div class="absolute inset-0 h-full w-full bg-gradient-to-br from-green-600 via-green-700 to-blue-700">
            <div class="h-full w-full flex items-center justify-center p-12">
                <div class="max-w-md text-center text-white">
                    <div class="w-24 h-24 mx-auto mb-8 bg-white/10 rounded-full flex items-center justify-center">
                        <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-4">Almost There!</h3>
                    <p class="text-green-100 text-lg">
                        Just one more step to secure your SwiftPay account. Verify your phone number to get started with instant transfers and payments.
                    </p>
                    <div class="mt-8 space-y-3">
                        <div class="flex items-center justify-center space-x-2">
                            <svg class="w-5 h-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span>Account created successfully</span>
                        </div>
                        <div class="flex items-center justify-center space-x-2">
                            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                            </svg>
                            <span>Phone verification in progress</span>
                        </div>
                        <div class="flex items-center justify-center space-x-2 opacity-50">
                            <div class="w-5 h-5 border-2 border-gray-300 rounded-full"></div>
                            <span>Complete KYC verification</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let countdown = 60;
let resendTimer;

function startCountdown() {
    const resendBtn = document.getElementById('resend-btn');
    const countdownEl = document.getElementById('countdown');
    
    resendBtn.style.opacity = '0.5';
    resendBtn.style.pointerEvents = 'none';
    
    resendTimer = setInterval(function() {
        countdownEl.textContent = `Resend available in ${countdown} seconds`;
        countdown--;
        
        if (countdown < 0) {
            clearInterval(resendTimer);
            resendBtn.style.opacity = '1';
            resendBtn.style.pointerEvents = 'auto';
            countdownEl.textContent = '';
            countdown = 60;
        }
    }, 1000);
}

function resendCode() {
    // In a real implementation, this would make an AJAX call to resend the OTP
    alert('Verification code has been resent to your phone number.');
    startCountdown();
}

// Auto-focus and format OTP input
document.getElementById('otp').addEventListener('input', function(e) {
    e.target.value = e.target.value.replace(/[^0-9]/g, '');
});

// Start countdown on page load
document.addEventListener('DOMContentLoaded', function() {
    startCountdown();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/runner/work/Fintech/Fintech/resources/views/auth/verify-phone.blade.php ENDPATH**/ ?>