<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->enum('category', ['airtime', 'data', 'electricity', 'cable_tv', 'internet']);
            $table->string('provider_code')->nullable(); // VTPass service code
            $table->string('provider_name')->nullable();
            $table->json('available_amounts')->nullable(); // Predefined amounts
            $table->decimal('minimum_amount', 15, 2)->nullable();
            $table->decimal('maximum_amount', 15, 2)->nullable();
            $table->decimal('commission_percentage', 5, 2)->default(0.00);
            $table->decimal('commission_cap', 15, 2)->nullable();
            $table->boolean('is_active')->default(true);
            $table->json('metadata')->nullable(); // Additional service data
            $table->timestamps();
            
            $table->index(['category', 'is_active']);
            $table->index('provider_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};