@extends('layouts.app')

@section('title', 'AbokiPay – Your Trusted Digital Wallet Partner | Send Money, Buy Airtime, Get Virtual Cards in Nigeria')

@section('meta')
<meta name="description" content="AbokiPay is your trusted digital wallet partner for Nigerians. Send money, receive virtual bank accounts, buy data & airtime, and issue virtual cards with African-inspired fintech excellence.">
<meta name="keywords" content="fintech, Nigeria, digital wallet, send money, virtual cards, airtime, data, bill payment, African fintech, trusted partner">
<meta property="og:title" content="AbokiPay – Your Trusted Digital Wallet Partner">
<meta property="og:description" content="Experience modern African fintech with AbokiPay. Send money, buy airtime, get virtual cards and more with our secure and trusted platform.">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url('/') }}">
@endsection

@section('content')
<!-- Hero Section -->
<section class="bg-gradient-to-br from-aboki-primary via-aboki-primary-dark to-aboki-bg-dark text-white py-20 relative overflow-hidden">
    <div class="absolute inset-0 bg-black opacity-10"></div>
    <!-- African-inspired geometric patterns -->
    <div class="absolute inset-0 opacity-5">
        <svg class="w-full h-full" viewBox="0 0 400 400" fill="none" xmlns="http://www.w3.org/2000/svg">
            <pattern id="african-pattern" x="0" y="0" width="100" height="100" patternUnits="userSpaceOnUse">
                <circle cx="50" cy="50" r="30" stroke="currentColor" stroke-width="2" fill="none" opacity="0.3"/>
                <polygon points="50,20 70,50 50,80 30,50" stroke="currentColor" stroke-width="1" fill="none" opacity="0.2"/>
            </pattern>
            <rect width="100%" height="100%" fill="url(#african-pattern)"/>
        </svg>
    </div>
    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col lg:flex-row items-center">
            <div class="lg:w-1/2 text-center lg:text-left mb-10 lg:mb-0">
                <h1 class="text-4xl md:text-6xl font-bold mb-6 leading-tight font-Poppins">
                    Your Trusted 
                    <span class="text-aboki-secondary">Digital Wallet</span> 
                    Partner
                </h1>
                <p class="text-xl md:text-2xl mb-8 text-blue-100 font-Inter">
                    Experience modern African fintech excellence. Send money instantly, buy airtime & data, get virtual cards, and enjoy bank-level security – all with Afrocentric innovation.
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                    <a href="{{ route('register') }}" class="bg-aboki-secondary hover:bg-aboki-secondary-dark text-white font-bold py-4 px-8 rounded-full text-lg transition duration-300 transform hover:scale-105 shadow-lg">
                        Start Your Journey
                    </a>
                    <a href="{{ route('login') }}" class="border-2 border-white hover:bg-white hover:text-aboki-primary text-white font-bold py-4 px-8 rounded-full text-lg transition duration-300">
                        Sign In
                    </a>
                </div>
                <div class="mt-8 flex items-center justify-center lg:justify-start space-x-6 text-sm">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-aboki-secondary mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Trusted by thousands</span>
                    </div>
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-aboki-secondary mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>African excellence</span>
                    </div>
                </div>
            </div>
            <div class="lg:w-1/2 flex justify-center">
                <div class="relative">
                    <!-- Placeholder for African-inspired fintech illustration -->
                    <div class="max-w-md w-full h-96 bg-gradient-to-br from-aboki-secondary to-aboki-primary rounded-2xl shadow-2xl flex items-center justify-center">
                        <div class="text-center text-white p-8">
                            <div class="w-24 h-24 mx-auto mb-4 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                                <svg class="w-12 h-12" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                                </svg>
                            </div>
                            <h3 class="text-xl font-bold mb-2">AbokiPay</h3>
                            <p class="text-sm opacity-90">Mobile Banking Illustration</p>
                        </div>
                    </div>
                    <!-- Decorative elements -->
                    <div class="absolute -top-4 -right-4 w-8 h-8 bg-aboki-secondary rounded-full opacity-60"></div>
                    <div class="absolute -bottom-4 -left-4 w-6 h-6 bg-aboki-secondary rounded-full opacity-40"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Overview -->
<section class="py-20 bg-aboki-bg-light">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-aboki-text-primary mb-4 font-Poppins">
                Everything You Need in One App
            </h2>
            <p class="text-xl text-aboki-text-secondary max-w-2xl mx-auto font-Inter">
                Experience seamless African fintech innovation with our comprehensive suite of financial services designed for modern Nigeria.
            </p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="bg-white rounded-xl p-8 shadow-lg hover:shadow-xl transition duration-300 text-center border border-gray-100">
                <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-aboki-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Send & Receive Money</h3>
                <p class="text-aboki-text-secondary font-Inter">Transfer money instantly to any bank account or AbokiPay user. Fast, secure, and affordable with African innovation.</p>
            </div>

            <div class="bg-white rounded-xl p-8 shadow-lg hover:shadow-xl transition duration-300 text-center border border-gray-100">
                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-aboki-secondary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Virtual Cards</h3>
                <p class="text-aboki-text-secondary font-Inter">Get instant virtual cards for online shopping and international payments with smart spending controls.</p>
            </div>

            <div class="bg-white rounded-xl p-8 shadow-lg hover:shadow-xl transition duration-300 text-center border border-gray-100">
                <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-aboki-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Virtual Account</h3>
                <p class="text-aboki-text-secondary font-Inter">Get your dedicated bank account number to receive money from any Nigerian bank instantly.</p>
            </div>

            <div class="bg-white rounded-xl p-8 shadow-lg hover:shadow-xl transition duration-300 text-center border border-gray-100">
                <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-aboki-secondary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Buy Airtime & Data</h3>
                <p class="text-aboki-text-secondary font-Inter">Recharge airtime and buy data for all networks - MTN, Glo, Airtel, and 9mobile instantly.</p>
            </div>

            <div class="bg-white rounded-xl p-8 shadow-lg hover:shadow-xl transition duration-300 text-center border border-gray-100">
                <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-aboki-error" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Pay Bills</h3>
                <p class="text-aboki-text-secondary font-Inter">Pay for electricity, cable TV, internet subscriptions and more with just a few taps.</p>
            </div>

            <div class="bg-white rounded-xl p-8 shadow-lg hover:shadow-xl transition duration-300 text-center border border-gray-100">
                <div class="w-16 h-16 bg-indigo-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-aboki-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Bank-Level Security</h3>
                <p class="text-aboki-text-secondary font-Inter">Your money and data are protected with enterprise-grade security and fraud monitoring.</p>
            </div>
        </div>
    </div>
</section>

<!-- How It Works -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-aboki-text-primary mb-4 font-Poppins">
                Get Started in Minutes
            </h2>
            <p class="text-xl text-aboki-text-secondary max-w-2xl mx-auto font-Inter">
                Join thousands of Nigerians who have embraced modern African fintech with AbokiPay.
            </p>
        </div>
        
        <div class="grid md:grid-cols-4 gap-8">
            <div class="text-center">
                <div class="w-20 h-20 bg-aboki-primary rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
                    <span class="text-2xl font-bold text-white">1</span>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Sign Up</h3>
                <p class="text-aboki-text-secondary font-Inter">Create your free AbokiPay account with just your email and phone number.</p>
            </div>

            <div class="text-center">
                <div class="w-20 h-20 bg-aboki-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
                    <span class="text-2xl font-bold text-white">2</span>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Verify Identity</h3>
                <p class="text-aboki-text-secondary font-Inter">Complete your KYC verification with your BVN or NIN for enhanced security.</p>
            </div>

            <div class="text-center">
                <div class="w-20 h-20 bg-aboki-primary rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
                    <span class="text-2xl font-bold text-white">3</span>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Fund Wallet</h3>
                <p class="text-aboki-text-secondary font-Inter">Add money to your wallet via bank transfer, card payment, or your virtual account.</p>
            </div>

            <div class="text-center">
                <div class="w-20 h-20 bg-aboki-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
                    <span class="text-2xl font-bold text-white">4</span>
                </div>
                <h3 class="text-xl font-bold text-aboki-text-primary mb-4 font-Poppins">Use Services</h3>
                <p class="text-aboki-text-secondary font-Inter">Send money, buy airtime, get virtual cards, and pay bills instantly.</p>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials -->
<section class="py-20 bg-aboki-bg-light">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-aboki-text-primary mb-4 font-Poppins">
                What Our Users Say
            </h2>
            <p class="text-xl text-aboki-text-secondary font-Inter">
                Trusted by thousands of Nigerians for their daily financial needs.
            </p>
        </div>
        
        <div class="grid md:grid-cols-3 gap-8">
            <div class="bg-white rounded-xl p-8 shadow-lg border border-gray-100">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-aboki-primary rounded-full flex items-center justify-center mr-4">
                        <span class="text-lg font-bold text-white">AM</span>
                    </div>
                    <div>
                        <h4 class="font-bold text-aboki-text-primary font-Poppins">Adebayo Musa</h4>
                        <p class="text-aboki-text-secondary text-sm font-Inter">Lagos, Nigeria</p>
                    </div>
                </div>
                <div class="flex text-aboki-secondary mb-4">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                </div>
                <p class="text-aboki-text-secondary font-Inter">"AbokiPay has made sending money to my family so easy. The virtual cards work perfectly for my online shopping, and the customer support is excellent with true African hospitality!"</p>
            </div>

            <div class="bg-white rounded-xl p-8 shadow-lg">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-gray-300 rounded-full flex items-center justify-center mr-4">
                        <span class="text-lg font-bold text-gray-600">FO</span>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900">Funmi Okafor</h4>
                        <p class="text-gray-600 text-sm">Abuja, Nigeria</p>
                    </div>
                </div>
                <div class="flex text-yellow-400 mb-4">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                </div>
                <p class="text-gray-700">"As a small business owner, SwiftPay helps me pay my bills and manage cash flow effortlessly. The transaction fees are very reasonable too."</p>
            </div>

            <div class="bg-white rounded-xl p-8 shadow-lg">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-gray-300 rounded-full flex items-center justify-center mr-4">
                        <span class="text-lg font-bold text-gray-600">CI</span>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900">Chinedu Ikwu</h4>
                        <p class="text-gray-600 text-sm">Port Harcourt, Nigeria</p>
                    </div>
                </div>
                <div class="flex text-yellow-400 mb-4">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path></svg>
                </div>
                <p class="text-gray-700">"The security features give me peace of mind. I love that I can freeze my virtual card instantly if needed, and the transaction notifications are instant."</p>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-aboki-text-primary mb-4 font-Poppins">
                Frequently Asked Questions
            </h2>
            <p class="text-xl text-aboki-text-secondary font-Inter">
                Get answers to common questions about AbokiPay.
            </p>
        </div>
        
        <div class="max-w-3xl mx-auto">
            <div class="space-y-6">
                <div class="bg-aboki-bg-light rounded-lg p-6 border border-gray-200">
                    <h3 class="text-lg font-bold text-aboki-text-primary mb-3 font-Poppins">Is my money safe with AbokiPay?</h3>
                    <p class="text-aboki-text-secondary font-Inter">Yes, absolutely. AbokiPay uses bank-grade security measures including SSL encryption, two-factor authentication, and fraud monitoring. Your funds are protected and we never store your sensitive financial information.</p>
                </div>

                <div class="bg-aboki-bg-light rounded-lg p-6 border border-gray-200">
                    <h3 class="text-lg font-bold text-aboki-text-primary mb-3 font-Poppins">How do I get a virtual card?</h3>
                    <p class="text-aboki-text-secondary font-Inter">After completing your KYC verification, you can instantly create virtual cards from your dashboard. You can set spending limits, freeze/unfreeze cards, and use them for online payments worldwide.</p>
                </div>

                <div class="bg-aboki-bg-light rounded-lg p-6 border border-gray-200">
                    <h3 class="text-lg font-bold text-aboki-text-primary mb-3 font-Poppins">What are the transaction fees?</h3>
                    <p class="text-aboki-text-secondary font-Inter">AbokiPay offers competitive rates: ₦10 for bank transfers, ₦25 for virtual card creation, and ₦5 for bill payments. P2P transfers between AbokiPay users are completely free.</p>
                </div>

                <div class="bg-aboki-bg-light rounded-lg p-6 border border-gray-200">
                    <h3 class="text-lg font-bold text-aboki-text-primary mb-3 font-Poppins">How long does it take to receive money?</h3>
                    <p class="text-aboki-text-secondary font-Inter">Transfers between AbokiPay users are instant. Bank transfers typically process within 2-5 minutes, while virtual account funding reflects immediately once the bank transfer is completed.</p>
                </div>

                <div class="bg-aboki-bg-light rounded-lg p-6 border border-gray-200">
                    <h3 class="text-lg font-bold text-aboki-text-primary mb-3 font-Poppins">Can I use AbokiPay for international payments?</h3>
                    <p class="text-aboki-text-secondary font-Inter">Yes! Our virtual cards work for international online payments. You can shop on international websites and pay for services worldwide with our USD virtual cards.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Final Call to Action -->
<section class="py-20 bg-gradient-to-r from-aboki-primary to-aboki-bg-dark text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-6 font-Poppins">
            Ready to Experience African Fintech Excellence?
        </h2>
        <p class="text-xl mb-8 max-w-2xl mx-auto font-Inter">
            Join over 50,000 Nigerians who have already embraced modern financial solutions with AbokiPay.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('register') }}" class="bg-aboki-secondary hover:bg-aboki-secondary-dark text-white font-bold py-4 px-8 rounded-full text-lg transition duration-300 transform hover:scale-105 shadow-lg">
                Start Your Journey Today
            </a>
            <a href="#features" class="border-2 border-white hover:bg-white hover:text-aboki-primary text-white font-bold py-4 px-8 rounded-full text-lg transition duration-300">
                Learn More
            </a>
        </div>
        <div class="mt-8 flex items-center justify-center space-x-6 text-sm">
            <div class="flex items-center">
                <svg class="w-5 h-5 text-aboki-secondary mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                </svg>
                <span>Transparent pricing</span>
            </div>
            <div class="flex items-center">
                <svg class="w-5 h-5 text-aboki-secondary mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                </svg>
                <span>Setup in 5 minutes</span>
            </div>
            <div class="flex items-center">
                <svg class="w-5 h-5 text-aboki-secondary mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                </svg>
                <span>African excellence</span>
            </div>
        </div>
    </div>
</section>

<!-- Footer -->
<footer class="bg-gray-900 text-white py-16">
    <div class="container mx-auto px-4">
        <div class="grid md:grid-cols-4 gap-8">
            <div>
                <h3 class="text-2xl font-bold mb-6 font-Poppins">AbokiPay</h3>
                <p class="text-gray-400 mb-6 font-Inter">
                    Your trusted digital wallet partner making African fintech excellence accessible to every Nigerian.
                </p>
                <div class="flex space-x-4">
                    <a href="#" class="text-gray-400 hover:text-white transition duration-300">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"/>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition duration-300">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M22.46 6c-.77.35-1.6.58-2.46.69.88-.53 1.56-1.37 1.88-2.38-.83.5-1.75.85-2.72 1.05C18.37 4.5 17.26 4 16 4c-2.35 0-4.27 1.92-4.27 4.29 0 .34.04.67.11.98C8.28 9.09 5.11 7.38 3 4.79c-.37.63-.58 1.37-.58 2.15 0 1.49.75 2.81 1.91 3.56-.71 0-1.37-.2-1.95-.5v.03c0 2.08 1.48 3.82 3.44 4.21a4.22 4.22 0 0 1-1.93.07 4.28 4.28 0 0 0 4 2.98 8.521 8.521 0 0 1-5.33 1.84c-.34 0-.68-.02-1.02-.06C3.44 20.29 5.7 21 8.12 21 16 21 20.33 14.46 20.33 8.79c0-.19 0-.37-.01-.56.84-.6 1.56-1.36 2.14-2.23z"/>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition duration-300">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.746-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24.009c6.624 0 11.99-5.367 11.99-11.988C24.007 5.367 18.641.001.012.001z"/>
                        </svg>
                    </a>
                </div>
            </div>
            
            <div>
                <h4 class="text-lg font-bold mb-6">Services</h4>
                <ul class="space-y-3 text-gray-400">
                    <li><a href="#" class="hover:text-white transition duration-300">Send Money</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Virtual Cards</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Bill Payments</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Airtime & Data</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Virtual Accounts</a></li>
                </ul>
            </div>
            
            <div>
                <h4 class="text-lg font-bold mb-6">Company</h4>
                <ul class="space-y-3 text-gray-400">
                    <li><a href="#" class="hover:text-white transition duration-300">About Us</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Contact</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Careers</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Blog</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Press</a></li>
                </ul>
            </div>
            
            <div>
                <h4 class="text-lg font-bold mb-6">Legal</h4>
                <ul class="space-y-3 text-gray-400">
                    <li><a href="#" class="hover:text-white transition duration-300">Terms of Service</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Privacy Policy</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Cookie Policy</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Security</a></li>
                    <li><a href="#" class="hover:text-white transition duration-300">Compliance</a></li>
                </ul>
            </div>
        </div>
        
        <div class="border-t border-gray-700 mt-12 pt-8 text-center text-gray-400 font-Inter">
            <p>&copy; {{ date('Y') }} AbokiPay. All rights reserved. Made with ❤️ for Nigeria.</p>
            <p class="mt-2 text-sm">Licensed by CBN • Powered by Laravel • African Fintech Excellence</p>
        </div>
    </div>
</footer>
@endsection