<?php

namespace App\Services;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class SmsService
{
    protected $username;
    protected $password;

    public function __construct()
    {
        $this->username = config('services.sms.username');
        $this->password = config('services.sms.password');
    }

    /**
     * Send OTP to phone number.
     */
    public function sendOtp(string $phone): bool
    {
        $otp = $this->generateOtp();
        $message = "Your Nigerian Fintech Platform verification code is: {$otp}. Valid for 10 minutes.";

        // Store OTP in cache for 10 minutes
        Cache::put("otp_{$phone}", $otp, 600);

        // In development, log the OTP instead of sending
        if (config('app.env') === 'local') {
            Log::info("OTP for {$phone}: {$otp}");
            return true;
        }

        // TODO: Implement actual SMS sending logic
        // This is a stub for SMS provider integration
        try {
            // Example implementation would be:
            // return $this->sendSms($phone, $message);
            
            Log::info("SMS sent to {$phone}: {$message}");
            return true;
        } catch (\Exception $e) {
            Log::error("Failed to send SMS to {$phone}: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Verify OTP for phone number.
     */
    public function verifyOtp(string $phone, string $otp): bool
    {
        $storedOtp = Cache::get("otp_{$phone}");
        
        if ($storedOtp && $storedOtp === $otp) {
            Cache::forget("otp_{$phone}");
            return true;
        }

        return false;
    }

    /**
     * Generate 6-digit OTP.
     */
    protected function generateOtp(): string
    {
        return str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
    }

    /**
     * Send SMS message (stub implementation).
     */
    protected function sendSms(string $phone, string $message): bool
    {
        // TODO: Implement actual SMS API call
        // Example with popular Nigerian SMS providers:
        
        // For Termii
        // $response = Http::post('https://api.ng.termii.com/api/sms/send', [
        //     'to' => $phone,
        //     'from' => 'N-Alert',
        //     'sms' => $message,
        //     'type' => 'plain',
        //     'channel' => 'dnd',
        //     'api_key' => config('services.termii.api_key'),
        // ]);
        
        // For BulkSMS Nigeria
        // $response = Http::post('https://www.bulksmsnigeria.com/api/v1/sms/create', [
        //     'api_token' => config('services.bulksms.api_token'),
        //     'from' => config('services.bulksms.from'),
        //     'to' => $phone,
        //     'body' => $message,
        // ]);

        return true;
    }
}