<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Show the application dashboard.
     */
    public function index()
    {
        $user = Auth::user();
        $wallet = $user->wallet;
        $recentTransactions = $user->transactions()
            ->latest()
            ->limit(5)
            ->get();

        return view('dashboard', compact('user', 'wallet', 'recentTransactions'));
    }
}