<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as payment gateways, SMS providers, KYC providers, etc.
    |
    */

    'paystack' => [
        'public_key' => env('PAYSTACK_PUBLIC_KEY'),
        'secret_key' => env('PAYSTACK_SECRET_KEY'),
        'base_url' => env('PAYSTACK_PAYMENT_URL', 'https://api.paystack.co'),
        'merchant_email' => env('PAYSTACK_MERCHANT_EMAIL'),
    ],

    'monnify' => [
        'api_key' => env('MONNIFY_API_KEY'),
        'secret_key' => env('MONNIFY_SECRET_KEY'),
        'contract_code' => env('MONNIFY_CONTRACT_CODE'),
        'base_url' => env('MONNIFY_BASE_URL', 'https://api.monnify.com'),
    ],

    'anchor' => [
        'secret_key' => env('ANCHOR_SECRET_KEY'),
        'public_key' => env('ANCHOR_PUBLIC_KEY'),
        'base_url' => env('ANCHOR_BASE_URL', 'https://api.getanchor.co'),
    ],

    'vtpass' => [
        'username' => env('VTPASS_USERNAME'),
        'password' => env('VTPASS_PASSWORD'),
        'base_url' => env('VTPASS_BASE_URL', 'https://vtpass.com/api'),
    ],

    'dojah' => [
        'app_id' => env('DOJAH_APP_ID'),
        'secret_key' => env('DOJAH_SECRET_KEY'),
        'base_url' => env('DOJAH_BASE_URL', 'https://api.dojah.io'),
    ],

    'verifyme' => [
        'username' => env('VERIFYME_USERNAME'),
        'password' => env('VERIFYME_PASSWORD'),
        'base_url' => env('VERIFYME_BASE_URL', 'https://api.verifymy.co.uk'),
    ],

    'bloc' => [
        'secret_key' => env('BLOC_SECRET_KEY'),
        'public_key' => env('BLOC_PUBLIC_KEY'),
        'base_url' => env('BLOC_BASE_URL', 'https://api.blochq.io'),
    ],

    'wallets_africa' => [
        'public_key' => env('WALLETS_AFRICA_PUBLIC_KEY'),
        'secret_key' => env('WALLETS_AFRICA_SECRET_KEY'),
        'base_url' => env('WALLETS_AFRICA_BASE_URL', 'https://api.wallets.africa'),
    ],

    'sms' => [
        'driver' => env('SMS_DRIVER', 'log'),
        'username' => env('SMS_USERNAME'),
        'password' => env('SMS_PASSWORD'),
        'from' => env('SMS_FROM', 'Fintech'),
    ],
];