@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="grid lg:grid-cols-3 gap-6">
    <!-- Wallet Overview -->
    <div class="lg:col-span-2">
        <div class="card">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-bold">Wallet Overview</h2>
                <div class="text-right">
                    <p class="text-sm text-gray-600">Available Balance</p>
                    <p class="text-2xl font-bold text-green-600">₦{{ number_format($wallet?->available_balance ?? 0, 2) }}</p>
                </div>
            </div>
            
            <div class="grid md:grid-cols-3 gap-4 mb-4">
                <div class="bg-gray-50 rounded-lg p-4">
                    <p class="text-sm text-gray-600">Total Balance</p>
                    <p class="text-lg font-semibold">₦{{ number_format($wallet?->balance ?? 0, 2) }}</p>
                </div>
                <div class="bg-gray-50 rounded-lg p-4">
                    <p class="text-sm text-gray-600">Locked Balance</p>
                    <p class="text-lg font-semibold">₦{{ number_format($wallet?->locked_balance ?? 0, 2) }}</p>
                </div>
                <div class="bg-gray-50 rounded-lg p-4">
                    <p class="text-sm text-gray-600">Daily Limit Remaining</p>
                    <p class="text-lg font-semibold">₦{{ number_format($wallet?->remaining_daily_limit ?? 0, 2) }}</p>
                </div>
            </div>

            <div class="flex flex-wrap gap-2">
                <a href="{{ route('wallet.fund') }}" class="btn-primary">Fund Wallet</a>
                <a href="{{ route('transfer.p2p') }}" class="btn-secondary">Send Money</a>
                <a href="{{ route('transfer.bank') }}" class="btn-secondary">Bank Transfer</a>
                <a href="{{ route('bills.index') }}" class="btn-secondary">Pay Bills</a>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div>
        @if(!auth()->user()->hasCompletedKyc())
        <div class="card bg-yellow-50 border-yellow-200">
            <h3 class="text-lg font-bold text-yellow-800 mb-2">Complete KYC Verification</h3>
            <p class="text-yellow-700 text-sm mb-4">
                Verify your identity to unlock all features and increase your transaction limits.
            </p>
            <a href="{{ route('kyc.index') }}" class="btn-primary">Complete KYC</a>
        </div>
        @endif

        <div class="card">
            <h3 class="text-lg font-bold mb-4">Quick Actions</h3>
            <div class="space-y-2">
                <a href="{{ route('bills.airtime') }}" class="block w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg">
                    📱 Buy Airtime
                </a>
                <a href="{{ route('bills.data') }}" class="block w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg">
                    📶 Buy Data
                </a>
                <a href="{{ route('bills.electricity') }}" class="block w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg">
                    ⚡ Pay Electricity
                </a>
                <a href="{{ route('virtual-account.index') }}" class="block w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg">
                    🏦 Virtual Accounts
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="card mt-6">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-xl font-bold">Recent Transactions</h2>
        <a href="{{ route('transactions.index') }}" class="text-blue-600 hover:text-blue-800 text-sm">View All</a>
    </div>
    
    @if($recentTransactions && $recentTransactions->count() > 0)
        <div class="space-y-3">
            @foreach($recentTransactions as $transaction)
            <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                <div>
                    <p class="font-medium">{{ $transaction->description }}</p>
                    <p class="text-sm text-gray-600">{{ $transaction->created_at->format('M d, Y H:i') }}</p>
                </div>
                <div class="text-right">
                    <p class="font-semibold {{ $transaction->type === 'credit' ? 'text-green-600' : 'text-red-600' }}">
                        {{ $transaction->type === 'credit' ? '+' : '-' }}₦{{ number_format($transaction->amount, 2) }}
                    </p>
                    <p class="text-sm text-gray-600 capitalize">{{ $transaction->status }}</p>
                </div>
            </div>
            @endforeach
        </div>
    @else
        <div class="text-center py-8 text-gray-500">
            <p>No transactions yet</p>
            <p class="text-sm">Fund your wallet to get started</p>
        </div>
    @endif
</div>
@endsection