<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(config('app.name', 'Fintech Platform')); ?> Admin</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Custom CSS -->
    <style>
        .btn-primary {
            @apply bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-secondary {
            @apply bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-success {
            @apply bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .btn-danger {
            @apply bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline;
        }
        .form-input {
            @apply shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline;
        }
        .card {
            @apply bg-white shadow-lg rounded-lg p-6 mb-4;
        }
    </style>
</head>
<body class="bg-gray-100 font-sans antialiased">
    <div id="app" class="min-h-screen flex flex-col">
        <!-- Header -->
        <?php if(auth()->guard('admin')->check()): ?>
        <header class="bg-gray-800 text-white shadow-md">
            <div class="container mx-auto px-4 py-3">
                <div class="flex justify-between items-center">
                    <div class="flex items-center">
                        <h1 class="text-xl font-bold"><?php echo e(config('app.name')); ?> Admin</h1>
                    </div>
                    <div class="flex items-center space-x-4">
                        <span class="text-sm"><?php echo e(auth('admin')->user()->name); ?></span>
                        <span class="text-xs text-gray-300">(<?php echo e(auth('admin')->user()->role); ?>)</span>
                        <button class="md:hidden" onclick="toggleMobileMenu()">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </header>

        <!-- Navigation -->
        <nav class="bg-gray-700 text-white shadow-md">
            <div class="container mx-auto px-4">
                <div class="hidden md:flex space-x-6 py-2">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="hover:text-gray-200 py-2">Dashboard</a>
                    <a href="#" class="hover:text-gray-200 py-2">Users</a>
                    <a href="#" class="hover:text-gray-200 py-2">KYC Requests</a>
                    <a href="#" class="hover:text-gray-200 py-2">Transactions</a>
                    <a href="#" class="hover:text-gray-200 py-2">Reports</a>
                    <form method="POST" action="<?php echo e(route('admin.logout')); ?>" class="inline-block ml-4">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="hover:text-gray-200 py-2">Logout</button>
                    </form>
                </div>
                <div id="mobile-menu" class="md:hidden hidden">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="block hover:bg-gray-600 px-4 py-2">Dashboard</a>
                    <a href="#" class="block hover:bg-gray-600 px-4 py-2">Users</a>
                    <a href="#" class="block hover:bg-gray-600 px-4 py-2">KYC Requests</a>
                    <a href="#" class="block hover:bg-gray-600 px-4 py-2">Transactions</a>
                    <a href="#" class="block hover:bg-gray-600 px-4 py-2">Reports</a>
                    <form method="POST" action="<?php echo e(route('admin.logout')); ?>" class="block">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full text-left hover:bg-gray-600 px-4 py-2">Logout</button>
                    </form>
                </div>
            </div>
        </nav>
        <?php endif; ?>

        <!-- Main Content -->
        <main class="flex-1 container mx-auto px-4 py-6">
            <?php if(session('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <ul class="list-disc list-inside">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <!-- Footer -->
        <footer class="bg-gray-800 text-white py-4 mt-auto">
            <div class="container mx-auto px-4 text-center">
                <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?> Admin Panel. All rights reserved.</p>
                <p class="text-sm text-gray-400 mt-1">Secure Admin Access</p>
            </div>
        </footer>
    </div>

    <script>
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        }
    </script>
</body>
</html><?php /**PATH /home/runner/work/Fintech/Fintech/resources/views/layouts/admin.blade.php ENDPATH**/ ?>