<div class="border border-gray-200 rounded-lg p-6 hover:shadow-md transition-shadow">
    <div class="flex items-start justify-between mb-4">
        <div>
            <h4 class="text-lg font-semibold text-gray-900">{{ $service->name }}</h4>
            <p class="text-sm text-gray-600 mt-1">{{ $service->description ?? 'No description available' }}</p>
        </div>
        <div class="flex items-center space-x-2">
            @if($service->is_active)
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800">
                    Active
                </span>
            @else
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                    Inactive
                </span>
            @endif
            
            @if($service->is_live_mode)
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                    Live
                </span>
            @else
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-amber-100 text-amber-800">
                    Test
                </span>
            @endif
        </div>
    </div>

    <div class="space-y-3">
        <div class="flex justify-between items-center text-sm">
            <span class="text-gray-600">Base URL:</span>
            <span class="text-gray-900 font-medium">{{ Str::limit($service->effective_base_url, 40) }}</span>
        </div>
        
        <div class="flex justify-between items-center text-sm">
            <span class="text-gray-600">API Key:</span>
            <span class="text-gray-900 font-medium">
                {{ $service->masked_api_key }}
            </span>
        </div>
        
        <div class="flex justify-between items-center text-sm">
            <span class="text-gray-600">Health Status:</span>
            <div id="status-{{ $service->id }}">
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $service->health_status_class }}">
                    {{ $service->health_status_text }}
                    @if(isset($health['response_time']) && $health['response_time'])
                        ({{ $health['response_time'] }}ms)
                    @endif
                </span>
            </div>
        </div>
        
        @if(isset($health['last_check']))
        <div class="flex justify-between items-center text-sm">
            <span class="text-gray-600">Last Checked:</span>
            <span class="text-gray-900 font-medium">{{ $health['last_check']->diffForHumans() }}</span>
        </div>
        @endif
    </div>

    <div class="mt-6 flex items-center justify-between">
        <div class="flex items-center space-x-2">
            <button id="test-{{ $service->id }}" 
                    onclick="testConnection({{ $service->id }}, '{{ $service->name }}')"
                    class="px-3 py-2 bg-blue-600 text-white text-sm rounded-lg hover:bg-blue-700 transition-colors">
                Test Connection
            </button>
            
            <button onclick="toggleStatus({{ $service->id }}, '{{ $service->name }}', {{ $service->is_active ? 'true' : 'false' }})"
                    class="px-3 py-2 {{ $service->is_active ? 'bg-red-600 hover:bg-red-700' : 'bg-emerald-600 hover:bg-emerald-700' }} text-white text-sm rounded-lg transition-colors">
                {{ $service->is_active ? 'Deactivate' : 'Activate' }}
            </button>
            
            <button onclick="toggleMode({{ $service->id }}, '{{ $service->name }}', {{ $service->is_live_mode ? 'true' : 'false' }})"
                    class="px-3 py-2 {{ $service->is_live_mode ? 'bg-amber-600 hover:bg-amber-700' : 'bg-blue-600 hover:bg-blue-700' }} text-white text-sm rounded-lg transition-colors">
                Switch to {{ $service->is_live_mode ? 'Test' : 'Live' }}
            </button>
        </div>
        
        <button onclick="configureService({{ $service->id }}, '{{ $service->name }}')" 
                class="text-purple-600 hover:text-purple-800 text-sm font-medium">
            Configure
        </button>
    </div>
</div>