@extends('layouts.admin-sidebar')

@section('title', 'Fees & Limits Settings')
@section('page-title', 'Fees & Limits Settings')
@section('page-description', 'Configure transaction fees, limits, and requirements')

@section('content')
<div class="space-y-6">
    <!-- Page Actions -->
    <div class="flex justify-end">
        <button onclick="backupSettings()" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white text-sm font-medium rounded-lg hover:bg-gray-700 transition-colors mr-3">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"></path>
            </svg>
            Backup Settings
        </button>
    </div>

    <form method="POST" action="{{ route('admin.settings.fees.update') }}" class="space-y-6">
        @csrf

        <!-- Transaction Fees -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h3 class="text-lg font-semibold text-gray-900">Transaction Fees</h3>
                    <p class="text-sm text-gray-600">Configure fees for different transaction types</p>
                </div>
                <div class="flex items-center">
                    <span class="text-sm text-gray-500 mr-2">Last updated:</span>
                    <span class="text-sm font-medium text-gray-900">2 hours ago</span>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- Transfer Fees -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Transfer Fees</h4>
                    
                    <div>
                        <label for="transfer_fee_type" class="block text-sm font-medium text-gray-700 mb-1">Fee Type</label>
                        <select name="transfer_fee_type" id="transfer_fee_type" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                onchange="toggleTransferFeeInput()">
                            <option value="percentage" {{ $settings['fees']['transfer_fee_type'] === 'percentage' ? 'selected' : '' }}>Percentage</option>
                            <option value="flat" {{ $settings['fees']['transfer_fee_type'] === 'flat' ? 'selected' : '' }}>Flat Amount</option>
                        </select>
                    </div>

                    <div id="percentage_fee" class="{{ $settings['fees']['transfer_fee_type'] === 'percentage' ? '' : 'hidden' }}">
                        <label for="transfer_fee_value" class="block text-sm font-medium text-gray-700 mb-1">Percentage (%)</label>
                        <input type="number" name="transfer_fee_value" id="transfer_fee_value" 
                               value="{{ $settings['fees']['transfer_fee_value'] }}" 
                               step="0.1" min="0" max="100"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div id="flat_fee" class="{{ $settings['fees']['transfer_fee_type'] === 'flat' ? '' : 'hidden' }}">
                        <label for="transfer_flat_fee" class="block text-sm font-medium text-gray-700 mb-1">Flat Amount (₦)</label>
                        <input type="number" name="transfer_flat_fee" id="transfer_flat_fee" 
                               value="{{ $settings['fees']['transfer_flat_fee'] }}" 
                               step="0.01" min="0"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>

                <!-- Other Fees -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Other Fees</h4>
                    
                    <div>
                        <label for="withdrawal_fee_value" class="block text-sm font-medium text-gray-700 mb-1">Withdrawal Fee (₦)</label>
                        <input type="number" name="withdrawal_fee_value" id="withdrawal_fee_value" 
                               value="{{ $settings['fees']['withdrawal_fee_value'] }}" 
                               step="0.01" min="0"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="card_issuance_fee" class="block text-sm font-medium text-gray-700 mb-1">Card Issuance Fee (₦)</label>
                        <input type="number" name="card_issuance_fee" id="card_issuance_fee" 
                               value="{{ $settings['fees']['card_issuance_fee'] }}" 
                               step="0.01" min="0"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="card_maintenance_fee" class="block text-sm font-medium text-gray-700 mb-1">Card Maintenance Fee (₦/month)</label>
                        <input type="number" name="card_maintenance_fee" id="card_maintenance_fee" 
                               value="{{ $settings['fees']['card_maintenance_fee'] }}" 
                               step="0.01" min="0"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
            </div>
        </div>

        <!-- Transaction Limits -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900">Transaction Limits</h3>
                <p class="text-sm text-gray-600">Set daily and per-transaction limits</p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- Transfer Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Transfer Limits</h4>
                    
                    <div>
                        <label for="daily_transfer_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Transfer Limit (₦)</label>
                        <input type="number" name="daily_transfer_limit" id="daily_transfer_limit" 
                               value="{{ $settings['limits']['daily_transfer_limit'] }}" 
                               step="1000" min="1000"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="single_transfer_limit" class="block text-sm font-medium text-gray-700 mb-1">Single Transfer Limit (₦)</label>
                        <input type="number" name="single_transfer_limit" id="single_transfer_limit" 
                               value="{{ $settings['limits']['single_transfer_limit'] }}" 
                               step="1000" min="1000"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>

                <!-- Withdrawal Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Withdrawal Limits</h4>
                    
                    <div>
                        <label for="daily_withdrawal_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Withdrawal Limit (₦)</label>
                        <input type="number" name="daily_withdrawal_limit" id="daily_withdrawal_limit" 
                               value="{{ $settings['limits']['daily_withdrawal_limit'] }}" 
                               step="1000" min="1000"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="single_withdrawal_limit" class="block text-sm font-medium text-gray-700 mb-1">Single Withdrawal Limit (₦)</label>
                        <input type="number" name="single_withdrawal_limit" id="single_withdrawal_limit" 
                               value="{{ $settings['limits']['single_withdrawal_limit'] }}" 
                               step="1000" min="1000"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>

                <!-- Card Limits -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">Card Limits</h4>
                    
                    <div>
                        <label for="card_daily_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Card Limit (₦)</label>
                        <input type="number" name="card_daily_limit" id="card_daily_limit" 
                               value="{{ $settings['limits']['card_daily_limit'] }}" 
                               step="1000" min="1000"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <div>
                        <label for="card_monthly_limit" class="block text-sm font-medium text-gray-700 mb-1">Monthly Card Limit (₦)</label>
                        <input type="number" name="card_monthly_limit" id="card_monthly_limit" 
                               value="{{ $settings['limits']['card_monthly_limit'] }}" 
                               step="10000" min="10000"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
            </div>
        </div>

        <!-- Security Requirements -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900">Security Requirements</h3>
                <p class="text-sm text-gray-600">Configure KYC and security requirements</p>
            </div>

            <div class="grid md:grid-cols-2 gap-6">
                <!-- KYC Requirements -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">KYC Requirements</h4>
                    
                    <div class="flex items-center">
                        <input type="checkbox" name="kyc_required_for_transfers" id="kyc_required_for_transfers" 
                               {{ $settings['requirements']['kyc_required_for_transfers'] ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="kyc_required_for_transfers" class="ml-2 text-sm text-gray-700">Require KYC for transfers</label>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="kyc_required_for_cards" id="kyc_required_for_cards" 
                               {{ $settings['requirements']['kyc_required_for_cards'] ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="kyc_required_for_cards" class="ml-2 text-sm text-gray-700">Require KYC for virtual cards</label>
                    </div>

                    <div>
                        <label for="kyc_required_amount_threshold" class="block text-sm font-medium text-gray-700 mb-1">KYC Required Above (₦)</label>
                        <input type="number" name="kyc_required_amount_threshold" id="kyc_required_amount_threshold" 
                               value="{{ $settings['requirements']['kyc_required_amount_threshold'] }}" 
                               step="1000" min="0"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Amount above which KYC is mandatory</p>
                    </div>
                </div>

                <!-- Security Requirements -->
                <div class="space-y-4">
                    <h4 class="font-medium text-gray-900">2FA Requirements</h4>
                    
                    <div class="flex items-center">
                        <input type="checkbox" name="require_2fa_for_large_transfers" id="require_2fa_for_large_transfers" 
                               {{ $settings['requirements']['require_2fa_for_large_transfers'] ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="require_2fa_for_large_transfers" class="ml-2 text-sm text-gray-700">Require 2FA for large transfers</label>
                    </div>

                    <div>
                        <label for="large_transfer_threshold" class="block text-sm font-medium text-gray-700 mb-1">Large Transfer Threshold (₦)</label>
                        <input type="number" name="large_transfer_threshold" id="large_transfer_threshold" 
                               value="{{ $settings['requirements']['large_transfer_threshold'] }}" 
                               step="10000" min="10000"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <p class="text-xs text-gray-500 mt-1">Amount above which 2FA is required</p>
                    </div>

                    <div>
                        <label for="minimum_wallet_balance" class="block text-sm font-medium text-gray-700 mb-1">Minimum Wallet Balance (₦)</label>
                        <input type="number" name="minimum_wallet_balance" id="minimum_wallet_balance" 
                               value="{{ $settings['limits']['minimum_wallet_balance'] }}" 
                               step="10" min="0"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Actions -->
        <div class="flex justify-between items-center">
            <div class="text-sm text-gray-600">
                <span class="inline-flex items-center">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Changes will take effect immediately
                </span>
            </div>
            <div class="flex space-x-3">
                <button type="button" onclick="resetToDefaults()" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                    Reset to Defaults
                </button>
                <button type="submit" class="px-6 py-2 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition-colors">
                    Save Settings
                </button>
            </div>
        </div>
    </form>
</div>

<script>
function toggleTransferFeeInput() {
    const feeType = document.getElementById('transfer_fee_type').value;
    const percentageDiv = document.getElementById('percentage_fee');
    const flatDiv = document.getElementById('flat_fee');
    
    if (feeType === 'percentage') {
        percentageDiv.classList.remove('hidden');
        flatDiv.classList.add('hidden');
    } else {
        percentageDiv.classList.add('hidden');
        flatDiv.classList.remove('hidden');
    }
}

function resetToDefaults() {
    if (confirm('Are you sure you want to reset all settings to defaults? This cannot be undone.')) {
        // Reset form to default values
        document.getElementById('transfer_fee_type').value = 'percentage';
        document.getElementById('transfer_fee_value').value = '1.5';
        document.getElementById('withdrawal_fee_value').value = '25';
        document.getElementById('card_issuance_fee').value = '500';
        document.getElementById('daily_transfer_limit').value = '500000';
        // ... reset other fields
        
        toggleTransferFeeInput();
        alert('Settings reset to defaults. Remember to save your changes.');
    }
}

function backupSettings() {
    alert('Settings backup created successfully!');
}
</script>
@endsection