<?php $__env->startSection('title', 'Bill Payments'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Bill Payments</h1>
    <p class="text-gray-600">Pay for airtime, data, electricity and other services</p>
</div>

<!-- Quick Stats -->
<div class="grid md:grid-cols-4 gap-4 mb-6">
    <div class="bg-gradient-to-r from-green-50 to-green-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-green-600 mb-1">This Month</h3>
        <p class="text-2xl font-bold text-green-900">₦<?php echo e(number_format($monthlySpending ?? 0, 2)); ?></p>
        <p class="text-xs text-green-600">Bill payments</p>
    </div>
    
    <div class="bg-gradient-to-r from-blue-50 to-blue-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-blue-600 mb-1">Transactions</h3>
        <p class="text-2xl font-bold text-blue-900"><?php echo e($monthlyTransactions ?? 0); ?></p>
        <p class="text-xs text-blue-600">This month</p>
    </div>
    
    <div class="bg-gradient-to-r from-purple-50 to-purple-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-purple-600 mb-1">Savings</h3>
        <p class="text-2xl font-bold text-purple-900">₦<?php echo e(number_format($estimatedSavings ?? 0, 2)); ?></p>
        <p class="text-xs text-purple-600">From discounts</p>
    </div>
    
    <div class="bg-gradient-to-r from-orange-50 to-orange-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-orange-600 mb-1">Favorite</h3>
        <p class="text-lg font-bold text-orange-900"><?php echo e($favoriteService ?? 'Airtime'); ?></p>
        <p class="text-xs text-orange-600">Most used</p>
    </div>
</div>

<!-- Service Categories -->
<div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 mb-6">
    <!-- Airtime -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='<?php echo e(route('bills.airtime')); ?>'">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-green-400 to-green-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">📱</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Buy Airtime</h3>
                <p class="text-sm text-gray-600 mb-2">MTN, Glo, Airtel, 9mobile</p>
                <p class="text-xs text-green-600 font-medium">🎯 Instant delivery • 0.5% fee</p>
            </div>
        </div>
    </div>
    
    <!-- Data -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='<?php echo e(route('bills.data')); ?>'">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-blue-400 to-blue-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">📶</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Buy Data</h3>
                <p class="text-sm text-gray-600 mb-2">All networks & plans</p>
                <p class="text-xs text-blue-600 font-medium">🎯 Instant activation • No fees</p>
            </div>
        </div>
    </div>
    
    <!-- Electricity -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='<?php echo e(route('bills.electricity')); ?>'">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-yellow-400 to-yellow-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">⚡</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Electricity</h3>
                <p class="text-sm text-gray-600 mb-2">All DisCos supported</p>
                <p class="text-xs text-yellow-600 font-medium">🎯 Instant credit • 1% fee</p>
            </div>
        </div>
    </div>
    
    <!-- Cable TV -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer opacity-75">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-purple-400 to-purple-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">📺</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Cable TV</h3>
                <p class="text-sm text-gray-600 mb-2">DSTV, GOtv, Startimes</p>
                <p class="text-xs text-purple-600 font-medium">🚧 Coming Soon</p>
            </div>
        </div>
    </div>
    
    <!-- Internet -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer opacity-75">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-indigo-400 to-indigo-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">🌐</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Internet</h3>
                <p class="text-sm text-gray-600 mb-2">Smile, Spectranet, Swift</p>
                <p class="text-xs text-indigo-600 font-medium">🚧 Coming Soon</p>
            </div>
        </div>
    </div>
    
    <!-- Education -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer opacity-75">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-teal-400 to-teal-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">🎓</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Education</h3>
                <p class="text-sm text-gray-600 mb-2">WAEC, JAMB, NECO pins</p>
                <p class="text-xs text-teal-600 font-medium">🚧 Coming Soon</p>
            </div>
        </div>
    </div>
</div>

<!-- Quick Access -->
<div class="card mb-6">
    <h3 class="text-lg font-bold mb-4">Quick Access</h3>
    <div class="grid md:grid-cols-3 gap-4">
        <!-- Recent Recipients -->
        <?php if($recentRecipients && count($recentRecipients) > 0): ?>
        <div>
            <h4 class="text-sm font-medium text-gray-700 mb-2">Recent Recipients</h4>
            <div class="space-y-2">
                <?php $__currentLoopData = $recentRecipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recipient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium"><?php echo e($recipient['phone']); ?></p>
                        <p class="text-xs text-gray-500"><?php echo e($recipient['network']); ?> • <?php echo e($recipient['type']); ?></p>
                    </div>
                    <button onclick="quickRecharge('<?php echo e($recipient['phone']); ?>', '<?php echo e($recipient['network']); ?>', '<?php echo e($recipient['type']); ?>')" 
                            class="text-xs px-2 py-1 bg-blue-100 text-blue-800 rounded hover:bg-blue-200">
                        Recharge
                    </button>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Saved Beneficiaries -->
        <div>
            <h4 class="text-sm font-medium text-gray-700 mb-2">Saved Numbers</h4>
            <div class="text-center py-4 text-gray-500">
                <p class="text-sm">No saved numbers yet</p>
                <button class="text-xs text-blue-600 hover:text-blue-800">Add Number</button>
            </div>
        </div>
        
        <!-- Popular Plans -->
        <div>
            <h4 class="text-sm font-medium text-gray-700 mb-2">Popular Data Plans</h4>
            <div class="space-y-2">
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium">MTN 1GB</p>
                        <p class="text-xs text-gray-500">30 days validity</p>
                    </div>
                    <span class="text-sm font-bold text-gray-900">₦350</span>
                </div>
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium">Airtel 2GB</p>
                        <p class="text-xs text-gray-500">30 days validity</p>
                    </div>
                    <span class="text-sm font-bold text-gray-900">₦600</span>
                </div>
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium">Glo 3GB</p>
                        <p class="text-xs text-gray-500">30 days validity</p>
                    </div>
                    <span class="text-sm font-bold text-gray-900">₦1,000</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="card">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-bold">Recent Bill Payments</h3>
        <a href="<?php echo e(route('transactions.index')); ?>?category=bill" class="text-blue-600 hover:text-blue-800 text-sm font-medium">View All →</a>
    </div>
    
    <?php if($recentBillPayments && count($recentBillPayments) > 0): ?>
        <div class="space-y-3">
            <?php $__currentLoopData = $recentBillPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center mr-3 bg-<?php echo e($payment->status === 'completed' ? 'green' : ($payment->status === 'failed' ? 'red' : 'yellow')); ?>-100">
                        <span class="text-lg">
                            <?php if($payment->category === 'airtime_purchase'): ?> 📱
                            <?php elseif($payment->category === 'data_purchase'): ?> 📶
                            <?php elseif($payment->category === 'bill_payment'): ?> ⚡
                            <?php else: ?> 💳
                            <?php endif; ?>
                        </span>
                    </div>
                    <div>
                        <p class="font-medium"><?php echo e($payment->description); ?></p>
                        <p class="text-sm text-gray-600"><?php echo e($payment->created_at->format('M d, Y H:i')); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="font-semibold text-red-600">-₦<?php echo e(number_format($payment->amount, 2)); ?></p>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        <?php if($payment->status === 'completed'): ?> bg-green-100 text-green-800
                        <?php elseif($payment->status === 'pending' || $payment->status === 'processing'): ?> bg-yellow-100 text-yellow-800
                        <?php else: ?> bg-red-100 text-red-800
                        <?php endif; ?>">
                        <?php echo e(ucfirst($payment->status)); ?>

                    </span>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="text-center py-8 text-gray-500">
            <span class="text-6xl mb-4 block">📱</span>
            <p class="text-lg font-medium mb-2">No bill payments yet</p>
            <p class="text-sm">Start by buying airtime or data</p>
        </div>
    <?php endif; ?>
</div>

<script>
function quickRecharge(phone, network, type) {
    if (type === 'airtime') {
        const amount = prompt(`Enter airtime amount for ${phone} (${network}):`);
        if (amount && !isNaN(amount) && parseFloat(amount) >= 50) {
            window.location.href = `<?php echo e(route('bills.airtime')); ?>?phone=${phone}&network=${network}&amount=${amount}`;
        }
    } else if (type === 'data') {
        window.location.href = `<?php echo e(route('bills.data')); ?>?phone=${phone}&network=${network}`;
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/bills/index.blade.php ENDPATH**/ ?>