<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<!-- Dashboard Header -->
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Welcome back, <?php echo e(auth()->user()->first_name); ?>!</h1>
    <p class="text-gray-600">Here's what's happening with your account today.</p>
</div>

<!-- Alert Notifications -->
<?php if($alerts && count($alerts) > 0): ?>
<div class="mb-6">
    <?php $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="alert alert-<?php echo e($alert['type']); ?> mb-3">
            <div class="flex items-center">
                <span class="mr-2"><?php echo e($alert['icon']); ?></span>
                <div>
                    <p class="font-medium"><?php echo e($alert['title']); ?></p>
                    <p class="text-sm"><?php echo e($alert['message']); ?></p>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php endif; ?>

<div class="grid lg:grid-cols-3 gap-6">
    <!-- Wallet Overview -->
    <div class="lg:col-span-2">
        <div class="card">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-xl font-bold">Wallet Overview</h2>
                <div class="text-right">
                    <p class="text-sm text-gray-600">Available Balance</p>
                    <p class="text-3xl font-bold text-green-600">₦<?php echo e(number_format($wallet?->available_balance ?? 0, 2)); ?></p>
                    <?php if($wallet && $wallet->is_frozen): ?>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                            🔒 Wallet Frozen
                        </span>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="grid md:grid-cols-3 gap-4 mb-6">
                <div class="bg-gradient-to-r from-blue-50 to-blue-100 rounded-lg p-4">
                    <p class="text-sm text-blue-600 font-medium">Total Balance</p>
                    <p class="text-xl font-bold text-blue-900">₦<?php echo e(number_format($wallet?->balance ?? 0, 2)); ?></p>
                </div>
                <div class="bg-gradient-to-r from-orange-50 to-orange-100 rounded-lg p-4">
                    <p class="text-sm text-orange-600 font-medium">Locked Balance</p>
                    <p class="text-xl font-bold text-orange-900">₦<?php echo e(number_format($wallet?->locked_balance ?? 0, 2)); ?></p>
                </div>
                <div class="bg-gradient-to-r from-green-50 to-green-100 rounded-lg p-4">
                    <p class="text-sm text-green-600 font-medium">Daily Limit Remaining</p>
                    <p class="text-xl font-bold text-green-900">₦<?php echo e(number_format($wallet?->remaining_daily_limit ?? 0, 2)); ?></p>
                </div>
            </div>

            <!-- Quick Action Buttons -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                <a href="<?php echo e(route('wallet.index')); ?>" class="flex flex-col items-center p-4 bg-green-50 hover:bg-green-100 rounded-lg transition-colors">
                    <div class="w-12 h-12 bg-green-200 rounded-full flex items-center justify-center mb-2">
                        <span class="text-2xl">💰</span>
                    </div>
                    <span class="text-sm font-medium text-green-800">Fund Wallet</span>
                </a>
                
                <a href="<?php echo e(route('transfer.p2p')); ?>" class="flex flex-col items-center p-4 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors">
                    <div class="w-12 h-12 bg-blue-200 rounded-full flex items-center justify-center mb-2">
                        <span class="text-2xl">👥</span>
                    </div>
                    <span class="text-sm font-medium text-blue-800">Send Money</span>
                </a>
                
                <a href="<?php echo e(route('transfer.bank')); ?>" class="flex flex-col items-center p-4 bg-purple-50 hover:bg-purple-100 rounded-lg transition-colors">
                    <div class="w-12 h-12 bg-purple-200 rounded-full flex items-center justify-center mb-2">
                        <span class="text-2xl">🏦</span>
                    </div>
                    <span class="text-sm font-medium text-purple-800">Withdraw</span>
                </a>
                
                <a href="<?php echo e(route('bills.index')); ?>" class="flex flex-col items-center p-4 bg-orange-50 hover:bg-orange-100 rounded-lg transition-colors">
                    <div class="w-12 h-12 bg-orange-200 rounded-full flex items-center justify-center mb-2">
                        <span class="text-2xl">📱</span>
                    </div>
                    <span class="text-sm font-medium text-orange-800">Buy Airtime</span>
                </a>
            </div>
        </div>

        <!-- Virtual Cards Summary -->
        <?php if($virtualCards && count($virtualCards) > 0): ?>
        <div class="card mt-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-bold">Virtual Cards</h3>
                <a href="<?php echo e(route('cards.index')); ?>" class="text-blue-600 hover:text-blue-800 text-sm">View All</a>
            </div>
            
            <div class="grid md:grid-cols-2 gap-4">
                <?php $__currentLoopData = $virtualCards->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-gradient-to-r from-gray-900 to-gray-700 rounded-xl p-4 text-white">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <p class="text-xs opacity-75"><?php echo e(strtoupper($card->card_type)); ?> CARD</p>
                            <p class="text-lg font-mono">**** **** **** <?php echo e(substr($card->card_number, -4)); ?></p>
                        </div>
                        <span class="px-2 py-1 bg-<?php echo e($card->status === 'active' ? 'green' : 'red'); ?>-500 rounded text-xs">
                            <?php echo e(ucfirst($card->status)); ?>

                        </span>
                    </div>
                    <div class="flex justify-between items-end">
                        <div>
                            <p class="text-xs opacity-75">Balance</p>
                            <p class="text-lg font-bold">₦<?php echo e(number_format($card->balance, 2)); ?></p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs opacity-75">Limit</p>
                            <p class="text-sm">₦<?php echo e(number_format($card->spending_limit, 0)); ?></p>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- KYC Status -->
        <?php if(!auth()->user()->hasCompletedKyc()): ?>
        <div class="card bg-gradient-to-r from-yellow-50 to-orange-50 border-yellow-200">
            <div class="flex items-start">
                <span class="text-2xl mr-3">⚠️</span>
                <div>
                    <h3 class="text-lg font-bold text-yellow-800 mb-2">Complete Your KYC</h3>
                    <p class="text-yellow-700 text-sm mb-4">
                        Verify your identity to unlock virtual cards and higher transaction limits.
                    </p>
                    <a href="<?php echo e(route('kyc.index')); ?>" class="btn-primary">Complete KYC</a>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="card bg-gradient-to-r from-green-50 to-emerald-50 border-green-200">
            <div class="flex items-center">
                <span class="text-2xl mr-3">✅</span>
                <div>
                    <h3 class="text-lg font-bold text-green-800">KYC Verified</h3>
                    <p class="text-green-700 text-sm">Your account is fully verified</p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Quick Services -->
        <div class="card">
            <h3 class="text-lg font-bold mb-4">Services</h3>
            <div class="space-y-2">
                <a href="<?php echo e(route('bills.airtime')); ?>" class="flex items-center w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors">
                    <span class="text-xl mr-3">📱</span>
                    <div>
                        <p class="font-medium">Buy Airtime</p>
                        <p class="text-xs text-gray-600">MTN, Glo, Airtel, 9mobile</p>
                    </div>
                </a>
                <a href="<?php echo e(route('bills.data')); ?>" class="flex items-center w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors">
                    <span class="text-xl mr-3">📶</span>
                    <div>
                        <p class="font-medium">Buy Data</p>
                        <p class="text-xs text-gray-600">All networks available</p>
                    </div>
                </a>
                <a href="<?php echo e(route('bills.electricity')); ?>" class="flex items-center w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors">
                    <span class="text-xl mr-3">⚡</span>
                    <div>
                        <p class="font-medium">Pay Electricity</p>
                        <p class="text-xs text-gray-600">All DisCos supported</p>
                    </div>
                </a>
                <a href="<?php echo e(route('virtual-account.index')); ?>" class="flex items-center w-full text-left p-3 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors">
                    <span class="text-xl mr-3">🏦</span>
                    <div>
                        <p class="font-medium">Virtual Account</p>
                        <p class="text-xs text-gray-600">Fund via bank transfer</p>
                    </div>
                </a>
            </div>
        </div>

        <!-- Account Statistics -->
        <div class="card">
            <h3 class="text-lg font-bold mb-4">This Month</h3>
            <div class="space-y-3">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-600">Total Spent</span>
                    <span class="font-semibold">₦<?php echo e(number_format($monthlyStats['total_spent'] ?? 0, 2)); ?></span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-600">Transactions</span>
                    <span class="font-semibold"><?php echo e($monthlyStats['transaction_count'] ?? 0); ?></span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-600">Savings</span>
                    <span class="font-semibold text-green-600">₦<?php echo e(number_format($monthlyStats['savings'] ?? 0, 2)); ?></span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="card mt-6">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-xl font-bold">Recent Transactions</h2>
        <a href="<?php echo e(route('transactions.index')); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">View All →</a>
    </div>
    
    <?php if($recentTransactions && $recentTransactions->count() > 0): ?>
        <div class="space-y-3">
            <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex justify-between items-center p-4 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors">
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center mr-3 <?php echo e($transaction->type === 'credit' ? 'bg-green-100' : 'bg-red-100'); ?>">
                        <span class="text-lg">
                            <?php if($transaction->category === 'wallet_funding'): ?>
                                💰
                            <?php elseif($transaction->category === 'p2p_transfer'): ?>
                                👥
                            <?php elseif($transaction->category === 'bank_transfer'): ?>
                                🏦
                            <?php elseif($transaction->category === 'airtime_purchase'): ?>
                                📱
                            <?php elseif($transaction->category === 'data_purchase'): ?>
                                📶
                            <?php elseif($transaction->category === 'bill_payment'): ?>
                                ⚡
                            <?php else: ?>
                                💳
                            <?php endif; ?>
                        </span>
                    </div>
                    <div>
                        <p class="font-medium"><?php echo e($transaction->description); ?></p>
                        <p class="text-sm text-gray-600"><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="font-semibold <?php echo e($transaction->type === 'credit' ? 'text-green-600' : 'text-red-600'); ?>">
                        <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction->amount, 2)); ?>

                    </p>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        <?php if($transaction->status === 'completed'): ?> bg-green-100 text-green-800
                        <?php elseif($transaction->status === 'pending' || $transaction->status === 'processing'): ?> bg-yellow-100 text-yellow-800
                        <?php else: ?> bg-red-100 text-red-800
                        <?php endif; ?>">
                        <?php echo e(ucfirst($transaction->status)); ?>

                    </span>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="text-center py-12 text-gray-500">
            <span class="text-6xl mb-4 block">💳</span>
            <p class="text-lg font-medium mb-2">No transactions yet</p>
            <p class="text-sm mb-4">Start by funding your wallet or making your first payment</p>
            <a href="<?php echo e(route('wallet.index')); ?>" class="btn-primary">Fund Wallet</a>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/dashboard.blade.php ENDPATH**/ ?>