<?php $__env->startSection('title', 'Transaction History'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Transaction History</h1>
    <p class="text-gray-600">View and filter your transaction history</p>
</div>

<!-- Filters -->
<div class="card mb-6">
    <form method="GET" action="<?php echo e(route('transactions.index')); ?>" class="grid md:grid-cols-5 gap-4">
        <div>
            <label for="type" class="block text-sm font-medium text-gray-700 mb-1">Type</label>
            <select name="type" id="type" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All Types</option>
                <option value="credit" <?php echo e(request('type') === 'credit' ? 'selected' : ''); ?>>Credit</option>
                <option value="debit" <?php echo e(request('type') === 'debit' ? 'selected' : ''); ?>>Debit</option>
            </select>
        </div>
        
        <div>
            <label for="category" class="block text-sm font-medium text-gray-700 mb-1">Category</label>
            <select name="category" id="category" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All Categories</option>
                <option value="wallet_funding" <?php echo e(request('category') === 'wallet_funding' ? 'selected' : ''); ?>>Wallet Funding</option>
                <option value="p2p_transfer" <?php echo e(request('category') === 'p2p_transfer' ? 'selected' : ''); ?>>P2P Transfer</option>
                <option value="bank_transfer" <?php echo e(request('category') === 'bank_transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
                <option value="airtime_purchase" <?php echo e(request('category') === 'airtime_purchase' ? 'selected' : ''); ?>>Airtime</option>
                <option value="data_purchase" <?php echo e(request('category') === 'data_purchase' ? 'selected' : ''); ?>>Data</option>
                <option value="bill_payment" <?php echo e(request('category') === 'bill_payment' ? 'selected' : ''); ?>>Bill Payment</option>
                <option value="virtual_card_transaction" <?php echo e(request('category') === 'virtual_card_transaction' ? 'selected' : ''); ?>>Virtual Card</option>
            </select>
        </div>
        
        <div>
            <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" id="status" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All Status</option>
                <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="processing" <?php echo e(request('status') === 'processing' ? 'selected' : ''); ?>>Processing</option>
                <option value="failed" <?php echo e(request('status') === 'failed' ? 'selected' : ''); ?>>Failed</option>
            </select>
        </div>
        
        <div>
            <label for="date_from" class="block text-sm font-medium text-gray-700 mb-1">From Date</label>
            <input type="date" name="date_from" id="date_from" value="<?php echo e(request('date_from')); ?>" 
                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition-colors">
                Filter
            </button>
        </div>
    </form>
    
    <?php if(request()->hasAny(['type', 'category', 'status', 'date_from'])): ?>
    <div class="mt-4 pt-4 border-t border-gray-200">
        <a href="<?php echo e(route('transactions.index')); ?>" class="text-blue-600 hover:text-blue-800 text-sm">
            Clear all filters
        </a>
    </div>
    <?php endif; ?>
</div>

<!-- Transaction Summary -->
<div class="grid md:grid-cols-4 gap-4 mb-6">
    <div class="bg-gradient-to-r from-green-50 to-green-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-green-600 mb-1">Total Credit</h3>
        <p class="text-xl font-bold text-green-900">₦<?php echo e(number_format($summary['total_credit'] ?? 0, 2)); ?></p>
    </div>
    
    <div class="bg-gradient-to-r from-red-50 to-red-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-red-600 mb-1">Total Debit</h3>
        <p class="text-xl font-bold text-red-900">₦<?php echo e(number_format($summary['total_debit'] ?? 0, 2)); ?></p>
    </div>
    
    <div class="bg-gradient-to-r from-blue-50 to-blue-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-blue-600 mb-1">Total Transactions</h3>
        <p class="text-xl font-bold text-blue-900"><?php echo e($summary['total_count'] ?? 0); ?></p>
    </div>
    
    <div class="bg-gradient-to-r from-purple-50 to-purple-100 rounded-lg p-4">
        <h3 class="text-sm font-medium text-purple-600 mb-1">Total Fees</h3>
        <p class="text-xl font-bold text-purple-900">₦<?php echo e(number_format($summary['total_fees'] ?? 0, 2)); ?></p>
    </div>
</div>

<!-- Transactions List -->
<div class="card">
    <?php if($transactions->count() > 0): ?>
        <div class="space-y-4">
            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex justify-between items-center p-4 bg-gray-50 hover:bg-gray-100 rounded-lg transition-colors cursor-pointer"
                 onclick="openTransactionModal('<?php echo e($transaction->id); ?>')">
                <div class="flex items-center">
                    <div class="w-12 h-12 rounded-full flex items-center justify-center mr-4 <?php echo e($transaction->type === 'credit' ? 'bg-green-100' : 'bg-red-100'); ?>">
                        <span class="text-xl">
                            <?php if($transaction->category === 'wallet_funding'): ?> 💰
                            <?php elseif($transaction->category === 'p2p_transfer'): ?> 👥
                            <?php elseif($transaction->category === 'bank_transfer'): ?> 🏦
                            <?php elseif($transaction->category === 'airtime_purchase'): ?> 📱
                            <?php elseif($transaction->category === 'data_purchase'): ?> 📶
                            <?php elseif($transaction->category === 'bill_payment'): ?> ⚡
                            <?php elseif($transaction->category === 'virtual_card_transaction'): ?> 💳
                            <?php elseif($transaction->category === 'refund'): ?> 🔄
                            <?php else: ?> 💼
                            <?php endif; ?>
                        </span>
                    </div>
                    <div>
                        <p class="font-medium text-gray-900"><?php echo e($transaction->description); ?></p>
                        <p class="text-sm text-gray-600"><?php echo e($transaction->created_at->format('M d, Y H:i A')); ?></p>
                        <?php if($transaction->external_reference): ?>
                        <p class="text-xs text-gray-500">Ref: <?php echo e($transaction->reference); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="text-right">
                    <p class="font-bold text-lg <?php echo e($transaction->type === 'credit' ? 'text-green-600' : 'text-red-600'); ?>">
                        <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction->amount, 2)); ?>

                    </p>
                    <?php if($transaction->fee > 0): ?>
                    <p class="text-xs text-gray-500">Fee: ₦<?php echo e(number_format($transaction->fee, 2)); ?></p>
                    <?php endif; ?>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium mt-1
                        <?php if($transaction->status === 'completed'): ?> bg-green-100 text-green-800
                        <?php elseif($transaction->status === 'pending' || $transaction->status === 'processing'): ?> bg-yellow-100 text-yellow-800
                        <?php else: ?> bg-red-100 text-red-800
                        <?php endif; ?>">
                        <?php echo e(ucfirst($transaction->status)); ?>

                    </span>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <!-- Pagination -->
        <div class="mt-6">
            <?php echo e($transactions->appends(request()->query())->links()); ?>

        </div>
    <?php else: ?>
        <div class="text-center py-12 text-gray-500">
            <span class="text-6xl mb-4 block">📊</span>
            <p class="text-lg font-medium mb-2">No transactions found</p>
            <p class="text-sm">Try adjusting your filters or check back later</p>
        </div>
    <?php endif; ?>
</div>

<!-- Transaction Detail Modal -->
<div id="transactionModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-medium text-gray-900">Transaction Details</h3>
                <button onclick="closeTransactionModal()" class="text-gray-400 hover:text-gray-600">
                    <span class="text-2xl">&times;</span>
                </button>
            </div>
            <div id="transactionDetails">
                <!-- Transaction details will be loaded here -->
            </div>
        </div>
    </div>
</div>

<script>
function openTransactionModal(transactionId) {
    document.getElementById('transactionModal').classList.remove('hidden');
    // Load transaction details via AJAX
    loadTransactionDetails(transactionId);
}

function closeTransactionModal() {
    document.getElementById('transactionModal').classList.add('hidden');
}

function loadTransactionDetails(transactionId) {
    // This would normally make an AJAX request to get transaction details
    document.getElementById('transactionDetails').innerHTML = '<p class="text-center">Loading...</p>';
    
    // Placeholder implementation
    setTimeout(() => {
        document.getElementById('transactionDetails').innerHTML = `
            <div class="space-y-3">
                <div class="bg-gray-50 rounded-lg p-3">
                    <p class="text-sm text-gray-600">Transaction ID</p>
                    <p class="font-medium">${transactionId}</p>
                </div>
                <div class="bg-gray-50 rounded-lg p-3">
                    <p class="text-sm text-gray-600">Status</p>
                    <p class="font-medium">Completed</p>
                </div>
                <div class="bg-gray-50 rounded-lg p-3">
                    <p class="text-sm text-gray-600">Date</p>
                    <p class="font-medium">${new Date().toLocaleDateString()}</p>
                </div>
                <button onclick="downloadReceipt('${transactionId}')" class="w-full mt-4 px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                    Download Receipt
                </button>
            </div>
        `;
    }, 500);
}

function downloadReceipt(transactionId) {
    alert('Downloading receipt for transaction ' + transactionId);
    // Implementation for downloading receipt
}

// Close modal when clicking outside
document.getElementById('transactionModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeTransactionModal();
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/transactions/index.blade.php ENDPATH**/ ?>