<?php $__env->startSection('title', 'KYC Details - ' . $kycVerification->user->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <!-- Breadcrumb -->
    <nav class="flex mb-6" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li>
                <a href="<?php echo e(route('admin.kyc.index')); ?>" class="text-blue-600 hover:text-blue-800">KYC Management</a>
            </li>
            <li aria-current="page">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="ml-1 text-gray-500 md:ml-2"><?php echo e($kycVerification->user->full_name); ?></span>
                </div>
            </li>
        </ol>
    </nav>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2">
            <!-- KYC Header -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="h-16 w-16 rounded-full bg-gray-300 flex items-center justify-center">
                            <span class="text-xl font-medium text-gray-700">
                                <?php echo e(strtoupper(substr($kycVerification->user->first_name, 0, 1) . substr($kycVerification->user->last_name, 0, 1))); ?>

                            </span>
                        </div>
                        <div class="ml-6">
                            <h1 class="text-2xl font-bold text-gray-900"><?php echo e($kycVerification->user->full_name); ?></h1>
                            <p class="text-gray-600"><?php echo e(strtoupper($kycVerification->type)); ?> Verification</p>
                            <div class="flex items-center mt-2 space-x-4">
                                <?php if($kycVerification->status === 'pending'): ?>
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Pending Review</span>
                                <?php elseif($kycVerification->status === 'verified'): ?>
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Verified</span>
                                <?php elseif($kycVerification->status === 'failed'): ?>
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Failed</span>
                                <?php else: ?>
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">Expired</span>
                                <?php endif; ?>
                                
                                <span class="text-sm text-gray-500">
                                    Submitted <?php echo e($kycVerification->created_at->diffForHumans()); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="flex space-x-2">
                        <?php if($kycVerification->status === 'pending'): ?>
                            <button onclick="showApproveModal()" class="btn-success">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                Approve
                            </button>
                            <button onclick="showRejectModal()" class="btn-danger">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                                Reject
                            </button>
                        <?php elseif($kycVerification->status !== 'pending'): ?>
                            <form action="<?php echo e(route('admin.kyc.reset', $kycVerification)); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn-secondary" onclick="return confirm('Are you sure you want to reset this KYC to pending status?')">
                                    Reset to Pending
                                </button>
                            </form>
                        <?php endif; ?>

                        <?php if($kycVerification->document_path): ?>
                            <a href="<?php echo e(route('admin.kyc.download', $kycVerification)); ?>" class="btn-primary">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Download Document
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- KYC Details -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Verification Details</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Verification Type</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e(strtoupper($kycVerification->type)); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Verification ID</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->verification_id ?: 'Not provided'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Provider</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->provider ?: 'Manual Upload'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Provider Reference</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->provider_reference ?: 'N/A'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Submission Date</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->created_at->format('M d, Y H:i')); ?></p>
                    </div>
                    <?php if($kycVerification->verified_at): ?>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Verification Date</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->verified_at->format('M d, Y H:i')); ?></p>
                    </div>
                    <?php endif; ?>
                    <?php if($kycVerification->expires_at): ?>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Expiry Date</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->expires_at->format('M d, Y')); ?></p>
                    </div>
                    <?php endif; ?>
                </div>

                <?php if($kycVerification->failure_reason): ?>
                <div class="mt-4 p-4 bg-red-50 border border-red-200 rounded-md">
                    <h3 class="text-sm font-medium text-red-800">Failure Reason</h3>
                    <p class="mt-1 text-sm text-red-700"><?php echo e($kycVerification->failure_reason); ?></p>
                </div>
                <?php endif; ?>
            </div>

            <!-- Verification Data -->
            <?php if($kycVerification->verification_data): ?>
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Verification Data</h2>
                
                <div class="bg-gray-50 rounded-md p-4">
                    <pre class="text-sm text-gray-800 whitespace-pre-wrap"><?php echo e(json_encode($kycVerification->verification_data, JSON_PRETTY_PRINT)); ?></pre>
                </div>
            </div>
            <?php endif; ?>

            <!-- Document Preview -->
            <?php if($kycVerification->document_path): ?>
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Document</h2>
                
                <div class="border border-gray-200 rounded-md p-4 text-center">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <p class="mt-2 text-sm text-gray-600">Document available for download</p>
                    <p class="text-xs text-gray-500"><?php echo e(basename($kycVerification->document_path)); ?></p>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <!-- User Information -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">User Information</h2>
                
                <div class="space-y-3">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Email</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->user->email); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Phone</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->user->phone); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Date of Birth</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->user->date_of_birth ? $kycVerification->user->date_of_birth->format('M d, Y') : 'Not provided'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Address</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->user->address ?: 'Not provided'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Registration Date</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($kycVerification->user->created_at->format('M d, Y')); ?></p>
                    </div>
                </div>

                <div class="mt-4 pt-4 border-t border-gray-200">
                    <a href="<?php echo e(route('admin.users.show', $kycVerification->user)); ?>" class="btn-primary w-full text-center">
                        View Full Profile
                    </a>
                </div>
            </div>

            <!-- KYC History -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">KYC History</h2>
                
                <?php
                    $userKycs = $kycVerification->user->kycVerifications()->orderBy('created_at', 'desc')->get();
                ?>

                <?php if($userKycs->count() > 0): ?>
                    <div class="space-y-3">
                        <?php $__currentLoopData = $userKycs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="border border-gray-200 rounded-md p-3 <?php echo e($kyc->id === $kycVerification->id ? 'bg-blue-50 border-blue-200' : ''); ?>">
                            <div class="flex justify-between items-start">
                                <div>
                                    <p class="text-sm font-medium text-gray-900"><?php echo e(strtoupper($kyc->type)); ?></p>
                                    <p class="text-xs text-gray-500"><?php echo e($kyc->created_at->format('M d, Y')); ?></p>
                                </div>
                                <div>
                                    <?php if($kyc->status === 'pending'): ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Pending</span>
                                    <?php elseif($kyc->status === 'verified'): ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Verified</span>
                                    <?php elseif($kyc->status === 'failed'): ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Failed</span>
                                    <?php else: ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">Expired</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if($kyc->id === $kycVerification->id): ?>
                                <p class="text-xs text-blue-600 mt-1">Currently viewing</p>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p class="text-sm text-gray-500">No KYC history found.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Approve Modal -->
<div id="approveModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Approve KYC Verification</h3>
            <form action="<?php echo e(route('admin.kyc.approve', $kycVerification)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label for="notes" class="block text-sm font-medium text-gray-700 mb-1">Notes (Optional)</label>
                    <textarea name="notes" id="notes" rows="3" class="form-input" 
                              placeholder="Add any notes about this approval..."></textarea>
                </div>
                <div class="bg-green-50 border border-green-200 rounded-md p-3 mb-4">
                    <p class="text-sm text-green-800">This will mark the KYC verification as approved and verify the user's account.</p>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideApproveModal()" class="btn-secondary">Cancel</button>
                    <button type="submit" class="btn-success">Approve KYC</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div id="rejectModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Reject KYC Verification</h3>
            <form action="<?php echo e(route('admin.kyc.reject', $kycVerification)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label for="reason" class="block text-sm font-medium text-gray-700 mb-1">Rejection Reason *</label>
                    <textarea name="reason" id="reason" required rows="3" class="form-input" 
                              placeholder="Provide a clear reason for rejection..."></textarea>
                </div>
                <div class="bg-red-50 border border-red-200 rounded-md p-3 mb-4">
                    <p class="text-sm text-red-800">This will mark the KYC verification as failed. The user will be notified with your reason.</p>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideRejectModal()" class="btn-secondary">Cancel</button>
                    <button type="submit" class="btn-danger">Reject KYC</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showApproveModal() {
    document.getElementById('approveModal').classList.remove('hidden');
}

function hideApproveModal() {
    document.getElementById('approveModal').classList.add('hidden');
}

function showRejectModal() {
    document.getElementById('rejectModal').classList.remove('hidden');
}

function hideRejectModal() {
    document.getElementById('rejectModal').classList.add('hidden');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/kyc/show.blade.php ENDPATH**/ ?>