<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Welcome Section -->
    <div class="card">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Welcome back, <?php echo e($admin->name); ?>!</h1>
                <p class="text-gray-600 mt-1"><?php echo e($admin->role === 'super_admin' ? 'Super Administrator' : ucfirst($admin->role)); ?> • Last login: <?php echo e($admin->last_login_at?->diffForHumans() ?? 'First time'); ?></p>
            </div>
            <div class="text-right">
                <p class="text-sm text-gray-500"><?php echo e(now()->format('l, F j, Y')); ?></p>
                <p class="text-sm text-gray-500"><?php echo e(now()->format('g:i A')); ?></p>
            </div>
        </div>
    </div>

    <!-- Statistics Overview -->
    <div class="grid md:grid-cols-4 gap-6">
        <div class="card bg-blue-50 border-l-4 border-blue-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-blue-800">Total Users</p>
                    <p class="text-2xl font-semibold text-blue-900"><?php echo e(number_format($stats['total_users'])); ?></p>
                    <p class="text-xs text-blue-600"><?php echo e(number_format($stats['active_users'])); ?> active</p>
                </div>
            </div>
        </div>

        <div class="card bg-yellow-50 border-l-4 border-yellow-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <svg class="w-8 h-8 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-yellow-800">Pending KYC</p>
                    <p class="text-2xl font-semibold text-yellow-900"><?php echo e(number_format($stats['pending_kyc'])); ?></p>
                    <p class="text-xs text-yellow-600"><?php echo e(number_format($stats['approved_kyc'])); ?> approved</p>
                </div>
            </div>
        </div>

        <div class="card bg-green-50 border-l-4 border-green-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-green-800">Transactions</p>
                    <p class="text-2xl font-semibold text-green-900"><?php echo e(number_format($stats['total_transactions'])); ?></p>
                    <p class="text-xs text-green-600">₦<?php echo e(number_format($stats['total_transaction_volume'] / 1000000, 1)); ?>M volume</p>
                </div>
            </div>
        </div>

        <div class="card bg-purple-50 border-l-4 border-purple-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-purple-800">Active Cards</p>
                    <p class="text-2xl font-semibold text-purple-900"><?php echo e(number_format($stats['active_cards'])); ?></p>
                    <p class="text-xs text-purple-600"><?php echo e(number_format($stats['total_wallets'])); ?> wallets</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Alerts Section -->
    <?php if($stats['pending_kyc'] > 0 || $stats['blocked_users'] > 0 || $stats['frozen_wallets'] > 0): ?>
    <div class="card bg-yellow-50 border-l-4 border-yellow-500">
        <h2 class="text-lg font-semibold text-yellow-800 mb-3">Attention Required</h2>
        <div class="space-y-2">
            <?php if($stats['pending_kyc'] > 0): ?>
                <div class="flex items-center text-yellow-700">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                    </svg>
                    <?php echo e($stats['pending_kyc']); ?> KYC verification(s) require approval
                </div>
            <?php endif; ?>
            <?php if($stats['blocked_users'] > 0): ?>
                <div class="flex items-center text-yellow-700">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                    </svg>
                    <?php echo e($stats['blocked_users']); ?> user(s) are currently blocked
                </div>
            <?php endif; ?>
            <?php if($stats['frozen_wallets'] > 0): ?>
                <div class="flex items-center text-yellow-700">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5 2a1 1 0 011 1v1h1a1 1 0 010 2H6v1a1 1 0 01-2 0V6H3a1 1 0 010-2h1V3a1 1 0 011-1zm0 10a1 1 0 011 1v1h1a1 1 0 110 2H6v1a1 1 0 11-2 0v-1H3a1 1 0 110-2h1v-1a1 1 0 011-1zM12 2a1 1 0 01.967.744L14.146 7.2 17.5 9.134a1 1 0 010 1.732L14.146 12.8l-1.179 4.456a1 1 0 01-1.934 0L9.854 12.8 6.5 10.866a1 1 0 010-1.732L9.854 7.2l1.179-4.456A1 1 0 0112 2z" clip-rule="evenodd"></path>
                    </svg>
                    <?php echo e($stats['frozen_wallets']); ?> wallet(s) are frozen
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Quick Actions -->
    <div class="card">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h2>
        <div class="grid md:grid-cols-3 gap-4">
            <a href="<?php echo e(route('admin.users.index', ['kyc_status' => 'pending'])); ?>" class="block p-4 border border-gray-200 rounded-lg hover:border-blue-300 hover:bg-blue-50 transition-colors">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <span class="font-medium">Review KYC Requests</span>
                </div>
            </a>
            
            <a href="<?php echo e(route('admin.users.index')); ?>" class="block p-4 border border-gray-200 rounded-lg hover:border-green-300 hover:bg-green-50 transition-colors">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-green-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                    <span class="font-medium">Manage Users</span>
                </div>
            </a>
            
            <a href="#" class="block p-4 border border-gray-200 rounded-lg hover:border-purple-300 hover:bg-purple-50 transition-colors">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-purple-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                    <span class="font-medium">View Reports</span>
                </div>
            </a>
        </div>
    </div>

    <div class="grid lg:grid-cols-2 gap-6">
        <!-- Recent Users -->
        <div class="card">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Recent Users</h2>
            <?php if($recentUsers->count() > 0): ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $recentUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between py-2 border-b border-gray-100 last:border-b-0">
                        <div class="flex items-center">
                            <div class="h-8 w-8 rounded-full bg-gray-300 flex items-center justify-center mr-3">
                                <span class="text-xs font-medium text-gray-700">
                                    <?php echo e(strtoupper(substr($user->first_name, 0, 1) . substr($user->last_name, 0, 1))); ?>

                                </span>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e($user->full_name); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($user->email); ?></p>
                            </div>
                        </div>
                        <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="text-blue-600 hover:text-blue-800 text-sm">View</a>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <p class="text-gray-500 text-center py-4">No recent users</p>
            <?php endif; ?>
        </div>

        <!-- Recent Transactions -->
        <div class="card">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Recent Transactions</h2>
            <?php if($recentTransactions->count() > 0): ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between py-2 border-b border-gray-100 last:border-b-0">
                        <div>
                            <p class="text-sm font-medium text-gray-900"><?php echo e(ucfirst($transaction->type)); ?></p>
                            <p class="text-xs text-gray-500"><?php echo e($transaction->user->full_name ?? 'Unknown User'); ?></p>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-medium text-gray-900">₦<?php echo e(number_format($transaction->amount, 2)); ?></p>
                            <p class="text-xs text-gray-500"><?php echo e($transaction->created_at->format('M d, H:i')); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <p class="text-gray-500 text-center py-4">No recent transactions</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Pending KYC -->
    <?php if($pendingKyc->count() > 0): ?>
    <div class="card">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Pending KYC Verifications</h2>
        <div class="space-y-3">
            <?php $__currentLoopData = $pendingKyc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center justify-between py-2 border-b border-gray-100 last:border-b-0">
                <div class="flex items-center">
                    <div class="h-8 w-8 rounded-full bg-gray-300 flex items-center justify-center mr-3">
                        <span class="text-xs font-medium text-gray-700">
                            <?php echo e(strtoupper(substr($kyc->user->first_name, 0, 1) . substr($kyc->user->last_name, 0, 1))); ?>

                        </span>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-900"><?php echo e($kyc->user->full_name); ?></p>
                        <p class="text-xs text-gray-500"><?php echo e(strtoupper($kyc->type)); ?> • <?php echo e($kyc->created_at->diffForHumans()); ?></p>
                    </div>
                </div>
                <a href="<?php echo e(route('admin.users.show', $kyc->user)); ?>" class="text-blue-600 hover:text-blue-800 text-sm">Review</a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/dashboard-old.blade.php ENDPATH**/ ?>