<?php $__env->startSection('title', 'Airtime & Data Providers'); ?>
<?php $__env->startSection('page-title', 'Service Providers'); ?>
<?php $__env->startSection('page-description', 'Manage airtime and data service providers and their settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Page Header with Actions -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Service Provider Management</h2>
            <p class="text-gray-600 mt-1">Configure and monitor your airtime and data service providers</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="testAllProviders()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                Test All
            </button>
            <button class="btn-primary" onclick="openProviderModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Add Provider
            </button>
        </div>
    </div>

    <!-- Providers Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6">
        <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
            <!-- Provider Header -->
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                        <span class="text-white font-bold text-lg"><?php echo e(strtoupper(substr($provider['name'], 0, 2))); ?></span>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-lg font-semibold text-gray-900"><?php echo e($provider['name']); ?></h3>
                        <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                            <?php echo e($provider['type'] === 'Primary' ? 'bg-green-100 text-green-800' : 
                               ($provider['type'] === 'Secondary' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800')); ?>">
                            <?php echo e($provider['type']); ?>

                        </span>
                    </div>
                </div>
                <div class="flex items-center">
                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                        <?php echo e($provider['status'] === 'active' ? 'bg-emerald-100 text-emerald-800' : 'bg-red-100 text-red-800'); ?>">
                        <?php echo e(ucfirst($provider['status'])); ?>

                    </span>
                </div>
            </div>

            <!-- Provider Stats -->
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div class="text-center p-3 bg-gray-50 rounded-lg">
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($provider['success_rate']); ?>%</div>
                    <div class="text-xs text-gray-600">Success Rate</div>
                </div>
                <div class="text-center p-3 bg-gray-50 rounded-lg">
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($provider['avg_response_time']); ?>s</div>
                    <div class="text-xs text-gray-600">Avg Response</div>
                </div>
            </div>

            <!-- Transaction Stats -->
            <div class="flex justify-between items-center mb-4 text-sm">
                <span class="text-gray-600">Total Transactions:</span>
                <span class="font-semibold text-gray-900"><?php echo e(number_format($provider['total_transactions'])); ?></span>
            </div>
            <div class="flex justify-between items-center mb-4 text-sm">
                <span class="text-gray-600">Last Used:</span>
                <span class="font-semibold text-gray-900"><?php echo e($provider['last_used']); ?></span>
            </div>

            <!-- Supported Services -->
            <div class="mb-4">
                <label class="text-sm font-medium text-gray-700 mb-2 block">Supported Services</label>
                <div class="flex flex-wrap gap-1">
                    <?php $__currentLoopData = $provider['supported_services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="inline-flex px-2 py-1 text-xs font-medium bg-blue-100 text-blue-800 rounded">
                        <?php echo e($service); ?>

                    </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Provider Actions -->
            <div class="flex space-x-2 pt-4 border-t border-gray-200">
                <button class="flex-1 btn-secondary text-sm py-2" 
                        onclick="testProvider(<?php echo e($provider['id']); ?>)">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Test
                </button>
                <button class="flex-1 btn-primary text-sm py-2" 
                        onclick="configureProvider(<?php echo e($provider['id']); ?>)">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    Configure
                </button>
                <?php if($provider['status'] === 'active'): ?>
                <button class="btn-danger text-sm py-2 px-3" 
                        onclick="toggleProviderStatus(<?php echo e($provider['id']); ?>, 'inactive')">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </button>
                <?php else: ?>
                <button class="btn-success text-sm py-2 px-3" 
                        onclick="toggleProviderStatus(<?php echo e($provider['id']); ?>, 'active')">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </button>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Provider Performance Chart -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Provider Performance Overview</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Success Rate Comparison -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Success Rate Comparison</h4>
                <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm text-gray-600"><?php echo e($provider['name']); ?></span>
                    <div class="flex items-center">
                        <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                            <div class="h-2 bg-gradient-to-r from-emerald-500 to-emerald-600 rounded-full" 
                                 style="width: <?php echo e($provider['success_rate']); ?>%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900"><?php echo e($provider['success_rate']); ?>%</span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Response Time Comparison -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Response Time Comparison</h4>
                <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm text-gray-600"><?php echo e($provider['name']); ?></span>
                    <div class="flex items-center">
                        <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                            <div class="h-2 bg-gradient-to-r from-blue-500 to-blue-600 rounded-full" 
                                 style="width: <?php echo e(100 - ($provider['avg_response_time'] * 10)); ?>%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900"><?php echo e($provider['avg_response_time']); ?>s</span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Transaction Volume -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Transaction Volume</h4>
                <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm text-gray-600"><?php echo e($provider['name']); ?></span>
                    <span class="text-sm font-medium text-gray-900"><?php echo e(number_format($provider['total_transactions'])); ?></span>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- Quick Actions Panel -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h3>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="bulkTest()">
                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">Bulk Test</div>
                <div class="text-xs text-gray-500">Test all providers</div>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="viewLogs()">
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">View Logs</div>
                <div class="text-xs text-gray-500">Provider activity</div>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="manageFailover()">
                <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">Failover Rules</div>
                <div class="text-xs text-gray-500">Manage switching</div>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="exportReport()">
                <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">Export Report</div>
                <div class="text-xs text-gray-500">Download analytics</div>
            </button>
        </div>
    </div>
</div>

<script>
// CSRF token for AJAX requests
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

function testProvider(providerId) {
    // Show loading state
    const button = event.target.closest('button');
    const originalContent = button.innerHTML;
    button.innerHTML = '<svg class="animate-spin w-4 h-4 mr-1" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>Testing...';
    button.disabled = true;

    fetch(`/admin/api-config/${providerId}/test`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken,
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', `Provider tested successfully! Response time: ${data.response_time}ms`);
            // Update the UI with new status
            location.reload();
        } else {
            showAlert('error', `Test failed: ${data.error || 'Unknown error'}`);
        }
    })
    .catch(error => {
        showAlert('error', `Test failed: ${error.message}`);
    })
    .finally(() => {
        button.innerHTML = originalContent;
        button.disabled = false;
    });
}

function testAllProviders() {
    if (!confirm('Are you sure you want to test all providers? This may take a few moments.')) {
        return;
    }

    const providers = <?php echo json_encode($providers, 15, 512) ?>;
    let completed = 0;
    const total = providers.length;

    showAlert('info', `Testing ${total} providers...`);

    providers.forEach(provider => {
        fetch(`/admin/api-config/${provider.id}/test`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            completed++;
            if (completed === total) {
                showAlert('success', 'All providers tested successfully!');
                setTimeout(() => location.reload(), 1500);
            }
        })
        .catch(error => {
            completed++;
            if (completed === total) {
                showAlert('warning', 'Testing completed with some errors. Check individual results.');
                setTimeout(() => location.reload(), 1500);
            }
        });
    });
}

function configureProvider(providerId) {
    window.location.href = `/admin/api-config/${providerId}`;
}

function toggleProviderStatus(providerId, status) {
    if (!confirm(`Are you sure you want to ${status} this provider?`)) {
        return;
    }

    fetch(`/admin/api-config/${providerId}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken,
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', data.message);
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('error', data.message || 'Failed to update provider status');
        }
    })
    .catch(error => {
        showAlert('error', `Error: ${error.message}`);
    });
}

function openProviderModal() {
    showAlert('info', 'Provider management interface will be implemented soon. For now, please contact system administrator to add new providers.');
}

function bulkTest() {
    testAllProviders();
}

function viewLogs() {
    window.location.href = '/admin/api-config/logs';
}

function manageFailover() {
    showAlert('info', 'Failover management interface is coming soon. Current providers are automatically managed based on success rates.');
}

function exportReport() {
    // Generate and download a CSV report
    const providers = <?php echo json_encode($providers, 15, 512) ?>;
    
    let csvContent = "data:text/csv;charset=utf-8,";
    csvContent += "Provider,Type,Status,Success Rate,Response Time,Total Transactions,Last Used\n";
    
    providers.forEach(provider => {
        const row = [
            provider.name,
            provider.type,
            provider.status,
            provider.success_rate + '%',
            provider.avg_response_time + 's',
            provider.total_transactions,
            provider.last_used
        ].join(',');
        csvContent += row + "\n";
    });

    const encodedUri = encodeURI(csvContent);
    const link = document.createElement("a");
    link.setAttribute("href", encodedUri);
    link.setAttribute("download", `provider_report_${new Date().toISOString().split('T')[0]}.csv`);
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    
    showAlert('success', 'Report exported successfully!');
}

function showAlert(type, message) {
    // Create alert element
    const alertDiv = document.createElement('div');
    alertDiv.className = `fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg max-w-sm ${getAlertClasses(type)}`;
    alertDiv.innerHTML = `
        <div class="flex items-center">
            <div class="flex-shrink-0">
                ${getAlertIcon(type)}
            </div>
            <div class="ml-3">
                <p class="text-sm font-medium">${message}</p>
            </div>
            <div class="ml-4 flex-shrink-0">
                <button onclick="this.parentElement.parentElement.parentElement.remove()" class="inline-flex text-gray-400 hover:text-gray-600">
                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
    `;
    
    document.body.appendChild(alertDiv);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (alertDiv.parentElement) {
            alertDiv.remove();
        }
    }, 5000);
}

function getAlertClasses(type) {
    switch(type) {
        case 'success': return 'bg-green-50 border border-green-200 text-green-800';
        case 'error': return 'bg-red-50 border border-red-200 text-red-800';
        case 'warning': return 'bg-yellow-50 border border-yellow-200 text-yellow-800';
        case 'info': return 'bg-blue-50 border border-blue-200 text-blue-800';
        default: return 'bg-gray-50 border border-gray-200 text-gray-800';
    }
}

function getAlertIcon(type) {
    switch(type) {
        case 'success': return '<svg class="h-5 w-5 text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>';
        case 'error': return '<svg class="h-5 w-5 text-red-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>';
        case 'warning': return '<svg class="h-5 w-5 text-yellow-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path></svg>';
        case 'info': return '<svg class="h-5 w-5 text-blue-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>';
        default: return '<svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>';
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/airtime/providers.blade.php ENDPATH**/ ?>