<?php $__env->startSection('title', 'User Details - ' . $user->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <!-- Breadcrumb -->
    <nav class="flex mb-6" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="text-blue-600 hover:text-blue-800">Users</a>
            </li>
            <li aria-current="page">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="ml-1 text-gray-500 md:ml-2"><?php echo e($user->full_name); ?></span>
                </div>
            </li>
        </ol>
    </nav>

    <!-- User Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="h-16 w-16 rounded-full bg-gray-300 flex items-center justify-center">
                    <span class="text-xl font-medium text-gray-700">
                        <?php echo e(strtoupper(substr($user->first_name, 0, 1) . substr($user->last_name, 0, 1))); ?>

                    </span>
                </div>
                <div class="ml-6">
                    <h1 class="text-2xl font-bold text-gray-900"><?php echo e($user->full_name); ?></h1>
                    <p class="text-gray-600">User ID: <?php echo e($user->id); ?></p>
                    <div class="flex items-center mt-2 space-x-4">
                        <?php if($user->is_active): ?>
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                        <?php else: ?>
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">Inactive</span>
                        <?php endif; ?>
                        
                        <?php if($user->is_blocked): ?>
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Blocked</span>
                        <?php endif; ?>

                        <?php if($user->email_verified_at): ?>
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">Email Verified</span>
                        <?php endif; ?>

                        <?php if($user->phone_verified_at): ?>
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-purple-100 text-purple-800">Phone Verified</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div class="flex space-x-2">
                <form action="<?php echo e(route('admin.users.toggle-active', $user)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn-secondary">
                        <?php echo e($user->is_active ? 'Deactivate' : 'Activate'); ?>

                    </button>
                </form>
                
                <form action="<?php echo e(route('admin.users.toggle-block', $user)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn-danger">
                        <?php echo e($user->is_blocked ? 'Unblock' : 'Block'); ?>

                    </button>
                </form>

                <?php if(!$user->email_verified_at || !$user->phone_verified_at): ?>
                    <form action="<?php echo e(route('admin.users.verify', $user)); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn-success">
                            Manually Verify
                        </button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Personal Information -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Personal Information</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">First Name</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->first_name); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Last Name</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->last_name); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Email</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->email); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Phone</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->phone); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Date of Birth</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->date_of_birth ? $user->date_of_birth->format('M d, Y') : 'Not provided'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Gender</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e(ucfirst($user->gender ?? 'Not provided')); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">City</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->city ?? 'Not provided'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">State</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->state ?? 'Not provided'); ?></p>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700">Address</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->address ?? 'Not provided'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Wallet Information -->
            <?php if($user->wallet): ?>
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <div class="flex justify-between items-center mb-4">
                    <h2 class="text-lg font-semibold text-gray-900">Wallet Information</h2>
                    <a href="<?php echo e(route('admin.users.wallet', $user)); ?>" class="btn-primary">Manage Wallet</a>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Balance</label>
                        <p class="mt-1 text-lg font-semibold text-gray-900">₦<?php echo e(number_format($user->wallet->balance, 2)); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Status</label>
                        <p class="mt-1">
                            <?php if($user->wallet->is_frozen): ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Frozen</span>
                            <?php else: ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                            <?php endif; ?>
                        </p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Created</label>
                        <p class="mt-1 text-sm text-gray-900"><?php echo e($user->wallet->created_at->format('M d, Y')); ?></p>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Recent Transactions -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Recent Transactions</h2>
                
                <?php if($transactions->count() > 0): ?>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-4 py-3 text-sm font-medium text-gray-900"><?php echo e(ucfirst($transaction->type)); ?></td>
                                <td class="px-4 py-3 text-sm text-gray-900">₦<?php echo e(number_format($transaction->amount, 2)); ?></td>
                                <td class="px-4 py-3">
                                    <?php if($transaction->status === 'completed'): ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Completed</span>
                                    <?php elseif($transaction->status === 'pending'): ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Pending</span>
                                    <?php else: ?>
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Failed</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-500"><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <p class="text-center text-gray-500 py-4">No transactions found.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <!-- KYC Status -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">KYC Status</h2>
                
                <?php if($user->kycVerification): ?>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Status</label>
                            <?php if($user->kycVerification->status === 'approved'): ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Verified</span>
                            <?php elseif($user->kycVerification->status === 'pending'): ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Pending</span>
                            <?php else: ?>
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Rejected</span>
                            <?php endif; ?>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Type</label>
                            <p class="mt-1 text-sm text-gray-900"><?php echo e(strtoupper($user->kycVerification->type)); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Submitted</label>
                            <p class="mt-1 text-sm text-gray-900"><?php echo e($user->kycVerification->created_at->format('M d, Y')); ?></p>
                        </div>
                    </div>
                <?php else: ?>
                    <p class="text-sm text-gray-500">No KYC verification submitted.</p>
                <?php endif; ?>
            </div>

            <!-- Account Actions -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Account Actions</h2>
                
                <div class="space-y-3">
                    <!-- Reset Password -->
                    <button onclick="showResetPasswordModal()" class="w-full btn-secondary">
                        Reset Password
                    </button>
                    
                    <!-- Reset 2FA -->
                    <?php if($user->two_factor_confirmed_at): ?>
                    <form action="<?php echo e(route('admin.users.reset-2fa', $user)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full btn-secondary" onclick="return confirm('Are you sure you want to reset 2FA for this user?')">
                            Reset 2FA
                        </button>
                    </form>
                    <?php endif; ?>
                    
                    <!-- Delete User -->
                    <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="w-full btn-danger" onclick="return confirm('Are you sure you want to delete this user? This action cannot be undone.')">
                            Delete User
                        </button>
                    </form>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Quick Stats</h2>
                
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Virtual Cards</span>
                        <span class="text-sm font-medium"><?php echo e($user->virtualCards->count()); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Virtual Accounts</span>
                        <span class="text-sm font-medium"><?php echo e($user->virtualAccounts->count()); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Last Login</span>
                        <span class="text-sm font-medium"><?php echo e($user->last_login_at ? $user->last_login_at->format('M d, Y') : 'Never'); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Registered</span>
                        <span class="text-sm font-medium"><?php echo e($user->created_at->format('M d, Y')); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reset Password Modal -->
<div id="resetPasswordModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Reset User Password</h3>
            <form action="<?php echo e(route('admin.users.reset-password', $user)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-4">
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-1">New Password</label>
                    <input type="password" name="password" id="password" required class="form-input">
                </div>
                <div class="mb-4">
                    <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-1">Confirm Password</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" required class="form-input">
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideResetPasswordModal()" class="btn-secondary">Cancel</button>
                    <button type="submit" class="btn-primary">Reset Password</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showResetPasswordModal() {
    document.getElementById('resetPasswordModal').classList.remove('hidden');
}

function hideResetPasswordModal() {
    document.getElementById('resetPasswordModal').classList.add('hidden');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/users/show.blade.php ENDPATH**/ ?>