<?php $__env->startSection('title', 'API Configuration Logs'); ?>
<?php $__env->startSection('page-title', 'API Configuration Logs'); ?>
<?php $__env->startSection('page-description', 'View all API configuration changes and test results'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <form method="GET" action="<?php echo e(route('admin.api-config.logs')); ?>" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <!-- Service Filter -->
            <div>
                <label for="service" class="block text-sm font-medium text-gray-700 mb-1">API Service</label>
                <select name="service" id="service" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    <option value="">All Services</option>
                    <?php $__currentLoopData = $apiConfigs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($config->id); ?>" <?php echo e(request('service') == $config->id ? 'selected' : ''); ?>>
                            <?php echo e($config->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!-- Action Filter -->
            <div>
                <label for="action" class="block text-sm font-medium text-gray-700 mb-1">Action</label>
                <select name="action" id="action" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    <option value="">All Actions</option>
                    <option value="update_api_config" <?php echo e(request('action') === 'update_api_config' ? 'selected' : ''); ?>>Configuration Updated</option>
                    <option value="activate_service" <?php echo e(request('action') === 'activate_service' ? 'selected' : ''); ?>>Service Activated</option>
                    <option value="deactivate_service" <?php echo e(request('action') === 'deactivate_service' ? 'selected' : ''); ?>>Service Deactivated</option>
                    <option value="toggle_service_mode" <?php echo e(request('action') === 'toggle_service_mode' ? 'selected' : ''); ?>>Mode Changed</option>
                    <option value="test_api_connection" <?php echo e(request('action') === 'test_api_connection' ? 'selected' : ''); ?>>Connection Tested</option>
                </select>
            </div>

            <!-- Date From -->
            <div>
                <label for="date_from" class="block text-sm font-medium text-gray-700 mb-1">Date From</label>
                <input type="date" name="date_from" id="date_from" value="<?php echo e(request('date_from')); ?>" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            </div>

            <!-- Date To -->
            <div>
                <label for="date_to" class="block text-sm font-medium text-gray-700 mb-1">Date To</label>
                <input type="date" name="date_to" id="date_to" value="<?php echo e(request('date_to')); ?>" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            </div>

            <!-- Submit Button -->
            <div class="flex items-end">
                <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                    Filter Logs
                </button>
            </div>
        </form>
    </div>

    <!-- Logs Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">API Configuration Activity</h3>
        </div>

        <?php if($logs->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Timestamp</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Action</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Service</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Changes</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">IP Address</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo e($log->created_at->format('M j, Y H:i:s')); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo e($log->user ? $log->user->full_name : 'System'); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                        $actionClasses = [
                                            'update_api_config' => 'bg-blue-100 text-blue-800',
                                            'activate_service' => 'bg-emerald-100 text-emerald-800',
                                            'deactivate_service' => 'bg-red-100 text-red-800',
                                            'toggle_service_mode' => 'bg-amber-100 text-amber-800',
                                            'test_api_connection' => 'bg-purple-100 text-purple-800',
                                        ];
                                        $actionLabels = [
                                            'update_api_config' => 'Configuration Updated',
                                            'activate_service' => 'Service Activated',
                                            'deactivate_service' => 'Service Deactivated',
                                            'toggle_service_mode' => 'Mode Changed',
                                            'test_api_connection' => 'Connection Tested',
                                        ];
                                    ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($actionClasses[$log->action] ?? 'bg-gray-100 text-gray-800'); ?>">
                                        <?php echo e($actionLabels[$log->action] ?? ucwords(str_replace('_', ' ', $log->action))); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php if($log->model_type === 'ApiConfig' && $log->model_id): ?>
                                        <?php
                                            $apiConfig = $apiConfigs->firstWhere('id', $log->model_id);
                                        ?>
                                        <?php echo e($apiConfig ? $apiConfig->name : 'Unknown Service'); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-500">
                                    <?php if($log->action === 'test_api_connection' && isset($log->new_values['success'])): ?>
                                        <?php if($log->new_values['success']): ?>
                                            <span class="text-emerald-600">✓ Test Successful</span>
                                            <?php if(isset($log->new_values['response_time'])): ?>
                                                <br><span class="text-xs text-gray-400"><?php echo e($log->new_values['response_time']); ?>ms</span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="text-red-600">✗ Test Failed</span>
                                            <?php if(isset($log->new_values['error'])): ?>
                                                <br><span class="text-xs text-gray-400"><?php echo e(Str::limit($log->new_values['error'], 50)); ?></span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php elseif($log->old_values && $log->new_values): ?>
                                        <?php
                                            $changes = [];
                                            foreach($log->new_values as $key => $newValue) {
                                                $oldValue = $log->old_values[$key] ?? null;
                                                if($oldValue != $newValue) {
                                                    if(in_array($key, ['api_key', 'secret_key', 'private_key', 'client_secret'])) {
                                                        $changes[] = ucwords(str_replace('_', ' ', $key)) . ' changed';
                                                    } else {
                                                        $changes[] = ucwords(str_replace('_', ' ', $key)) . ': ' . ($oldValue ?: 'null') . ' → ' . ($newValue ?: 'null');
                                                    }
                                                }
                                            }
                                        ?>
                                        <?php echo e(implode(', ', array_slice($changes, 0, 2))); ?>

                                        <?php if(count($changes) > 2): ?>
                                            <span class="text-gray-400">... and <?php echo e(count($changes) - 2); ?> more</span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo e($log->ip_address); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 border-t border-gray-200">
                <?php echo e($logs->appends(request()->query())->links()); ?>

            </div>
        <?php else: ?>
            <div class="px-6 py-12 text-center">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No logs found</h3>
                <p class="mt-1 text-sm text-gray-500">
                    <?php if(request()->hasAny(['service', 'action', 'date_from', 'date_to'])): ?>
                        No logs match your current filters.
                    <?php else: ?>
                        No API configuration logs available yet.
                    <?php endif; ?>
                </p>
                <?php if(request()->hasAny(['service', 'action', 'date_from', 'date_to'])): ?>
                    <div class="mt-6">
                        <a href="<?php echo e(route('admin.api-config.logs')); ?>" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700">
                            Clear Filters
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/api-config/logs.blade.php ENDPATH**/ ?>