<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('airtime_orders', function (Blueprint $table) {
            $table->id();
            $table->string('reference')->unique(); // Order reference
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('transaction_id')->constrained()->onDelete('cascade');
            $table->foreignId('airtime_provider_id')->constrained()->onDelete('restrict');
            
            // Service details
            $table->enum('service_type', ['airtime', 'data']);
            $table->string('network'); // mtn, glo, airtel, 9mobile
            $table->string('phone_number'); // Recipient phone number
            $table->decimal('amount', 10, 2); // Amount requested
            $table->decimal('discount_amount', 10, 2)->default(0.00); // Discount applied
            $table->decimal('margin_amount', 10, 2)->default(0.00); // Our profit margin
            $table->decimal('provider_cost', 10, 2); // What we pay the provider
            
            // Data bundle specific fields
            $table->string('data_plan_id')->nullable(); // Data bundle plan ID
            $table->string('data_plan_name')->nullable(); // e.g., "1GB Monthly"
            $table->integer('data_volume_mb')->nullable(); // Data volume in MB
            $table->integer('validity_days')->nullable(); // Plan validity in days
            
            // Order status and processing
            $table->enum('status', ['pending', 'processing', 'completed', 'failed', 'cancelled'])->default('pending');
            $table->string('provider_reference')->nullable(); // Provider's transaction reference
            $table->json('provider_response')->nullable(); // Full provider API response
            $table->text('failure_reason')->nullable(); // Reason for failure
            $table->timestamp('processed_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            
            // Audit fields
            $table->string('api_endpoint_used')->nullable(); // Which API endpoint was used
            $table->integer('retry_count')->default(0); // Number of retries
            $table->json('retry_log')->nullable(); // Log of retry attempts
            
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['user_id', 'created_at']);
            $table->index(['status', 'created_at']);
            $table->index(['service_type', 'network']);
            $table->index(['airtime_provider_id', 'status']);
            $table->index('phone_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('airtime_orders');
    }
};
