<?php

namespace Database\Seeders;

use App\Models\AirtimeProvider;
use Illuminate\Database\Seeder;

class AirtimeProvidersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $providers = [
            [
                'name' => 'VTPass',
                'slug' => 'vtpass',
                'module' => 'vtpass',
                'api_credentials' => [
                    'api_key' => env('VTPASS_API_KEY', ''),
                    'secret_key' => env('VTPASS_SECRET_KEY', ''),
                    'base_url' => 'https://vtpass.com/api',
                    'username' => env('VTPASS_USERNAME', ''),
                    'password' => env('VTPASS_PASSWORD', ''),
                ],
                'supported_services' => ['airtime', 'data'],
                'supported_networks' => ['mtn', 'glo', 'airtel', '9mobile'],
                'is_active' => false, // Disabled by default until configured
                'is_test_mode' => true,
                'priority' => 80,
            ],
            [
                'name' => 'Clubkonnect',
                'slug' => 'clubkonnect',
                'module' => 'clubkonnect',
                'api_credentials' => [
                    'username' => env('CLUBKONNECT_USERNAME', ''),
                    'password' => env('CLUBKONNECT_PASSWORD', ''),
                    'base_url' => 'https://www.nellobytesystems.com',
                    'api_key' => env('CLUBKONNECT_API_KEY', ''),
                ],
                'supported_services' => ['airtime', 'data'],
                'supported_networks' => ['mtn', 'glo', 'airtel', '9mobile'],
                'is_active' => false, // Disabled by default until configured
                'is_test_mode' => true,
                'priority' => 70,
            ],
            [
                'name' => 'BuyPower (Backup)',
                'slug' => 'buypower',
                'module' => 'buypower',
                'api_credentials' => [
                    'base_url' => 'https://buypower.ng/api/v2',
                    'api_token' => env('BUYPOWER_API_TOKEN', ''),
                    'private_key' => env('BUYPOWER_PRIVATE_KEY', ''),
                ],
                'supported_services' => ['airtime'],
                'supported_networks' => ['mtn', 'glo', 'airtel', '9mobile'],
                'is_active' => false, // Disabled by default
                'is_test_mode' => true,
                'priority' => 60,
            ],
            [
                'name' => 'SmartSMS Solutions',
                'slug' => 'smartsmssolutions',
                'module' => 'smartsmssolutions',
                'api_credentials' => [
                    'base_url' => 'https://smartsmssolutions.com/api',
                    'token' => env('SMARTSMS_TOKEN', ''),
                    'username' => env('SMARTSMS_USERNAME', ''),
                    'password' => env('SMARTSMS_PASSWORD', ''),
                ],
                'supported_services' => ['airtime', 'data'],
                'supported_networks' => ['mtn', 'glo', 'airtel', '9mobile'],
                'is_active' => false, // Disabled by default
                'is_test_mode' => true,
                'priority' => 50,
            ],
            [
                'name' => 'Custom Provider Template',
                'slug' => 'custom-template',
                'module' => 'custom',
                'api_credentials' => [
                    'base_url' => '',
                    'api_key' => '',
                    'secret_key' => '',
                    'username' => '',
                    'password' => '',
                    'headers' => [
                        'Content-Type' => 'application/json',
                        'Accept' => 'application/json',
                    ],
                    'endpoints' => [
                        'balance' => '/balance',
                        'airtime' => '/airtime',
                        'data' => '/data',
                        'status' => '/status',
                    ],
                ],
                'supported_services' => ['airtime', 'data'],
                'supported_networks' => ['mtn', 'glo', 'airtel', '9mobile'],
                'is_active' => false, // Template, not active by default
                'is_test_mode' => true,
                'priority' => 10,
            ],
        ];

        foreach ($providers as $providerData) {
            AirtimeProvider::updateOrCreate(
                ['slug' => $providerData['slug']],
                $providerData
            );
        }
    }
}
