@extends('layouts.admin-sidebar')

@section('title', 'Site Settings')
@section('page-title', 'Site Configuration')
@section('page-description', 'Manage general site settings and configurations')

@section('content')
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Site Configuration</h2>
            <p class="text-gray-600 mt-1">Configure your platform settings, features, and integrations</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="resetSettings()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                Reset to Defaults
            </button>
            <button class="btn-primary" onclick="saveSettings()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3-3m0 0l-3 3m3-3v12"></path>
                </svg>
                Save Changes
            </button>
        </div>
    </div>

    <form id="site-settings-form" class="space-y-6">
        @csrf
        
        <!-- Business Information -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Business Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Business Name</label>
                    <input type="text" 
                           value="{{ $settings['business']['name'] }}" 
                           name="business_name"
                           class="input-primary" 
                           placeholder="Enter business name">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Tagline</label>
                    <input type="text" 
                           value="{{ $settings['business']['tagline'] }}" 
                           name="business_tagline"
                           class="input-primary" 
                           placeholder="Enter business tagline">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                    <textarea name="business_description" 
                              rows="3" 
                              class="input-primary" 
                              placeholder="Enter business description">{{ $settings['business']['description'] }}</textarea>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Support Email</label>
                    <input type="email" 
                           value="{{ $settings['business']['support_email'] }}" 
                           name="support_email"
                           class="input-primary" 
                           placeholder="support@example.com">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Support Phone</label>
                    <input type="tel" 
                           value="{{ $settings['business']['support_phone'] }}" 
                           name="support_phone"
                           class="input-primary" 
                           placeholder="+234 800 000 0000">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Business Address</label>
                    <textarea name="business_address" 
                              rows="2" 
                              class="input-primary" 
                              placeholder="Enter business address">{{ $settings['business']['address'] }}</textarea>
                </div>
            </div>
        </div>

        <!-- Branding -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Branding & Assets</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Logo URL</label>
                    <input type="url" 
                           value="{{ $settings['business']['logo'] }}" 
                           name="logo_url"
                           class="input-primary" 
                           placeholder="https://example.com/logo.png">
                    <p class="text-xs text-gray-500 mt-1">Recommended size: 200x50px, PNG format</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Favicon URL</label>
                    <input type="url" 
                           value="{{ $settings['business']['favicon'] }}" 
                           name="favicon_url"
                           class="input-primary" 
                           placeholder="https://example.com/favicon.png">
                    <p class="text-xs text-gray-500 mt-1">Recommended size: 32x32px, PNG format</p>
                </div>
            </div>
            
            <!-- Logo Preview -->
            <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                <h4 class="text-sm font-medium text-gray-700 mb-2">Logo Preview</h4>
                <div class="flex items-center space-x-4">
                    <div class="w-32 h-16 bg-white border border-gray-200 rounded flex items-center justify-center">
                        @if($settings['business']['logo'])
                            <img src="{{ $settings['business']['logo'] }}" alt="Logo" class="max-w-full max-h-full">
                        @else
                            <span class="text-gray-400 text-xs">No logo</span>
                        @endif
                    </div>
                    <div class="w-8 h-8 bg-white border border-gray-200 rounded flex items-center justify-center">
                        @if($settings['business']['favicon'])
                            <img src="{{ $settings['business']['favicon'] }}" alt="Favicon" class="max-w-full max-h-full">
                        @else
                            <span class="text-gray-400 text-xs">No favicon</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Feature Toggles -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Feature Configuration</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($settings['features'] as $feature => $enabled)
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                    <div>
                        <h4 class="text-sm font-medium text-gray-900">{{ ucwords(str_replace('_', ' ', $feature)) }}</h4>
                        <p class="text-xs text-gray-500">
                            @switch($feature)
                                @case('enable_wallet_funding')
                                    Allow users to fund their wallets
                                    @break
                                @case('enable_p2p_transfers')
                                    Enable peer-to-peer transfers
                                    @break
                                @case('enable_bank_transfers')
                                    Allow bank transfers
                                    @break
                                @case('enable_bill_payments')
                                    Enable bill payment services
                                    @break
                                @case('enable_virtual_cards')
                                    Allow virtual card issuance
                                    @break
                                @case('enable_airtime_data')
                                    Enable airtime and data purchases
                                    @break
                                @case('enable_user_registration')
                                    Allow new user registrations
                                    @break
                                @case('maintenance_mode')
                                    Put site in maintenance mode
                                    @break
                                @default
                                    Feature configuration
                            @endswitch
                        </p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" 
                               name="features[{{ $feature }}]" 
                               value="1" 
                               {{ $enabled ? 'checked' : '' }}
                               class="sr-only peer">
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                    </label>
                </div>
                @endforeach
            </div>
        </div>

        <!-- Integration Settings -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Third-Party Integrations</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                @foreach($settings['integrations'] as $integration => $provider)
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">{{ ucwords(str_replace('_', ' ', $integration)) }}</label>
                    <select name="integrations[{{ $integration }}]" class="input-primary">
                        @switch($integration)
                            @case('sms_provider')
                                <option value="termii" {{ $provider === 'termii' ? 'selected' : '' }}>Termii</option>
                                <option value="twilio" {{ $provider === 'twilio' ? 'selected' : '' }}>Twilio</option>
                                <option value="nexmo" {{ $provider === 'nexmo' ? 'selected' : '' }}>Vonage (Nexmo)</option>
                                @break
                            @case('email_provider')
                                <option value="mailgun" {{ $provider === 'mailgun' ? 'selected' : '' }}>Mailgun</option>
                                <option value="sendgrid" {{ $provider === 'sendgrid' ? 'selected' : '' }}>SendGrid</option>
                                <option value="ses" {{ $provider === 'ses' ? 'selected' : '' }}>Amazon SES</option>
                                @break
                            @case('payment_gateway')
                                <option value="paystack" {{ $provider === 'paystack' ? 'selected' : '' }}>Paystack</option>
                                <option value="flutterwave" {{ $provider === 'flutterwave' ? 'selected' : '' }}>Flutterwave</option>
                                <option value="monnify" {{ $provider === 'monnify' ? 'selected' : '' }}>Monnify</option>
                                @break
                            @case('identity_provider')
                                <option value="dojah" {{ $provider === 'dojah' ? 'selected' : '' }}>Dojah</option>
                                <option value="youverify" {{ $provider === 'youverify' ? 'selected' : '' }}>Youverify</option>
                                <option value="prembly" {{ $provider === 'prembly' ? 'selected' : '' }}>Prembly</option>
                                @break
                            @case('card_provider')
                                <option value="anchor" {{ $provider === 'anchor' ? 'selected' : '' }}>Anchor</option>
                                <option value="pericent" {{ $provider === 'pericent' ? 'selected' : '' }}>Pericent</option>
                                <option value="bani" {{ $provider === 'bani' ? 'selected' : '' }}>Bani</option>
                                @break
                        @endswitch
                    </select>
                    <p class="text-xs text-gray-500 mt-1">
                        @switch($integration)
                            @case('sms_provider')
                                Provider for SMS notifications and OTP
                            @break
                            @case('email_provider')
                                Provider for email notifications
                            @break
                            @case('payment_gateway')
                                Primary payment processing gateway
                            @break
                            @case('identity_provider')
                                KYC and identity verification provider
                            @break
                            @case('card_provider')
                                Virtual card issuance provider
                            @break
                        @endswitch
                    </p>
                </div>
                @endforeach
            </div>
        </div>

        <!-- Security Settings -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Security Configuration</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Session Lifetime (minutes)</label>
                    <input type="number" 
                           value="{{ $settings['security']['session_lifetime'] }}" 
                           name="security[session_lifetime]"
                           min="30" 
                           max="480"
                           class="input-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Password Expiry (days)</label>
                    <input type="number" 
                           value="{{ $settings['security']['password_expiry_days'] }}" 
                           name="security[password_expiry_days]"
                           min="30" 
                           max="365"
                           class="input-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Max Login Attempts</label>
                    <input type="number" 
                           value="{{ $settings['security']['max_login_attempts'] }}" 
                           name="security[max_login_attempts]"
                           min="3" 
                           max="10"
                           class="input-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Lockout Duration (minutes)</label>
                    <input type="number" 
                           value="{{ $settings['security']['lockout_duration'] }}" 
                           name="security[lockout_duration]"
                           min="5" 
                           max="120"
                           class="input-primary">
                </div>
            </div>

            <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                    <div>
                        <h4 class="text-sm font-medium text-gray-900">Require Email Verification</h4>
                        <p class="text-xs text-gray-500">Users must verify email before account activation</p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" 
                               name="security[require_email_verification]" 
                               value="1" 
                               {{ $settings['security']['require_email_verification'] ? 'checked' : '' }}
                               class="sr-only peer">
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                    </label>
                </div>
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                    <div>
                        <h4 class="text-sm font-medium text-gray-900">Require Phone Verification</h4>
                        <p class="text-xs text-gray-500">Users must verify phone number via SMS OTP</p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" 
                               name="security[require_phone_verification]" 
                               value="1" 
                               {{ $settings['security']['require_phone_verification'] ? 'checked' : '' }}
                               class="sr-only peer">
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                    </label>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
function saveSettings() {
    const form = document.getElementById('site-settings-form');
    const formData = new FormData(form);
    
    // In a real implementation, this would submit the form data
    console.log('Saving site settings...');
    
    // Show success message
    alert('Site settings saved successfully!');
}

function resetSettings() {
    if(confirm('Are you sure you want to reset all settings to default values? This action cannot be undone.')) {
        // In a real implementation, this would reset settings to defaults
        location.reload();
    }
}

// Real-time logo preview update
document.querySelector('input[name="logo_url"]').addEventListener('input', function(e) {
    const logoPreview = document.querySelector('img[alt="Logo"]');
    if (logoPreview) {
        logoPreview.src = e.target.value || '';
    }
});

// Real-time favicon preview update
document.querySelector('input[name="favicon_url"]').addEventListener('input', function(e) {
    const faviconPreview = document.querySelector('img[alt="Favicon"]');
    if (faviconPreview) {
        faviconPreview.src = e.target.value || '';
    }
});
</script>
@endsection