@extends('layouts.responsive')

@section('title', 'BVN Verification')

@section('content')
<div class="space-y-8">
    <!-- Header Section -->
    <div class="text-center">
        <div class="w-20 h-20 bg-gradient-to-br from-blue-500 to-blue-700 rounded-2xl flex items-center justify-center mx-auto mb-6">
            <i class="fas fa-university text-white text-3xl"></i>
        </div>
        <h2 class="text-3xl font-bold text-white mb-4">BVN Verification</h2>
        <p class="text-gray-300 max-w-md mx-auto">
            Enter your Bank Verification Number to verify your identity instantly and securely
        </p>
    </div>
    
    <!-- Verification Form -->
    <div class="bg-dark-800/50 backdrop-blur-sm border border-dark-700/50 rounded-2xl p-6">
        <form method="POST" action="{{ route('kyc.bvn') }}" id="bvnForm">
            @csrf
            
            <div class="space-y-6">
                <div>
                    <label for="bvn" class="form-label">
                        <i class="fas fa-credit-card mr-2"></i>
                        BVN (Bank Verification Number)
                    </label>
                    <input id="bvn" type="text" name="bvn" value="{{ old('bvn') }}" 
                           class="form-input @error('bvn') border-red-500 focus:ring-red-500 @enderror" 
                           placeholder="Enter your 11-digit BVN"
                           maxlength="11"
                           pattern="[0-9]{11}"
                           required>
                    @error('bvn')
                        <p class="text-red-400 text-sm mt-2 flex items-center">
                            <i class="fas fa-exclamation-circle mr-2"></i>{{ $message }}
                        </p>
                    @enderror
                </div>

                <div>
                    <label for="first_name" class="form-label">
                        <i class="fas fa-user mr-2"></i>
                        First Name
                    </label>
                    <input id="first_name" type="text" name="first_name" value="{{ old('first_name') }}" 
                           class="form-input @error('first_name') border-red-500 focus:ring-red-500 @enderror" 
                           placeholder="Enter your first name as on BVN"
                           required>
                    @error('first_name')
                        <p class="text-red-400 text-sm mt-2 flex items-center">
                            <i class="fas fa-exclamation-circle mr-2"></i>{{ $message }}
                        </p>
                    @enderror
                </div>

                <div>
                    <label for="last_name" class="form-label">
                        <i class="fas fa-user mr-2"></i>
                        Last Name
                    </label>
                    <input id="last_name" type="text" name="last_name" value="{{ old('last_name') }}" 
                           class="form-input @error('last_name') border-red-500 focus:ring-red-500 @enderror" 
                           placeholder="Enter your last name as on BVN"
                           required>
                    @error('last_name')
                        <p class="text-red-400 text-sm mt-2 flex items-center">
                            <i class="fas fa-exclamation-circle mr-2"></i>{{ $message }}
                        </p>
                    @enderror
                </div>

                <div>
                    <label for="date_of_birth" class="form-label">
                        <i class="fas fa-calendar mr-2"></i>
                        Date of Birth
                    </label>
                    <input id="date_of_birth" type="date" name="date_of_birth" value="{{ old('date_of_birth') }}" 
                           class="form-input @error('date_of_birth') border-red-500 focus:ring-red-500 @enderror" 
                           required>
                    @error('date_of_birth')
                        <p class="text-red-400 text-sm mt-2 flex items-center">
                            <i class="fas fa-exclamation-circle mr-2"></i>{{ $message }}
                        </p>
                    @enderror
                </div>
            </div>

            <div class="flex flex-col sm:flex-row gap-4 mt-8">
                <a href="{{ route('kyc.index') }}" class="flex-1 py-4 bg-dark-700 hover:bg-dark-600 text-white font-semibold rounded-2xl transition-colors duration-200 text-center">
                    <i class="fas fa-arrow-left mr-2"></i>Back to KYC
                </a>
                <button type="submit" class="flex-1 py-4 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-2xl transition-colors duration-200 flex items-center justify-center">
                    <i class="fas fa-shield-check mr-2"></i>
                    <span id="submit-text">Verify BVN</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Information Card -->
    <div class="bg-gradient-to-r from-blue-500/20 to-blue-600/20 border border-blue-500/30 rounded-2xl p-6">
        <div class="flex items-start">
            <div class="w-12 h-12 bg-blue-500/20 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                <i class="fas fa-info-circle text-blue-400 text-xl"></i>
            </div>
            <div>
                <h4 class="text-blue-400 font-bold text-lg mb-2">Security & Privacy</h4>
                <ul class="text-gray-300 text-sm space-y-2">
                    <li class="flex items-center">
                        <i class="fas fa-lock text-blue-400 mr-2"></i>
                        Your BVN information is encrypted and stored securely
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-shield-alt text-blue-400 mr-2"></i>
                        Used only for identity verification as required by Nigerian regulations
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-clock text-blue-400 mr-2"></i>
                        Verification is usually instant but may take up to 24 hours
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Format BVN input to only allow numbers
document.getElementById('bvn').addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    if (value.length > 11) {
        value = value.slice(0, 11);
    }
    e.target.value = value;
    
    // Visual feedback for valid BVN length
    if (value.length === 11) {
        e.target.style.borderColor = 'rgb(34, 197, 94)';
    } else {
        e.target.style.borderColor = '';
    }
});

// Enhanced form validation
document.getElementById('bvnForm').addEventListener('submit', function(e) {
    const bvn = document.getElementById('bvn').value;
    const submitButton = this.querySelector('button[type="submit"]');
    const submitText = document.getElementById('submit-text');
    
    if (bvn.length !== 11) {
        e.preventDefault();
        showToast('Please enter a valid 11-digit BVN', 'error');
        return;
    }
    
    // Show loading state
    submitButton.disabled = true;
    submitText.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Verifying...';
});

function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    const iconClass = type === 'success' ? 'fa-check-circle' : type === 'error' ? 'fa-exclamation-circle' : 'fa-info-circle';
    const bgClass = type === 'success' ? 'bg-green-600' : type === 'error' ? 'bg-red-600' : 'bg-blue-600';
    
    toast.className = `fixed top-4 right-4 p-4 rounded-2xl text-white z-50 ${bgClass} flex items-center shadow-2xl max-w-sm`;
    toast.innerHTML = `
        <i class="fas ${iconClass} mr-3 text-lg"></i>
        <span class="font-medium">${message}</span>
    `;
    
    document.body.appendChild(toast);
    
    // Animate in
    toast.style.transform = 'translateX(100%)';
    setTimeout(() => {
        toast.style.transform = 'translateX(0)';
        toast.style.transition = 'transform 0.3s ease-out';
    }, 10);
    
    // Remove after delay
    setTimeout(() => {
        toast.style.transform = 'translateX(100%)';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
}
</script>
@endpush
@endsection