<?php $__env->startSection('title', 'Profit Margins Management'); ?>
<?php $__env->startSection('page-title', 'Profit Margins'); ?>
<?php $__env->startSection('page-description', 'Configure profit margins for airtime and data services'); ?>

<?php $__env->startSection('content'); ?>
<div id="margins-content" class="space-y-6">
    <?php if(isset($error)): ?>
    <div class="bg-red-50 border border-red-200 rounded-lg p-4">
        <div class="flex">
            <svg class="w-5 h-5 text-red-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
            </svg>
            <div>
                <h3 class="text-sm font-medium text-red-800">Database Error</h3>
                <p class="text-sm text-red-700 mt-1"><?php echo e($error); ?></p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Success Message -->
    <?php if(session('success')): ?>
    <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-6">
        <div class="flex">
            <svg class="w-5 h-5 text-green-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <div>
                <h3 class="text-sm font-medium text-green-800">Success</h3>
                <p class="text-sm text-green-700 mt-1"><?php echo e(session('success')); ?></p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Error Messages -->
    <?php if(session('error')): ?>
    <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
        <div class="flex">
            <svg class="w-5 h-5 text-red-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
            </svg>
            <div>
                <h3 class="text-sm font-medium text-red-800">Error</h3>
                <p class="text-sm text-red-700 mt-1"><?php echo e(session('error')); ?></p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Validation Errors -->
    <?php if($errors->any()): ?>
    <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
        <div class="flex">
            <svg class="w-5 h-5 text-red-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
            </svg>
            <div>
                <h3 class="text-sm font-medium text-red-800">Validation Errors</h3>
                <ul class="text-sm text-red-700 mt-1 list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Page Header with Actions -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Profit Margins Management</h2>
            <p class="text-gray-600 mt-1">Set and manage profit margins for different networks and services</p>
        </div>
        <div class="flex space-x-3">
            <button type="button" 
                    class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50 disabled:cursor-not-allowed" 
                    onclick="resetToDefaults()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                Reset to Defaults
            </button>
            <button type="button" 
                    class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50 disabled:cursor-not-allowed" 
                    onclick="saveAllMargins()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3-3m0 0l-3 3m3-3v12"></path>
                </svg>
                Save All Changes
            </button>
        </div>
    </div>

    <!-- Network-Specific Margins -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Network-Specific Margins</h3>
        
        <?php if(empty($margins)): ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 0v8m0 0H9m6 0V7M9 7V5a2 2 0 012-2h2a2 2 0 012 2v2M5 7h4"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No margins configured</h3>
            <p class="mt-1 text-sm text-gray-500">Database tables may not be initialized. Please run migrations.</p>
        </div>
        <?php else: ?>
        <form id="marginsForm" method="POST" action="<?php echo e(route('admin.airtime.margins.update')); ?>">
            <?php echo csrf_field(); ?>
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <?php $__currentLoopData = $margins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $network_code => $services): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="border border-gray-200 rounded-lg p-4">
                    <!-- Network Header -->
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-lg flex items-center justify-center mr-3
                                <?php echo e($network_code === 'mtn' ? 'bg-yellow-100' : 
                                   ($network_code === 'glo' ? 'bg-green-100' : 
                                   ($network_code === 'airtel' ? 'bg-red-100' : 'bg-green-100'))); ?>">
                                <span class="font-bold text-sm
                                    <?php echo e($network_code === 'mtn' ? 'text-yellow-800' : 
                                       ($network_code === 'glo' ? 'text-green-800' : 
                                       ($network_code === 'airtel' ? 'text-red-800' : 'text-green-800'))); ?>">
                                    <?php echo e(strtoupper(substr($network_code, 0, 3))); ?>

                                </span>
                            </div>
                            <div>
                                <h4 class="text-lg font-semibold text-gray-900"><?php echo e(ucfirst($network_code)); ?></h4>
                                <div class="flex items-center space-x-2 mt-1">
                                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full bg-emerald-100 text-emerald-800">
                                        Active
                                    </span>
                                    <?php if(isset($networkStats[$network_code]) && $networkStats[$network_code]['providers_count'] > 0): ?>
                                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full bg-blue-100 text-blue-800">
                                        <?php echo e($networkStats[$network_code]['providers_count']); ?> Provider<?php echo e($networkStats[$network_code]['providers_count'] > 1 ? 's' : ''); ?>

                                    </span>
                                    <?php endif; ?>
                                </div>
                                <?php if(isset($networkStats[$network_code])): ?>
                                <div class="text-xs text-gray-500 mt-1">
                                    <div>Providers: <?php echo e($networkStats[$network_code]['active_providers']); ?></div>
                                    <?php if($networkStats[$network_code]['avg_response_time'] > 0): ?>
                                    <div>Avg Response: <?php echo e(number_format($networkStats[$network_code]['avg_response_time'])); ?>ms</div>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Margin Controls -->
                    <div class="grid grid-cols-2 gap-4">
                        <?php if(isset($services['airtime'])): ?>
                        <!-- Airtime Margin -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Airtime Margin (%)</label>
                            <div class="relative">
                                <input type="hidden" name="margins[airtime_<?php echo e($network_code); ?>][id]" value="<?php echo e($services['airtime']->id ?? ''); ?>">
                                <input type="hidden" name="margins[airtime_<?php echo e($network_code); ?>][network]" value="<?php echo e($network_code); ?>">
                                <input type="hidden" name="margins[airtime_<?php echo e($network_code); ?>][service_type]" value="airtime">
                                <input type="number" 
                                       name="margins[airtime_<?php echo e($network_code); ?>][margin_percentage]"
                                       value="<?php echo e($services['airtime']->margin_percentage ?? 2.5); ?>" 
                                       min="0.5" 
                                       max="50" 
                                       step="0.1"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" 
                                       id="airtime_margin_<?php echo e($network_code); ?>"
                                       onchange="calculateProfit('<?php echo e($network_code); ?>', 'airtime')">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 text-sm">%</span>
                                </div>
                            </div>
                            <div class="mt-2 text-xs text-gray-600">
                                <span id="airtime_example_<?php echo e($network_code); ?>">Example: ₦100 → ₦<?php echo e(number_format(100 + (($services['airtime']->margin_percentage ?? 2.5) / 100 * 100), 2)); ?></span>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if(isset($services['data'])): ?>
                        <!-- Data Margin -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Data Margin (%)</label>
                            <div class="relative">
                                <input type="hidden" name="margins[data_<?php echo e($network_code); ?>][id]" value="<?php echo e($services['data']->id ?? ''); ?>">
                                <input type="hidden" name="margins[data_<?php echo e($network_code); ?>][network]" value="<?php echo e($network_code); ?>">
                                <input type="hidden" name="margins[data_<?php echo e($network_code); ?>][service_type]" value="data">
                                <input type="number" 
                                       name="margins[data_<?php echo e($network_code); ?>][margin_percentage]"
                                       value="<?php echo e($services['data']->margin_percentage ?? 3.0); ?>" 
                                       min="0.5" 
                                       max="50" 
                                       step="0.1"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" 
                                       id="data_margin_<?php echo e($network_code); ?>"
                                       onchange="calculateProfit('<?php echo e($network_code); ?>', 'data')">
                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 text-sm">%</span>
                                </div>
                            </div>
                            <div class="mt-2 text-xs text-gray-600">
                                <span id="data_example_<?php echo e($network_code); ?>">Example: ₦1000 → ₦<?php echo e(number_format(1000 + (($services['data']->margin_percentage ?? 3.0) / 100 * 1000), 2)); ?></span>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Quick Margin Presets -->
                    <div class="mt-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Quick Presets</label>
                        <div class="flex space-x-2">
                            <button type="button" 
                                    class="px-3 py-1 text-xs font-medium text-gray-700 bg-gray-100 hover:bg-gray-200 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-1 transition-colors duration-200" 
                                    onclick="setMargins('<?php echo e($network_code); ?>', 1.5, 2.0)">
                                Conservative
                            </button>
                            <button type="button" 
                                    class="px-3 py-1 text-xs font-medium text-blue-700 bg-blue-100 hover:bg-blue-200 border border-blue-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-1 transition-colors duration-200" 
                                    onclick="setMargins('<?php echo e($network_code); ?>', 2.5, 3.0)">
                                Balanced
                            </button>
                            <button type="button" 
                                    class="px-3 py-1 text-xs font-medium text-green-700 bg-green-100 hover:bg-green-200 border border-green-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-1 transition-colors duration-200" 
                                    onclick="setMargins('<?php echo e($network_code); ?>', 3.5, 4.0)">
                                Aggressive
                            </button>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <?php if(!empty($margins)): ?>
            <div class="mt-6 flex justify-end">
                <button type="submit" 
                        class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 disabled:opacity-50 disabled:cursor-not-allowed">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3-3m0 0l-3 3m3-3v12"></path>
                    </svg>
                    Update Margins
                </button>
            </div>
            <?php endif; ?>
        </form>
        <?php endif; ?>
    </div>
</div>

<script>
// Global variables to track networks
const networks = <?php echo json_encode(array_keys($margins ?? []), 15, 512) ?>;
let isSubmitting = false;

function calculateProfit(networkCode, type) {
    const marginInput = document.getElementById(`${type}_margin_${networkCode}`);
    const exampleSpan = document.getElementById(`${type}_example_${networkCode}`);
    
    if (!marginInput || !exampleSpan) return;
    
    const margin = parseFloat(marginInput.value) || 0;
    const baseAmount = type === 'airtime' ? 100 : 1000;
    const finalAmount = baseAmount + (margin / 100 * baseAmount);
    
    // Update example calculation
    exampleSpan.textContent = `Example: ₦${baseAmount.toLocaleString('en-NG', {minimumFractionDigits: 2, maximumFractionDigits: 2})} → ₦${finalAmount.toLocaleString('en-NG', {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
    
    // Validate margin range
    validateMargin(marginInput, margin);
}

function validateMargin(input, margin) {
    const min = parseFloat(input.getAttribute('min')) || 0.5;
    const max = parseFloat(input.getAttribute('max')) || 50;
    
    // Remove previous validation classes
    input.classList.remove('border-red-500', 'border-green-500');
    
    if (margin < min || margin > max) {
        input.classList.add('border-red-500');
        showNotification(`Margin must be between ${min}% and ${max}%`, 'error');
    } else {
        input.classList.add('border-green-500');
    }
}

function setMargins(networkCode, airtimeMargin, dataMargin) {
    const airtimeInput = document.getElementById(`airtime_margin_${networkCode}`);
    const dataInput = document.getElementById(`data_margin_${networkCode}`);
    
    if (airtimeInput) {
        airtimeInput.value = airtimeMargin;
        calculateProfit(networkCode, 'airtime');
    }
    
    if (dataInput) {
        dataInput.value = dataMargin;
        calculateProfit(networkCode, 'data');
    }
    
    showNotification(`Preset applied to ${networkCode.toUpperCase()}. Don't forget to save!`, 'info');
}

function resetToDefaults() {
    if(!confirm('Are you sure you want to reset all margins to default values? This action cannot be undone.')) {
        return;
    }
    
    // Reset all input fields to default values
    networks.forEach(networkCode => {
        const airtimeInput = document.getElementById(`airtime_margin_${networkCode}`);
        const dataInput = document.getElementById(`data_margin_${networkCode}`);
        
        if (airtimeInput) {
            airtimeInput.value = '2.5';
            calculateProfit(networkCode, 'airtime');
        }
        if (dataInput) {
            dataInput.value = '3.0';
            calculateProfit(networkCode, 'data');
        }
    });
    
    showNotification('All margins reset to default values. Click "Update Margins" to apply.', 'warning');
}

function saveAllMargins() {
    if (isSubmitting) return;
    
    const form = document.getElementById('marginsForm');
    if (!form) {
        showNotification('Form not found', 'error');
        return;
    }
    
    // Validate all margins before submitting
    let hasErrors = false;
    networks.forEach(networkCode => {
        ['airtime', 'data'].forEach(type => {
            const input = document.getElementById(`${type}_margin_${networkCode}`);
            if (input) {
                const margin = parseFloat(input.value) || 0;
                const min = parseFloat(input.getAttribute('min')) || 0.5;
                const max = parseFloat(input.getAttribute('max')) || 50;
                
                if (margin < min || margin > max) {
                    hasErrors = true;
                    input.classList.add('border-red-500');
                }
            }
        });
    });
    
    if (hasErrors) {
        showNotification('Please fix the validation errors before saving', 'error');
        return;
    }
    
    isSubmitting = true;
    const submitButton = form.querySelector('button[type="submit"]');
    const saveAllButton = document.querySelector('button[onclick="saveAllMargins()"]');
    
    // Show loading state
    if (submitButton) {
        submitButton.disabled = true;
        submitButton.innerHTML = '<svg class="w-4 h-4 mr-2 animate-spin" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Saving...';
    }
    
    if (saveAllButton) {
        saveAllButton.disabled = true;
        saveAllButton.innerHTML = '<svg class="w-4 h-4 mr-2 animate-spin" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Saving...';
    }
    
    form.submit();
}

function showNotification(message, type = 'info') {
    // Create notification element
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg max-w-sm ${getNotificationClasses(type)}`;
    notification.innerHTML = `
        <div class="flex items-center">
            <div class="flex-shrink-0">
                ${getNotificationIcon(type)}
            </div>
            <div class="ml-3">
                <p class="text-sm font-medium">${message}</p>
            </div>
            <div class="ml-auto pl-3">
                <button type="button" data-close-notification class="text-gray-400 hover:text-gray-600">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (notification.parentElement) {
            notification.remove();
        }
    }, 5000);
}

function getNotificationClasses(type) {
    switch(type) {
        case 'error': return 'bg-red-50 border border-red-200 text-red-800';
        case 'success': return 'bg-green-50 border border-green-200 text-green-800';
        case 'warning': return 'bg-yellow-50 border border-yellow-200 text-yellow-800';
        default: return 'bg-blue-50 border border-blue-200 text-blue-800';
    }
}

function getNotificationIcon(type) {
    const baseClasses = 'w-5 h-5';
    switch(type) {
        case 'error': 
            return `<svg class="${baseClasses} text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path></svg>`;
        case 'success':
            return `<svg class="${baseClasses} text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>`;
        case 'warning':
            return `<svg class="${baseClasses} text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path></svg>`;
        default:
            return `<svg class="${baseClasses} text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>`;
    }
}

// Initialize calculations on page load
document.addEventListener('DOMContentLoaded', function() {
    networks.forEach(networkCode => {
        calculateProfit(networkCode, 'airtime');
        calculateProfit(networkCode, 'data');
    });
});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/airtime/margins.blade.php ENDPATH**/ ?>