<?php $__env->startSection('title', 'Virtual Cards Management'); ?>
<?php $__env->startSection('page-title', 'Virtual Cards'); ?>
<?php $__env->startSection('page-description', 'Manage virtual cards, limits, and settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Cards</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e(number_format($stats['total_cards'])); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Active Cards</p>
                    <p class="text-2xl font-bold text-emerald-600"><?php echo e(number_format($stats['active_cards'])); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Frozen Cards</p>
                    <p class="text-2xl font-bold text-amber-600"><?php echo e(number_format($stats['frozen_cards'])); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Terminated</p>
                    <p class="text-2xl font-bold text-red-600"><?php echo e(number_format($stats['terminated_cards'])); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-red-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636m12.728 12.728L18.364 5.636M5.636 18.364l12.728-12.728"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Spending</p>
                    <p class="text-xl font-bold text-purple-600">₦<?php echo e(number_format($stats['total_spending'], 2)); ?></p>
                </div>
                <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Card Provider Status Warnings -->
    <?php if($problematicProviders->count() > 0): ?>
    <div class="bg-amber-50 border border-amber-200 rounded-xl p-6">
        <div class="flex items-center mb-4">
            <svg class="w-5 h-5 text-amber-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.662-.833-2.464 0L3.34 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
            </svg>
            <h3 class="text-lg font-semibold text-amber-800">Card Provider Configuration Issues</h3>
        </div>
        
        <p class="text-amber-700 mb-4">Some card providers have configuration issues that may prevent card assignment:</p>
        
        <div class="space-y-3">
            <?php $__currentLoopData = $problematicProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-lg p-4 border border-amber-200">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center mr-3">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                            </svg>
                        </div>
                        <div>
                            <h4 class="font-medium text-gray-900"><?php echo e($provider['name']); ?></h4>
                            <div class="text-sm text-gray-600">
                                <?php if(!$provider['config_exists']): ?>
                                    <span class="text-red-600">⚠ Not configured</span>
                                <?php elseif(!$provider['configured']): ?>
                                    <span class="text-amber-600">⚠ Configuration incomplete</span>
                                <?php elseif(!$provider['is_active']): ?>
                                    <span class="text-gray-600">⚠ Inactive</span>
                                <?php elseif($provider['last_test_status'] === 'failed'): ?>
                                    <span class="text-red-600">⚠ Connection test failed</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex items-center space-x-2">
                        <?php if(!$provider['config_exists']): ?>
                            <a href="<?php echo e(route('admin.api-config.create')); ?>?template=<?php echo e($provider['slug']); ?>" 
                               class="px-3 py-1 bg-blue-600 text-white text-sm rounded-lg hover:bg-blue-700 transition-colors">
                                Configure
                            </a>
                        <?php else: ?>
                            <?php
                                $config = \App\Models\ApiConfig::where('slug', $provider['slug'])->first();
                            ?>
                            <?php if($config): ?>
                                <a href="<?php echo e(route('admin.api-config.show', $config)); ?>" 
                                   class="px-3 py-1 bg-amber-600 text-white text-sm rounded-lg hover:bg-amber-700 transition-colors">
                                    Fix Issues
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                
                <?php if($provider['config_errors'] && count($provider['config_errors']) > 0): ?>
                <div class="mt-3 pl-13">
                    <ul class="text-sm text-amber-700 space-y-1">
                        <?php $__currentLoopData = $provider['config_errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>• <?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Card Provider Status - Working Providers -->
    <?php if($activeProviders->count() > 0): ?>
    <div class="bg-emerald-50 border border-emerald-200 rounded-xl p-6">
        <div class="flex items-center mb-4">
            <svg class="w-5 h-5 text-emerald-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <h3 class="text-lg font-semibold text-emerald-800">Available Card Providers</h3>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php $__currentLoopData = $activeProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-lg p-4 border border-emerald-200">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                        </svg>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-medium text-gray-900"><?php echo e($provider['name']); ?></h4>
                        <div class="flex items-center text-sm text-emerald-600">
                            <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                            </svg>
                            Ready for card assignment
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Filters and Search -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Search</label>
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                       placeholder="User name, email, card number..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                <select name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Statuses</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    <option value="frozen" <?php echo e(request('status') === 'frozen' ? 'selected' : ''); ?>>Frozen</option>
                    <option value="terminated" <?php echo e(request('status') === 'terminated' ? 'selected' : ''); ?>>Terminated</option>
                </select>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Type</label>
                <select name="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Types</option>
                    <option value="virtual" <?php echo e(request('type') === 'virtual' ? 'selected' : ''); ?>>Virtual</option>
                    <option value="physical" <?php echo e(request('type') === 'physical' ? 'selected' : ''); ?>>Physical</option>
                </select>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">From Date</label>
                <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">To Date</label>
                <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            
            <div class="flex items-end space-x-2">
                <button type="submit" class="flex-1 bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors">
                    Filter
                </button>
                <a href="<?php echo e(route('admin.virtual-cards.index')); ?>" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                    Clear
                </a>
            </div>
        </form>
    </div>

    <!-- Virtual Cards List -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900">Virtual Cards (<?php echo e($cards->total()); ?>)</h3>
                <div class="flex items-center space-x-2">
                    <button onclick="showAssignCardModal()" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                        <svg class="w-4 h-4 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Assign Card
                    </button>
                    <a href="<?php echo e(route('admin.virtual-cards.analytics')); ?>" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-colors">
                        View Analytics
                    </a>
                    <button class="px-4 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition-colors">
                        Export CSV
                    </button>
                </div>
            </div>
        </div>

        <?php if($cards->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 border-b border-gray-200">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Card Details</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Created</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="w-12 h-8 bg-gradient-to-r from-blue-600 to-purple-600 rounded-lg flex items-center justify-center mr-3">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($card->masked_pan); ?></div>
                                    <div class="text-sm text-gray-500"><?php echo e(strtoupper($card->brand)); ?> • <?php echo e(strtoupper($card->card_type)); ?></div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($card->user->full_name); ?></div>
                            <div class="text-sm text-gray-500"><?php echo e($card->user->email); ?></div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-bold text-gray-900"><?php echo e($card->currency); ?> <?php echo e(number_format($card->balance, 2)); ?></div>
                            <div class="text-sm text-gray-500">Daily: <?php echo e($card->currency); ?> <?php echo e(number_format($card->daily_limit, 2)); ?></div>
                        </td>
                        <td class="px-6 py-4">
                            <?php if($card->status === 'active'): ?>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-emerald-100 text-emerald-800">
                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    Active
                                </span>
                            <?php elseif($card->status === 'frozen'): ?>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-amber-100 text-amber-800">
                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    Frozen
                                </span>
                            <?php elseif($card->status === 'terminated'): ?>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-red-100 text-red-800">
                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                                    </svg>
                                    Terminated
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-gray-100 text-gray-800">
                                    <?php echo e(ucfirst($card->status)); ?>

                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-500">
                            <?php echo e($card->created_at->format('M d, Y')); ?>

                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center space-x-2">
                                <a href="<?php echo e(route('admin.virtual-cards.show', $card)); ?>" class="text-blue-600 hover:text-blue-900 text-sm font-medium">
                                    View
                                </a>
                                
                                <?php if($card->status !== 'terminated'): ?>
                                    <button onclick="showCreditModal(<?php echo e($card->id); ?>, '<?php echo e($card->masked_pan); ?>', <?php echo e($card->balance); ?>)" class="text-emerald-600 hover:text-emerald-900 text-sm font-medium">
                                        Credit
                                    </button>
                                    
                                    <?php if($card->balance > 0): ?>
                                        <button onclick="showDebitModal(<?php echo e($card->id); ?>, '<?php echo e($card->masked_pan); ?>', <?php echo e($card->balance); ?>)" class="text-amber-600 hover:text-amber-900 text-sm font-medium">
                                            Debit
                                        </button>
                                    <?php endif; ?>
                                    
                                    <?php if($card->status === 'active'): ?>
                                        <form action="<?php echo e(route('admin.virtual-cards.freeze', $card)); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="text-amber-600 hover:text-amber-900 text-sm font-medium" onclick="return confirm('Are you sure you want to freeze this card?')">
                                                Freeze
                                            </button>
                                        </form>
                                    <?php elseif($card->status === 'frozen'): ?>
                                        <form action="<?php echo e(route('admin.virtual-cards.unfreeze', $card)); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="text-emerald-600 hover:text-emerald-900 text-sm font-medium">
                                                Unfreeze
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    
                                    <form action="<?php echo e(route('admin.virtual-cards.terminate', $card)); ?>" method="POST" class="inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="text-red-600 hover:text-red-900 text-sm font-medium" onclick="return confirm('Are you sure you want to terminate this card? This action cannot be undone.')">
                                            Terminate
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
            <?php echo e($cards->links()); ?>

        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
            </svg>
            <h3 class="text-lg font-medium text-gray-900 mb-2">No virtual cards found</h3>
            <p class="text-gray-500 mb-4">Get started by assigning a virtual card to a user.</p>
            <button onclick="showAssignCardModal()" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                <svg class="w-4 h-4 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Assign First Card
            </button>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Assign Card Modal -->
<div id="assignCardModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-10 mx-auto p-5 border w-full max-w-2xl shadow-lg rounded-xl bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900">Assign Virtual Card</h3>
                <button onclick="hideAssignCardModal()" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
            <form action="<?php echo e(route('admin.virtual-cards.assign')); ?>" method="POST" id="assignCardForm">
                <?php echo csrf_field(); ?>
                
                <!-- User Selection -->
                <div class="mb-4">
                    <label for="user_id" class="block text-sm font-medium text-gray-700 mb-1">Select User <span class="text-red-500">*</span></label>
                    <select name="user_id" id="user_id" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">Choose a user...</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?> (<?php echo e($user->email); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Provider Selection -->
                <div class="mb-4">
                    <label for="provider" class="block text-sm font-medium text-gray-700 mb-1">Card Provider <span class="text-red-500">*</span></label>
                    <select name="provider" id="provider" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" onchange="updateProviderInfo()">
                        <option value="">Choose a provider...</option>
                        <?php $__currentLoopData = $cardProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $isAvailable = $provider['configured'] && $provider['is_active'] && $provider['last_test_status'] !== 'failed';
                                $statusText = '';
                                if (!$provider['config_exists']) {
                                    $statusText = ' (Not Configured)';
                                } elseif (!$provider['configured']) {
                                    $statusText = ' (Config Incomplete)';
                                } elseif (!$provider['is_active']) {
                                    $statusText = ' (Inactive)';
                                } elseif ($provider['last_test_status'] === 'failed') {
                                    $statusText = ' (Connection Failed)';
                                } elseif ($provider['is_live_mode']) {
                                    $statusText = ' (Live)';
                                } else {
                                    $statusText = ' (Test Mode)';
                                }
                            ?>
                            <option value="<?php echo e($provider['slug']); ?>" 
                                    data-name="<?php echo e($provider['name']); ?>" 
                                    data-configured="<?php echo e($provider['configured'] ? 'true' : 'false'); ?>"
                                    data-active="<?php echo e($provider['is_active'] ? 'true' : 'false'); ?>"
                                    data-config-exists="<?php echo e($provider['config_exists'] ? 'true' : 'false'); ?>"
                                    data-live="<?php echo e($provider['is_live_mode'] ? 'true' : 'false'); ?>"
                                    data-test-status="<?php echo e($provider['last_test_status'] ?? 'unknown'); ?>"
                                    data-config-errors="<?php echo e(json_encode($provider['config_errors'])); ?>"
                                    <?php if(!$isAvailable): ?> disabled <?php endif; ?>>
                                <?php echo e($provider['name']); ?><?php echo e($statusText); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div id="providerInfo" class="hidden mt-2 p-2 bg-blue-50 border border-blue-200 rounded text-sm text-blue-700"></div>
                </div>

                <!-- Card Details Row -->
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="card_type" class="block text-sm font-medium text-gray-700 mb-1">Card Type <span class="text-red-500">*</span></label>
                        <select name="card_type" id="card_type" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="virtual">Virtual</option>
                            <option value="physical">Physical</option>
                        </select>
                    </div>
                    <div>
                        <label for="brand" class="block text-sm font-medium text-gray-700 mb-1">Brand <span class="text-red-500">*</span></label>
                        <select name="brand" id="brand" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="visa">Visa</option>
                            <option value="mastercard">Mastercard</option>
                        </select>
                    </div>
                </div>

                <!-- Currency and Funding Row -->
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="currency" class="block text-sm font-medium text-gray-700 mb-1">Currency <span class="text-red-500">*</span></label>
                        <select name="currency" id="currency" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="USD">USD</option>
                            <option value="NGN">NGN</option>
                        </select>
                    </div>
                    <div>
                        <label for="funding_amount" class="block text-sm font-medium text-gray-700 mb-1">Initial Funding Amount <span class="text-red-500">*</span></label>
                        <input type="number" name="funding_amount" id="funding_amount" value="0" min="0" max="100000" step="0.01" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>

                <!-- Limits Row -->
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="daily_limit" class="block text-sm font-medium text-gray-700 mb-1">Daily Limit <span class="text-red-500">*</span></label>
                        <input type="number" name="daily_limit" id="daily_limit" value="1000" min="0" max="100000" step="0.01" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label for="monthly_limit" class="block text-sm font-medium text-gray-700 mb-1">Monthly Limit <span class="text-red-500">*</span></label>
                        <input type="number" name="monthly_limit" id="monthly_limit" value="30000" min="0" max="1000000" step="0.01" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex justify-end space-x-2 pt-4 border-t border-gray-200">
                    <button type="button" onclick="hideAssignCardModal()" class="px-4 py-2 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition-colors duration-200">
                        Cancel
                    </button>
                    <button type="submit" id="assignCardBtn" class="px-4 py-2 bg-blue-600 text-sm font-medium rounded-lg text-white hover:bg-blue-700 transition-colors duration-200">
                        <span class="btn-text">Assign Card</span>
                        <span class="btn-loading hidden">
                            <svg class="animate-spin -ml-1 mr-3 h-4 w-4 text-white inline" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            Creating Card...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.virtual-cards.partials.credit-debit-modals', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<script>
function showAssignCardModal() {
    document.getElementById('assignCardModal').classList.remove('hidden');
}

function hideAssignCardModal() {
    document.getElementById('assignCardModal').classList.add('hidden');
    // Reset form
    document.getElementById('assignCardForm').reset();
    document.getElementById('providerInfo').classList.add('hidden');
}

function updateProviderInfo() {
    const providerSelect = document.getElementById('provider');
    const selectedOption = providerSelect.options[providerSelect.selectedIndex];
    const infoDiv = document.getElementById('providerInfo');
    const assignBtn = document.getElementById('assignCardBtn');
    
    if (selectedOption.value) {
        const isConfigured = selectedOption.getAttribute('data-configured') === 'true';
        const isActive = selectedOption.getAttribute('data-active') === 'true';
        const configExists = selectedOption.getAttribute('data-config-exists') === 'true';
        const isLive = selectedOption.getAttribute('data-live') === 'true';
        const testStatus = selectedOption.getAttribute('data-test-status');
        const name = selectedOption.getAttribute('data-name');
        const configErrors = JSON.parse(selectedOption.getAttribute('data-config-errors') || '[]');
        
        let infoHtml = '';
        let infoClass = '';
        let canAssign = true;
        
        if (!configExists) {
            infoHtml = `⚠️ <strong>${name}</strong> is not configured. Please configure the API settings first.<br>
                       <a href="/admin/api-config/create?template=${selectedOption.value}" class="text-blue-600 hover:text-blue-800 underline mt-2 inline-block">Configure ${name}</a>`;
            infoClass = 'mt-2 p-3 bg-red-50 border border-red-200 rounded text-sm text-red-700';
            canAssign = false;
        } else if (!isConfigured) {
            infoHtml = `⚠️ <strong>${name}</strong> configuration is incomplete:<br>`;
            if (configErrors.length > 0) {
                infoHtml += '<ul class="mt-1 ml-4 list-disc">';
                configErrors.forEach(error => {
                    infoHtml += `<li>${error}</li>`;
                });
                infoHtml += '</ul>';
            }
            infoHtml += `<a href="/admin/api-config?search=${name}" class="text-amber-600 hover:text-amber-800 underline mt-2 inline-block">Fix Configuration Issues</a>`;
            infoClass = 'mt-2 p-3 bg-amber-50 border border-amber-200 rounded text-sm text-amber-700';
            canAssign = false;
        } else if (!isActive) {
            infoHtml = `⚠️ <strong>${name}</strong> is not active. Please activate it first.<br>
                       <a href="/admin/api-config?search=${name}" class="text-gray-600 hover:text-gray-800 underline mt-2 inline-block">Activate ${name}</a>`;
            infoClass = 'mt-2 p-3 bg-gray-50 border border-gray-200 rounded text-sm text-gray-700';
            canAssign = false;
        } else if (testStatus === 'failed') {
            infoHtml = `⚠️ <strong>${name}</strong> last connection test failed. Please test the connection first.<br>
                       <a href="/admin/api-config?search=${name}" class="text-red-600 hover:text-red-800 underline mt-2 inline-block">Test Connection</a>`;
            infoClass = 'mt-2 p-3 bg-red-50 border border-red-200 rounded text-sm text-red-700';
            canAssign = false;
        } else if (isLive) {
            infoHtml = `✅ <strong>${name}</strong> is ready for card assignment (Live mode).<br>
                       <span class="text-emerald-600">Cards created will be real and functional.</span>`;
            infoClass = 'mt-2 p-3 bg-emerald-50 border border-emerald-200 rounded text-sm text-emerald-700';
        } else {
            infoHtml = `🧪 <strong>${name}</strong> is ready for card assignment (Test mode).<br>
                       <span class="text-amber-600">Cards created will be for testing purposes only.</span>`;
            infoClass = 'mt-2 p-3 bg-amber-50 border border-amber-200 rounded text-sm text-amber-700';
        }
        
        infoDiv.innerHTML = infoHtml;
        infoDiv.className = infoClass;
        infoDiv.classList.remove('hidden');
        
        // Enable/disable assign button
        assignBtn.disabled = !canAssign;
        if (canAssign) {
            assignBtn.className = 'px-4 py-2 bg-blue-600 text-sm font-medium rounded-lg text-white hover:bg-blue-700 transition-colors duration-200';
        } else {
            assignBtn.className = 'px-4 py-2 bg-gray-400 text-sm font-medium rounded-lg text-white cursor-not-allowed';
        }
    } else {
        infoDiv.classList.add('hidden');
        assignBtn.disabled = false;
        assignBtn.className = 'px-4 py-2 bg-blue-600 text-sm font-medium rounded-lg text-white hover:bg-blue-700 transition-colors duration-200';
    }
}

// Handle form submission with loading state
document.getElementById('assignCardForm').addEventListener('submit', function(e) {
    const btn = document.getElementById('assignCardBtn');
    const btnText = btn.querySelector('.btn-text');
    const btnLoading = btn.querySelector('.btn-loading');
    
    // Show loading state
    btnText.classList.add('hidden');
    btnLoading.classList.remove('hidden');
    btn.disabled = true;
    
    // The form will submit normally, but if there's an error and we stay on the page,
    // we should reset the button state after a short delay
    setTimeout(() => {
        btnText.classList.remove('hidden');
        btnLoading.classList.add('hidden');
        btn.disabled = false;
    }, 5000);
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/virtual-cards/index.blade.php ENDPATH**/ ?>