<?php $__env->startSection('title', 'Bill Payments'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Monthly Stats -->
    <div class="grid grid-cols-2 gap-4">
        <div class="card bg-gradient-to-r from-success-600/20 to-success-700/20 border-success-600/30">
            <div class="text-center">
                <p class="text-success-400 text-sm font-medium mb-1">This Month</p>
                <p class="text-2xl font-bold text-white">₦<?php echo e(number_format($monthlySpending ?? 0, 2)); ?></p>
                <p class="text-xs text-gray-400">Bill payments</p>
            </div>
        </div>
        
        <div class="card bg-gradient-to-r from-primary-600/20 to-primary-700/20 border-primary-600/30">
            <div class="text-center">
                <p class="text-primary-400 text-sm font-medium mb-1">Transactions</p>
                <p class="text-2xl font-bold text-white"><?php echo e($monthlyTransactions ?? 0); ?></p>
                <p class="text-xs text-gray-400">This month</p>
            </div>
        </div>
    </div>

    <!-- Service Categories -->
    <div class="space-y-4">
        <h2 class="text-lg font-semibold text-white">Services</h2>
        
        <div class="grid grid-cols-2 gap-4">
            <!-- Airtime -->
            <a href="<?php echo e(route('bills.airtime')); ?>" class="card-gradient hover:bg-dark-700/50 transition-all duration-200 active:scale-95">
                <div class="text-center p-4">
                    <div class="w-16 h-16 bg-gradient-to-r from-success-500 to-success-600 rounded-xl flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-mobile-alt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-white font-semibold mb-1">Airtime</h3>
                    <p class="text-gray-400 text-xs mb-2">All networks</p>
                    <div class="flex items-center justify-center text-xs text-success-400">
                        <i class="fas fa-bolt mr-1"></i>
                        <span>Instant</span>
                    </div>
                </div>
            </a>
            
            <!-- Data -->
            <a href="<?php echo e(route('bills.data')); ?>" class="card-gradient hover:bg-dark-700/50 transition-all duration-200 active:scale-95">
                <div class="text-center p-4">
                    <div class="w-16 h-16 bg-gradient-to-r from-primary-500 to-primary-600 rounded-xl flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-wifi text-white text-2xl"></i>
                    </div>
                    <h3 class="text-white font-semibold mb-1">Data</h3>
                    <p class="text-gray-400 text-xs mb-2">All plans</p>
                    <div class="flex items-center justify-center text-xs text-primary-400">
                        <i class="fas fa-zap mr-1"></i>
                        <span>Fast</span>
                    </div>
                </div>
            </a>
            
            <!-- Electricity -->
            <a href="<?php echo e(route('bills.electricity')); ?>" class="card-gradient hover:bg-dark-700/50 transition-all duration-200 active:scale-95">
                <div class="text-center p-4">
                    <div class="w-16 h-16 bg-gradient-to-r from-warning-500 to-warning-600 rounded-xl flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-bolt text-white text-2xl"></i>
                    </div>
                    <h3 class="text-white font-semibold mb-1">Electricity</h3>
                    <p class="text-gray-400 text-xs mb-2">All DisCos</p>
                    <div class="flex items-center justify-center text-xs text-warning-400">
                        <i class="fas fa-shield-alt mr-1"></i>
                        <span>Secure</span>
                    </div>
                </div>
            </a>
            
            <!-- Cable TV -->
            <a href="#" onclick="showComingSoon('Cable TV')" class="card-gradient hover:bg-dark-700/50 transition-all duration-200 active:scale-95">
                <div class="text-center p-4">
                    <div class="w-16 h-16 bg-gradient-to-r from-purple-500 to-purple-600 rounded-xl flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-tv text-white text-2xl"></i>
                    </div>
                    <h3 class="text-white font-semibold mb-1">Cable TV</h3>
                    <p class="text-gray-400 text-xs mb-2">DSTV, GOTV</p>
                    <div class="flex items-center justify-center text-xs text-purple-400">
                        <i class="fas fa-clock mr-1"></i>
                        <span>Soon</span>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="space-y-4">
        <h3 class="text-lg font-semibold text-white">Quick Actions</h3>
        
        <div class="space-y-3">
            <!-- Repeat Last Transaction -->
            <?php if($lastTransaction): ?>
            <button onclick="repeatTransaction()" class="w-full card-gradient hover:bg-dark-700/50 transition-colors p-4">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-primary-600/20 rounded-lg flex items-center justify-center mr-4">
                        <i class="fas fa-redo text-primary-400"></i>
                    </div>
                    <div class="flex-1 text-left">
                        <p class="text-white font-medium">Repeat Last Purchase</p>
                        <p class="text-gray-400 text-sm"><?php echo e($lastTransaction->description ?? 'Quick repeat'); ?></p>
                    </div>
                    <i class="fas fa-chevron-right text-gray-500"></i>
                </div>
            </button>
            <?php endif; ?>
            
            <!-- Favorites -->
            <button onclick="showFavorites()" class="w-full card-gradient hover:bg-dark-700/50 transition-colors p-4">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-warning-600/20 rounded-lg flex items-center justify-center mr-4">
                        <i class="fas fa-star text-warning-400"></i>
                    </div>
                    <div class="flex-1 text-left">
                        <p class="text-white font-medium">Favorites</p>
                        <p class="text-gray-400 text-sm">Your saved contacts</p>
                    </div>
                    <i class="fas fa-chevron-right text-gray-500"></i>
                </div>
            </button>
            
            <!-- Transaction History -->
            <a href="<?php echo e(route('transactions.index')); ?>?category=bill_payment" class="block w-full card-gradient hover:bg-dark-700/50 transition-colors p-4">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-dark-600 rounded-lg flex items-center justify-center mr-4">
                        <i class="fas fa-history text-gray-400"></i>
                    </div>
                    <div class="flex-1 text-left">
                        <p class="text-white font-medium">Bill History</p>
                        <p class="text-gray-400 text-sm">View all bill payments</p>
                    </div>
                    <i class="fas fa-chevron-right text-gray-500"></i>
                </div>
            </a>
        </div>
    </div>

    <!-- Recent Transactions -->
    <?php if($recentBillPayments && $recentBillPayments->count() > 0): ?>
    <div class="space-y-4">
        <div class="flex justify-between items-center">
            <h3 class="text-lg font-semibold text-white">Recent Bills</h3>
            <a href="<?php echo e(route('transactions.index')); ?>?category=bill_payment" class="text-primary-400 text-sm">View All</a>
        </div>
        
        <div class="space-y-3">
            <?php $__currentLoopData = $recentBillPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="transaction-item">
                <div class="flex items-center flex-1">
                    <div class="transaction-icon <?php echo e($transaction->status === 'completed' ? 'bg-success-600/20 text-success-400' : ($transaction->status === 'pending' ? 'bg-warning-600/20 text-warning-400' : 'bg-error-600/20 text-error-400')); ?>">
                        <?php if($transaction->category === 'airtime_purchase'): ?>
                            <i class="fas fa-mobile-alt"></i>
                        <?php elseif($transaction->category === 'data_purchase'): ?>
                            <i class="fas fa-wifi"></i>
                        <?php elseif($transaction->category === 'bill_payment'): ?>
                            <i class="fas fa-bolt"></i>
                        <?php else: ?>
                            <i class="fas fa-receipt"></i>
                        <?php endif; ?>
                    </div>
                    <div class="ml-3 flex-1">
                        <p class="text-white font-medium text-sm"><?php echo e($transaction->description); ?></p>
                        <p class="text-gray-400 text-xs"><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="font-semibold text-sm text-error-400">-₦<?php echo e(number_format($transaction->amount, 2)); ?></p>
                    <div class="status-badge mt-1 <?php echo e($transaction->status === 'completed' ? 'status-success' : ($transaction->status === 'pending' ? 'status-pending' : 'status-failed')); ?>">
                        <?php echo e(ucfirst($transaction->status)); ?>

                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Service Providers Info -->
    <div class="card">
        <h3 class="text-lg font-semibold text-white mb-4">Supported Networks</h3>
        <div class="grid grid-cols-4 gap-4">
            <div class="text-center">
                <div class="w-12 h-12 bg-yellow-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <span class="text-white font-bold text-sm">MTN</span>
                </div>
                <p class="text-gray-400 text-xs">Available</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <span class="text-white font-bold text-sm">GLO</span>
                </div>
                <p class="text-gray-400 text-xs">Available</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 bg-red-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <span class="text-white font-bold text-sm">ATL</span>
                </div>
                <p class="text-gray-400 text-xs">Available</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 bg-green-800 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <span class="text-white font-bold text-xs">9MOB</span>
                </div>
                <p class="text-gray-400 text-xs">Available</p>
            </div>
        </div>
    </div>
</div>

<!-- Coming Soon Modal -->
<div id="comingSoonModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="absolute bottom-0 left-0 right-0 bg-dark-900 rounded-t-3xl p-6 slide-up">
        <div class="w-12 h-1 bg-gray-600 rounded-full mx-auto mb-6"></div>
        <div class="text-center">
            <div class="w-16 h-16 bg-primary-600 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-clock text-white text-2xl"></i>
            </div>
            <h3 class="text-xl font-semibold text-white mb-2" id="comingSoonTitle">Coming Soon</h3>
            <p class="text-gray-400 mb-6">This service will be available soon. We'll notify you when it's ready!</p>
            <button onclick="closeComingSoonModal()" class="w-full btn btn-primary">Got it</button>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function showComingSoon(serviceName) {
    document.getElementById('comingSoonTitle').textContent = serviceName + ' - Coming Soon';
    document.getElementById('comingSoonModal').classList.remove('hidden');
}

function closeComingSoonModal() {
    document.getElementById('comingSoonModal').classList.add('hidden');
}

function repeatTransaction() {
    // TODO: Implement repeat transaction functionality
    showToast('Repeat transaction feature coming soon!', 'info');
}

function showFavorites() {
    // TODO: Implement favorites functionality
    showToast('Favorites feature coming soon!', 'info');
}

function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `fixed top-4 right-4 p-4 rounded-lg text-white z-50 ${type === 'success' ? 'bg-success-600' : type === 'error' ? 'bg-error-600' : 'bg-primary-600'}`;
    toast.textContent = message;
    document.body.appendChild(toast);
    
    setTimeout(() => {
        toast.remove();
    }, 3000);
}

// Close modal when clicking outside
document.addEventListener('click', function(event) {
    const modal = document.getElementById('comingSoonModal');
    if (event.target === modal) {
        closeComingSoonModal();
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
                <h3 class="text-lg font-bold text-gray-900 mb-1">Buy Data</h3>
                <p class="text-sm text-gray-600 mb-2">All networks & plans</p>
                <p class="text-xs text-blue-600 font-medium">🎯 Instant activation • No fees</p>
            </div>
        </div>
    </div>
    
    <!-- Electricity -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location.href='<?php echo e(route('bills.electricity')); ?>'">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-yellow-400 to-yellow-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">⚡</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Electricity</h3>
                <p class="text-sm text-gray-600 mb-2">All DisCos supported</p>
                <p class="text-xs text-yellow-600 font-medium">🎯 Instant credit • 1% fee</p>
            </div>
        </div>
    </div>
    
    <!-- Cable TV -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer opacity-75">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-purple-400 to-purple-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">📺</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Cable TV</h3>
                <p class="text-sm text-gray-600 mb-2">DSTV, GOtv, Startimes</p>
                <p class="text-xs text-purple-600 font-medium">🚧 Coming Soon</p>
            </div>
        </div>
    </div>
    
    <!-- Internet -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer opacity-75">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-indigo-400 to-indigo-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">🌐</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Internet</h3>
                <p class="text-sm text-gray-600 mb-2">Smile, Spectranet, Swift</p>
                <p class="text-xs text-indigo-600 font-medium">🚧 Coming Soon</p>
            </div>
        </div>
    </div>
    
    <!-- Education -->
    <div class="card hover:shadow-lg transition-shadow cursor-pointer opacity-75">
        <div class="flex items-start">
            <div class="w-16 h-16 bg-gradient-to-r from-teal-400 to-teal-600 rounded-xl flex items-center justify-center mr-4">
                <span class="text-3xl text-white">🎓</span>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-bold text-gray-900 mb-1">Education</h3>
                <p class="text-sm text-gray-600 mb-2">WAEC, JAMB, NECO pins</p>
                <p class="text-xs text-teal-600 font-medium">🚧 Coming Soon</p>
            </div>
        </div>
    </div>
</div>

<!-- Quick Access -->
<div class="card mb-6">
    <h3 class="text-lg font-bold mb-4">Quick Access</h3>
    <div class="grid md:grid-cols-3 gap-4">
        <!-- Recent Recipients -->
        <?php if($recentRecipients && count($recentRecipients) > 0): ?>
        <div>
            <h4 class="text-sm font-medium text-gray-700 mb-2">Recent Recipients</h4>
            <div class="space-y-2">
                <?php $__currentLoopData = $recentRecipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recipient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium"><?php echo e($recipient['phone']); ?></p>
                        <p class="text-xs text-gray-500"><?php echo e($recipient['network']); ?> • <?php echo e($recipient['type']); ?></p>
                    </div>
                    <button onclick="quickRecharge('<?php echo e($recipient['phone']); ?>', '<?php echo e($recipient['network']); ?>', '<?php echo e($recipient['type']); ?>')" 
                            class="text-xs px-2 py-1 bg-blue-100 text-blue-800 rounded hover:bg-blue-200">
                        Recharge
                    </button>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Saved Beneficiaries -->
        <div>
            <h4 class="text-sm font-medium text-gray-700 mb-2">Saved Numbers</h4>
            <div class="text-center py-4 text-gray-500">
                <p class="text-sm">No saved numbers yet</p>
                <button class="text-xs text-blue-600 hover:text-blue-800">Add Number</button>
            </div>
        </div>
        
        <!-- Popular Plans -->
        <div>
            <h4 class="text-sm font-medium text-gray-700 mb-2">Popular Data Plans</h4>
            <div class="space-y-2">
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium">MTN 1GB</p>
                        <p class="text-xs text-gray-500">30 days validity</p>
                    </div>
                    <span class="text-sm font-bold text-gray-900">₦350</span>
                </div>
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium">Airtel 2GB</p>
                        <p class="text-xs text-gray-500">30 days validity</p>
                    </div>
                    <span class="text-sm font-bold text-gray-900">₦600</span>
                </div>
                <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                    <div>
                        <p class="text-sm font-medium">Glo 3GB</p>
                        <p class="text-xs text-gray-500">30 days validity</p>
                    </div>
                    <span class="text-sm font-bold text-gray-900">₦1,000</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="card">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-bold">Recent Bill Payments</h3>
        <a href="<?php echo e(route('transactions.index')); ?>?category=bill" class="text-blue-600 hover:text-blue-800 text-sm font-medium">View All →</a>
    </div>
    
    <?php if($recentBillPayments && count($recentBillPayments) > 0): ?>
        <div class="space-y-3">
            <?php $__currentLoopData = $recentBillPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center mr-3 bg-<?php echo e($payment->status === 'completed' ? 'green' : ($payment->status === 'failed' ? 'red' : 'yellow')); ?>-100">
                        <span class="text-lg">
                            <?php if($payment->category === 'airtime_purchase'): ?> 📱
                            <?php elseif($payment->category === 'data_purchase'): ?> 📶
                            <?php elseif($payment->category === 'bill_payment'): ?> ⚡
                            <?php else: ?> 💳
                            <?php endif; ?>
                        </span>
                    </div>
                    <div>
                        <p class="font-medium"><?php echo e($payment->description); ?></p>
                        <p class="text-sm text-gray-600"><?php echo e($payment->created_at->format('M d, Y H:i')); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <p class="font-semibold text-red-600">-₦<?php echo e(number_format($payment->amount, 2)); ?></p>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        <?php if($payment->status === 'completed'): ?> bg-green-100 text-green-800
                        <?php elseif($payment->status === 'pending' || $payment->status === 'processing'): ?> bg-yellow-100 text-yellow-800
                        <?php else: ?> bg-red-100 text-red-800
                        <?php endif; ?>">
                        <?php echo e(ucfirst($payment->status)); ?>

                    </span>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="text-center py-8 text-gray-500">
            <span class="text-6xl mb-4 block">📱</span>
            <p class="text-lg font-medium mb-2">No bill payments yet</p>
            <p class="text-sm">Start by buying airtime or data</p>
        </div>
    <?php endif; ?>
</div>

<script>
function quickRecharge(phone, network, type) {
    if (type === 'airtime') {
        const amount = prompt(`Enter airtime amount for ${phone} (${network}):`);
        if (amount && !isNaN(amount) && parseFloat(amount) >= 50) {
            window.location.href = `<?php echo e(route('bills.airtime')); ?>?phone=${phone}&network=${network}&amount=${amount}`;
        }
    } else if (type === 'data') {
        window.location.href = `<?php echo e(route('bills.data')); ?>?phone=${phone}&network=${network}`;
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.mobile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/bills/index.blade.php ENDPATH**/ ?>