<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <!-- Enhanced Balance Card -->
    <div class="balance-card slide-up">
        <div class="relative z-10">
            <div class="flex justify-between items-start mb-6">
                <div>
                    <p class="text-white/70 text-sm font-medium">Total Balance</p>
                    <p class="text-4xl font-bold text-white mt-1">₦<?php echo e(number_format($wallet?->balance ?? 0, 2)); ?></p>
                    <?php if($wallet && $wallet->is_frozen): ?>
                        <div class="flex items-center mt-3">
                            <i class="fas fa-lock text-red-400 text-sm mr-2"></i>
                            <span class="text-red-400 text-sm font-medium">Wallet Frozen</span>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="text-right">
                    <button class="p-3 bg-white/15 rounded-2xl hover:bg-white/25 transition-all duration-200 backdrop-blur-sm">
                        <i class="fas fa-eye text-white text-lg"></i>
                    </button>
                </div>
            </div>
            
            <div class="flex justify-between items-end">
                <div>
                    <p class="text-white/60 text-xs uppercase tracking-wide font-medium">Available</p>
                    <p class="text-white font-bold text-lg">₦<?php echo e(number_format($wallet?->available_balance ?? 0, 2)); ?></p>
                </div>
                <div class="text-right">
                    <p class="text-white/60 text-xs uppercase tracking-wide font-medium">Daily Limit</p>
                    <p class="text-white font-bold text-lg">₦<?php echo e(number_format($wallet?->remaining_daily_limit ?? 0, 2)); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Quick Actions -->
    <div class="space-y-6">
        <h3 class="text-xl font-bold text-white">Quick Actions</h3>
        <div class="grid grid-cols-4 gap-4">
            <a href="<?php echo e(route('transfer.p2p')); ?>" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-blue-500 to-blue-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-paper-plane"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Transfer</span>
            </a>
            
            <a href="#" onclick="requestMoney()" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-green-500 to-green-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-hand-holding-usd"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Request</span>
            </a>
            
            <a href="#" onclick="openScanner()" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-orange-500 to-orange-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-qrcode"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Scan</span>
            </a>
            
            <a href="#" onclick="showSwapOptions()" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-purple-500 to-purple-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-exchange-alt"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Swap</span>
            </a>
        </div>
        
        <!-- More Actions Row -->
        <div class="grid grid-cols-4 gap-4">
            <a href="<?php echo e(route('wallet.index')); ?>" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-cyan-500 to-cyan-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-plus"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Fund</span>
            </a>
            
            <a href="<?php echo e(route('bills.airtime')); ?>" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-emerald-500 to-emerald-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-mobile-alt"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Airtime</span>
            </a>
            
            <a href="<?php echo e(route('bills.data')); ?>" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-indigo-500 to-indigo-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-wifi"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Data</span>
            </a>
            
            <a href="#" onclick="showMoreOptions()" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-gray-500 to-gray-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-ellipsis-h"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">More</span>
            </a>
        </div>
    </div>

    <!-- KYC Status Alert -->
    <?php if(!auth()->user()->hasCompletedKyc()): ?>
    <div class="bg-gradient-to-r from-orange-500/20 to-yellow-500/20 border border-orange-500/30 rounded-2xl p-5 backdrop-blur-sm">
        <div class="flex items-start">
            <div class="w-10 h-10 bg-orange-500/20 rounded-full flex items-center justify-center mr-4">
                <i class="fas fa-exclamation-triangle text-orange-400 text-lg"></i>
            </div>
            <div class="flex-1">
                <h4 class="text-orange-400 font-bold mb-2">Complete Your KYC</h4>
                <p class="text-gray-300 text-sm mb-4">Verify your identity to unlock higher limits and virtual cards.</p>
                <a href="<?php echo e(route('kyc.index')); ?>" class="inline-flex items-center px-4 py-2 bg-orange-500 hover:bg-orange-600 text-white font-semibold rounded-xl transition-colors duration-200">
                    <i class="fas fa-shield-check mr-2"></i>
                    Verify Now
                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Enhanced Virtual Cards -->
    <?php if($virtualCards && count($virtualCards) > 0): ?>
    <div class="space-y-6">
        <div class="flex justify-between items-center">
            <h3 class="text-xl font-bold text-white">My Cards</h3>
            <a href="<?php echo e(route('cards.index')); ?>" class="text-primary-400 text-sm font-semibold hover:text-primary-300 transition-colors">View All</a>
        </div>
        
        <div class="space-y-4">
            <?php $__currentLoopData = $virtualCards->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-gradient-to-br from-dark-800/80 to-dark-700/80 backdrop-blur-sm rounded-2xl p-5 border border-dark-600/50 hover:border-dark-500 transition-all duration-200">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <p class="text-gray-400 text-xs font-semibold uppercase tracking-wider"><?php echo e(strtoupper($card->card_type)); ?> CARD</p>
                        <p class="text-white font-mono text-xl font-bold mt-1">•••• •••• •••• <?php echo e(substr($card->card_number, -4)); ?></p>
                    </div>
                    <div class="status-badge <?php echo e($card->status === 'active' ? 'bg-green-500/20 text-green-400 border border-green-500/30' : 'bg-red-500/20 text-red-400 border border-red-500/30'); ?> px-3 py-1 rounded-full">
                        <i class="fas fa-circle text-xs mr-1"></i><?php echo e(ucfirst($card->status)); ?>

                    </div>
                </div>
                <div class="flex justify-between items-end">
                    <div>
                        <p class="text-gray-400 text-xs uppercase tracking-wide font-medium">Balance</p>
                        <p class="text-white font-bold text-xl">₦<?php echo e(number_format($card->balance, 2)); ?></p>
                    </div>
                    <div class="text-right">
                        <p class="text-gray-400 text-xs uppercase tracking-wide font-medium">Limit</p>
                        <p class="text-gray-300 text-sm font-semibold">₦<?php echo e(number_format($card->spending_limit, 0)); ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Enhanced Recent Transactions -->
    <div class="space-y-6">
        <div class="flex justify-between items-center">
            <h3 class="text-xl font-bold text-white">Recent Transactions</h3>
            <a href="<?php echo e(route('transactions.index')); ?>" class="text-primary-400 text-sm font-semibold hover:text-primary-300 transition-colors">View All</a>
        </div>
        
        <?php if($recentTransactions && $recentTransactions->count() > 0): ?>
            <div class="space-y-3">
                <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="transaction-item group">
                    <div class="flex items-center flex-1">
                        <div class="transaction-icon <?php echo e($transaction->type === 'credit' ? 'bg-green-500/20 text-green-400 border border-green-500/30' : 'bg-red-500/20 text-red-400 border border-red-500/30'); ?>">
                            <?php if($transaction->category === 'wallet_funding'): ?>
                                <i class="fas fa-plus"></i>
                            <?php elseif($transaction->category === 'p2p_transfer'): ?>
                                <i class="fas fa-exchange-alt"></i>
                            <?php elseif($transaction->category === 'bank_transfer'): ?>
                                <i class="fas fa-university"></i>
                            <?php elseif($transaction->category === 'airtime_purchase'): ?>
                                <i class="fas fa-mobile-alt"></i>
                            <?php elseif($transaction->category === 'data_purchase'): ?>
                                <i class="fas fa-wifi"></i>
                            <?php elseif($transaction->category === 'bill_payment'): ?>
                                <i class="fas fa-bolt"></i>
                            <?php else: ?>
                                <i class="fas fa-credit-card"></i>
                            <?php endif; ?>
                        </div>
                        <div class="ml-4 flex-1">
                            <p class="text-white font-semibold text-sm"><?php echo e($transaction->description); ?></p>
                            <div class="flex items-center mt-1">
                                <p class="text-gray-400 text-xs"><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></p>
                                <span class="mx-2 text-gray-600">•</span>
                                <div class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium <?php echo e($transaction->status === 'completed' ? 'bg-green-500/20 text-green-400' : ($transaction->status === 'pending' ? 'bg-yellow-500/20 text-yellow-400' : 'bg-red-500/20 text-red-400')); ?>">
                                    <i class="fas fa-circle text-[8px] mr-1"></i><?php echo e(ucfirst($transaction->status)); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="font-bold text-base <?php echo e($transaction->type === 'credit' ? 'text-green-400' : 'text-red-400'); ?>">
                            <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction->amount, 2)); ?>

                        </p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center py-16">
                <div class="w-20 h-20 bg-dark-800/50 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-receipt text-gray-500 text-3xl"></i>
                </div>
                <h4 class="text-white font-bold text-lg mb-2">No transactions yet</h4>
                <p class="text-gray-400 text-sm mb-6">Start by funding your wallet to begin</p>
                <a href="<?php echo e(route('wallet.index')); ?>" class="inline-flex items-center px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-xl transition-colors duration-200">
                    <i class="fas fa-plus mr-2"></i>Fund Wallet
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Enhanced More Options Modal -->
<div id="moreOptionsModal" class="fixed inset-0 bg-black/60 backdrop-blur-sm hidden z-50">
    <div class="absolute bottom-0 left-0 right-0 bg-dark-900/95 backdrop-blur-xl rounded-t-3xl p-6 slide-up border-t border-dark-700/50">
        <div class="w-12 h-1 bg-gray-600 rounded-full mx-auto mb-6"></div>
        <h3 class="text-xl font-bold text-white mb-6">More Services</h3>
        <div class="grid grid-cols-3 gap-4 mb-8">
            <a href="<?php echo e(route('bills.electricity')); ?>" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-yellow-500 to-yellow-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-bolt"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Electricity</span>
            </a>
            <a href="<?php echo e(route('virtual-account.index')); ?>" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-indigo-500 to-indigo-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-university"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Virtual Account</span>
            </a>
            <a href="<?php echo e(route('cards.index')); ?>" class="quick-action group">
                <div class="quick-action-icon bg-gradient-to-br from-purple-500 to-purple-700 text-white group-hover:scale-110 transition-transform duration-200">
                    <i class="fas fa-credit-card"></i>
                </div>
                <span class="text-xs text-gray-300 font-semibold">Cards</span>
            </a>
        </div>
        <button onclick="closeModal('moreOptionsModal')" class="w-full bg-dark-700 hover:bg-dark-600 text-white font-semibold py-4 rounded-2xl transition-colors duration-200">
            Close
        </button>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function requestMoney() {
    // TODO: Implement request money functionality
    alert('Request money feature coming soon!');
}

function openScanner() {
    // TODO: Implement QR code scanner
    alert('QR Scanner feature coming soon!');
}

function showSwapOptions() {
    // TODO: Implement currency swap
    alert('Currency swap feature coming soon!');
}

function showMoreOptions() {
    document.getElementById('moreOptionsModal').classList.remove('hidden');
}

function closeModal(modalId) {
    document.getElementById(modalId).classList.add('hidden');
}

// Close modal when clicking outside
document.addEventListener('click', function(event) {
    const modal = document.getElementById('moreOptionsModal');
    if (event.target === modal) {
        closeModal('moreOptionsModal');
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.responsive', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/dashboard.blade.php ENDPATH**/ ?>