<?php $__env->startSection('title', 'Buy Airtime'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-6">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div class="flex items-center">
            <a href="<?php echo e(route('bills.index')); ?>" class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center mr-4 hover:bg-dark-700 transition-colors">
                <i class="fas fa-arrow-left text-gray-300"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold text-white">Buy Airtime</h1>
                <p class="text-sm text-gray-400">Purchase airtime for any network</p>
            </div>
        </div>
    </div>

    <?php if($errors->any()): ?>
        <div class="bg-red-500/20 border border-red-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-red-400 mr-2"></i>
                <span class="text-red-400 text-sm">Please fix the following errors:</span>
            </div>
            <ul class="mt-2 text-red-400 text-sm">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="ml-4">• <?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('bills.airtime')); ?>" class="space-y-6">
        <?php echo csrf_field(); ?>

        <!-- Network Selection -->
        <div class="space-y-3">
            <label class="text-white font-medium">Select Network</label>
            <div class="grid grid-cols-2 gap-3">
                <?php $__currentLoopData = $networks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $network): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="radio" id="network_<?php echo e($network); ?>" name="network" value="<?php echo e($network); ?>" class="hidden network-radio" 
                           <?php echo e(old('network') == $network ? 'checked' : ''); ?>>
                    <label for="network_<?php echo e($network); ?>" class="network-option card-gradient border border-gray-600 rounded-xl p-4 text-center cursor-pointer transition-all duration-200 hover:border-primary-500">
                        <div class="flex flex-col items-center">
                            <?php switch($network):
                                case ('MTN'): ?>
                                    <div class="w-12 h-12 bg-yellow-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-black font-bold text-lg">MTN</span>
                                    </div>
                                    <?php break; ?>
                                <?php case ('Glo'): ?>
                                    <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-white font-bold text-lg">Glo</span>
                                    </div>
                                    <?php break; ?>
                                <?php case ('Airtel'): ?>
                                    <div class="w-12 h-12 bg-red-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-white font-bold text-lg">A</span>
                                    </div>
                                    <?php break; ?>
                                <?php case ('9mobile'): ?>
                                    <div class="w-12 h-12 bg-purple-500 rounded-full flex items-center justify-center mb-2">
                                        <span class="text-white font-bold text-lg">9M</span>
                                    </div>
                                    <?php break; ?>
                            <?php endswitch; ?>
                            <span class="text-white font-medium"><?php echo e($network); ?></span>
                        </div>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Phone Number -->
        <div class="space-y-2">
            <label for="phone" class="text-white font-medium">Phone Number</label>
            <input type="tel" 
                   id="phone" 
                   name="phone" 
                   value="<?php echo e(old('phone', request('phone'))); ?>"
                   placeholder="08012345678" 
                   class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                   maxlength="11" 
                   pattern="[0-9]{11}"
                   required>
            <p class="text-xs text-gray-400">Enter 11-digit phone number</p>
        </div>

        <!-- Amount Selection -->
        <div class="space-y-3">
            <label class="text-white font-medium">Select Amount</label>
            <div class="grid grid-cols-3 gap-3">
                <?php $__currentLoopData = [50, 100, 200, 500, 1000, 2000]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="radio" id="amount_<?php echo e($amount); ?>" name="amount" value="<?php echo e($amount); ?>" class="hidden amount-radio"
                           <?php echo e(old('amount', request('amount')) == $amount ? 'checked' : ''); ?>>
                    <label for="amount_<?php echo e($amount); ?>" class="amount-option card-gradient border border-gray-600 rounded-xl p-3 text-center cursor-pointer transition-all duration-200 hover:border-primary-500">
                        <span class="text-white font-medium">₦<?php echo e(number_format($amount)); ?></span>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Custom Amount -->
        <div class="space-y-2">
            <label for="custom_amount" class="text-white font-medium">Or Enter Custom Amount</label>
            <div class="relative">
                <span class="absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400">₦</span>
                <input type="number" 
                       id="custom_amount" 
                       name="custom_amount" 
                       value="<?php echo e(old('custom_amount')); ?>"
                       placeholder="0" 
                       min="50" 
                       max="10000"
                       class="w-full pl-8 pr-4 py-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none">
            </div>
            <p class="text-xs text-gray-400">Min: ₦50, Max: ₦10,000</p>
        </div>

        <!-- Transaction PIN -->
        <div class="space-y-2">
            <label for="transaction_pin" class="text-white font-medium">Transaction PIN</label>
            <input type="password" 
                   id="transaction_pin" 
                   name="transaction_pin" 
                   placeholder="Enter 4-digit PIN" 
                   maxlength="4"
                   pattern="[0-9]{4}"
                   class="w-full p-4 bg-dark-800 border border-gray-600 rounded-xl text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none"
                   required>
        </div>

        <!-- Summary -->
        <div class="card-gradient rounded-xl p-4 space-y-2" id="transaction-summary" style="display: none;">
            <h3 class="text-white font-medium mb-3">Transaction Summary</h3>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Network:</span>
                <span class="text-white" id="summary-network">-</span>
            </div>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Phone:</span>
                <span class="text-white" id="summary-phone">-</span>
            </div>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Amount:</span>
                <span class="text-white" id="summary-amount">₦0</span>
            </div>
            <div class="flex justify-between text-sm">
                <span class="text-gray-400">Fee:</span>
                <span class="text-white" id="summary-fee">₦0</span>
            </div>
            <hr class="border-gray-600 my-2">
            <div class="flex justify-between font-medium">
                <span class="text-white">Total:</span>
                <span class="text-primary-400" id="summary-total">₦0</span>
            </div>
        </div>

        <!-- Submit Button -->
        <button type="submit" 
                class="w-full bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-semibold py-4 rounded-xl transition-all duration-200 disabled:opacity-50"
                id="submit-btn" 
                disabled>
            <i class="fas fa-mobile-alt mr-2"></i>
            Buy Airtime
        </button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const networkRadios = document.querySelectorAll('.network-radio');
    const amountRadios = document.querySelectorAll('.amount-radio');
    const phoneInput = document.getElementById('phone');
    const customAmountInput = document.getElementById('custom_amount');
    const submitBtn = document.getElementById('submit-btn');
    const summary = document.getElementById('transaction-summary');
    
    function updateSummary() {
        const selectedNetwork = document.querySelector('.network-radio:checked')?.value;
        const selectedAmount = document.querySelector('.amount-radio:checked')?.value || customAmountInput.value;
        const phone = phoneInput.value;
        
        if (selectedNetwork && selectedAmount && phone) {
            const amount = parseFloat(selectedAmount);
            const fee = Math.min(amount * 0.005, 20); // 0.5% capped at ₦20
            const total = amount + fee;
            
            document.getElementById('summary-network').textContent = selectedNetwork;
            document.getElementById('summary-phone').textContent = phone;
            document.getElementById('summary-amount').textContent = '₦' + amount.toLocaleString();
            document.getElementById('summary-fee').textContent = '₦' + fee.toLocaleString();
            document.getElementById('summary-total').textContent = '₦' + total.toLocaleString();
            
            summary.style.display = 'block';
            submitBtn.disabled = false;
        } else {
            summary.style.display = 'none';
            submitBtn.disabled = true;
        }
    }
    
    // Style selection handlers
    networkRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.network-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
            }
            updateSummary();
        });
    });
    
    amountRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.amount-option').forEach(option => {
                option.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
            if (this.checked) {
                this.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
                customAmountInput.value = '';
            }
            updateSummary();
        });
    });
    
    customAmountInput.addEventListener('input', function() {
        if (this.value) {
            amountRadios.forEach(radio => {
                radio.checked = false;
                radio.nextElementSibling.classList.remove('border-primary-500', 'bg-primary-500/20');
            });
        }
        updateSummary();
    });
    
    phoneInput.addEventListener('input', updateSummary);
    
    // Initialize selected styles
    document.querySelectorAll('.network-radio:checked').forEach(radio => {
        radio.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
    });
    
    document.querySelectorAll('.amount-radio:checked').forEach(radio => {
        radio.nextElementSibling.classList.add('border-primary-500', 'bg-primary-500/20');
    });
    
    updateSummary();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.mobile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/bills/airtime.blade.php ENDPATH**/ ?>