<?php $__env->startSection('title', 'Security Logs'); ?>
<?php $__env->startSection('page-title', 'Security & Audit Logs'); ?>
<?php $__env->startSection('page-description', 'Monitor admin activities and security events'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Security & Audit Logs</h2>
            <p class="text-gray-600 mt-1">Monitor admin activities, user actions, and security events</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="showExportModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Export Logs
            </button>
            <?php if(auth('admin')->user()->is_super_admin): ?>
            <button class="btn-danger" onclick="showClearLogsModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
                Clear Old Logs
            </button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Statistics Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Total Logs -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Logs</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['total_logs'])); ?></p>
                    <p class="text-sm text-blue-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                            All time records
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Today's Actions -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Today's Actions</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['today_actions'])); ?></p>
                    <p class="text-sm text-emerald-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Last 24 hours
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Unique Admins -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Active Admins</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['unique_admins'])); ?></p>
                    <p class="text-sm text-purple-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                            With activities
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Login Attempts -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Login Attempts</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['login_attempts'])); ?></p>
                    <p class="text-sm text-orange-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                            </svg>
                            All attempts
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-orange-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Filter Security Logs</h3>
        <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                       placeholder="Search actions, IPs..."
                       class="input-primary">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Action</label>
                <select name="action" class="input-primary">
                    <option value="">All Actions</option>
                    <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($action); ?>" <?php echo e(request('action') === $action ? 'selected' : ''); ?>>
                        <?php echo e(ucwords(str_replace('_', ' ', $action))); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Admin</label>
                <select name="admin_id" class="input-primary">
                    <option value="">All Admins</option>
                    <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($admin->id); ?>" <?php echo e(request('admin_id') == $admin->id ? 'selected' : ''); ?>>
                        <?php echo e($admin->name); ?> (<?php echo e(ucfirst($admin->role)); ?>)
                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Date From</label>
                <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" class="input-primary">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Date To</label>
                <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" class="input-primary">
            </div>
            <div class="flex items-end">
                <button type="submit" class="btn-primary w-full">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    Filter
                </button>
            </div>
        </form>
    </div>

    <!-- Security Logs Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">Security & Audit Logs</h3>
            <p class="text-sm text-gray-600 mt-1">Track all admin activities and security events</p>
        </div>

        <?php if($logs->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Admin & Action
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Target & Details
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            IP Address & Location
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Timestamp
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-10 w-10">
                                    <div class="h-10 w-10 rounded-full bg-gray-300 flex items-center justify-center">
                                        <span class="text-sm font-medium text-gray-700">
                                            <?php echo e($log->admin ? strtoupper(substr($log->admin->name, 0, 2)) : 'SY'); ?>

                                        </span>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">
                                        <?php echo e($log->admin ? $log->admin->name : 'System'); ?>

                                    </div>
                                    <div class="text-sm text-gray-500">
                                        <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                                            <?php echo e(getActionColor($log->action)); ?>">
                                            <?php echo e(ucwords(str_replace('_', ' ', $log->action))); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                <?php if($log->target_type && $log->target_id): ?>
                                    <?php echo e($log->target_type); ?> #<?php echo e($log->target_id); ?>

                                <?php else: ?>
                                    General Action
                                <?php endif; ?>
                            </div>
                            <div class="text-sm text-gray-500">
                                <?php if($log->data): ?>
                                    <?php $data = json_decode($log->data, true); ?>
                                    <?php if(is_array($data) && count($data) > 0): ?>
                                        <?php echo e(collect($data)->take(2)->map(function($value, $key) {
                                            return ucfirst($key) . ': ' . (is_string($value) ? Str::limit($value, 20) : $value);
                                        })->implode(', ')); ?>

                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($log->ip_address); ?></div>
                            <div class="text-sm text-gray-500">
                                <!-- In a real implementation, you would have location data -->
                                <?php echo e(getLocationFromIP($log->ip_address)); ?>

                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div><?php echo e($log->created_at->format('M j, Y')); ?></div>
                            <div><?php echo e($log->created_at->format('g:i A')); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <button class="text-blue-600 hover:text-blue-900 mr-3"
                                    onclick="viewLogDetails(<?php echo e($log->id); ?>)">
                                <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                Details
                            </button>
                            <?php if($log->ip_address !== '127.0.0.1'): ?>
                            <button class="text-orange-600 hover:text-orange-900"
                                    onclick="blockIP('<?php echo e($log->ip_address); ?>')">
                                <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636m12.728 12.728L18.364 5.636M5.636 18.364l12.728-12.728"></path>
                                </svg>
                                Block IP
                            </button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 border-t border-gray-200">
            <?php echo e($logs->links()); ?>

        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No logs found</h3>
            <p class="mt-1 text-sm text-gray-500">No security logs match your current filters.</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Recent Activity Summary -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Activity Summary</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Most Active Actions -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Most Common Actions (Last 30 Days)</h4>
                <div class="space-y-2">
                    <?php if($activityAnalytics['commonActions']->count() > 0): ?>
                        <?php $maxCount = $activityAnalytics['commonActions']->max(); ?>
                        <?php $__currentLoopData = $activityAnalytics['commonActions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600"><?php echo e(ucwords(str_replace('_', ' ', $action))); ?></span>
                            <div class="flex items-center">
                                <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                                    <div class="h-2 bg-gradient-to-r from-blue-500 to-blue-600 rounded-full" 
                                         style="width: <?php echo e($maxCount > 0 ? ($count / $maxCount) * 100 : 0); ?>%"></div>
                                </div>
                                <span class="text-sm font-medium text-gray-900"><?php echo e($count); ?></span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="text-sm text-gray-500">No recent activity data available</div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Time Distribution -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Activity by Time (Last 7 Days)</h4>
                <div class="space-y-2">
                    <?php $__currentLoopData = $activityAnalytics['timeDistribution']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time => $percentage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-600"><?php echo e($time); ?></span>
                        <div class="flex items-center">
                            <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                                <div class="h-2 bg-gradient-to-r from-green-500 to-emerald-600 rounded-full" 
                                     style="width: <?php echo e($percentage); ?>%"></div>
                            </div>
                            <span class="text-sm font-medium text-gray-900"><?php echo e($percentage); ?>%</span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Security Alerts -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Security Alerts</h4>
                <div class="space-y-3">
                    <?php $__currentLoopData = $securityAlerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="p-3 <?php if($alert['type'] === 'success'): ?> bg-green-50 <?php elseif($alert['type'] === 'warning'): ?> bg-yellow-50 <?php elseif($alert['type'] === 'info'): ?> bg-blue-50 <?php else: ?> bg-red-50 <?php endif; ?> rounded-lg">
                        <div class="flex items-start">
                            <?php if($alert['icon'] === 'check-circle'): ?>
                            <svg class="w-4 h-4 <?php if($alert['type'] === 'success'): ?> text-green-600 <?php elseif($alert['type'] === 'warning'): ?> text-yellow-600 <?php elseif($alert['type'] === 'info'): ?> text-blue-600 <?php else: ?> text-red-600 <?php endif; ?> mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <?php elseif($alert['icon'] === 'exclamation-triangle'): ?>
                            <svg class="w-4 h-4 <?php if($alert['type'] === 'success'): ?> text-green-600 <?php elseif($alert['type'] === 'warning'): ?> text-yellow-600 <?php elseif($alert['type'] === 'info'): ?> text-blue-600 <?php else: ?> text-red-600 <?php endif; ?> mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.996-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                            </svg>
                            <?php elseif($alert['icon'] === 'shield-check'): ?>
                            <svg class="w-4 h-4 <?php if($alert['type'] === 'success'): ?> text-green-600 <?php elseif($alert['type'] === 'warning'): ?> text-yellow-600 <?php elseif($alert['type'] === 'info'): ?> text-blue-600 <?php else: ?> text-red-600 <?php endif; ?> mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                            </svg>
                            <?php else: ?>
                            <svg class="w-4 h-4 <?php if($alert['type'] === 'success'): ?> text-green-600 <?php elseif($alert['type'] === 'warning'): ?> text-yellow-600 <?php elseif($alert['type'] === 'info'): ?> text-blue-600 <?php else: ?> text-red-600 <?php endif; ?> mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 7v10c0 2.21 3.582 4 8 4s8-1.79 8-4V7M4 7c0 2.21 3.582 4 8 4s8-1.79 8-4M4 7c0-2.21 3.582-4 8-4s8 1.79 8 4"></path>
                            </svg>
                            <?php endif; ?>
                            <div>
                                <p class="text-xs font-medium <?php if($alert['type'] === 'success'): ?> text-green-800 <?php elseif($alert['type'] === 'warning'): ?> text-yellow-800 <?php elseif($alert['type'] === 'info'): ?> text-blue-800 <?php else: ?> text-red-800 <?php endif; ?>"><?php echo e($alert['title']); ?></p>
                                <p class="text-xs <?php if($alert['type'] === 'success'): ?> text-green-700 <?php elseif($alert['type'] === 'warning'): ?> text-yellow-700 <?php elseif($alert['type'] === 'info'): ?> text-blue-700 <?php else: ?> text-red-700 <?php endif; ?>"><?php echo e($alert['message']); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Export Logs Modal -->
<div id="exportModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 text-center">Export Security Logs</h3>
            <form id="exportForm" method="POST" action="<?php echo e(route('admin.settings.security-logs.export')); ?>">
                <?php echo csrf_field(); ?>
                <div class="mt-4 space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Export Format</label>
                        <select name="format" class="input-primary" required>
                            <option value="csv">CSV (Comma Separated)</option>
                            <option value="excel">Excel (XLSX)</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Date From</label>
                        <input type="date" name="date_from" class="input-primary">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Date To</label>
                        <input type="date" name="date_to" class="input-primary">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Action</label>
                        <select name="action" class="input-primary">
                            <option value="">All Actions</option>
                            <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($action); ?>"><?php echo e(ucwords(str_replace('_', ' ', $action))); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Admin</label>
                        <select name="admin_id" class="input-primary">
                            <option value="">All Admins</option>
                            <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($admin->id); ?>"><?php echo e($admin->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" onclick="closeExportModal()" class="btn-secondary">Cancel</button>
                    <button type="submit" class="btn-primary">Export</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Clear Logs Modal -->
<?php if(auth('admin')->user()->isSuperAdmin()): ?>
<div id="clearLogsModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 text-center">Clear Old Logs</h3>
            <div class="mt-4">
                <div class="bg-yellow-50 border border-yellow-200 rounded-md p-4 mb-4">
                    <div class="flex">
                        <svg class="w-5 h-5 text-yellow-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.996-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                        </svg>
                        <div>
                            <h4 class="text-sm font-medium text-yellow-800">Warning</h4>
                            <p class="text-sm text-yellow-700">This action will permanently delete logs and cannot be undone.</p>
                        </div>
                    </div>
                </div>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Delete logs before:</label>
                        <input type="date" id="clearDate" class="input-primary" required max="<?php echo e(date('Y-m-d', strtotime('-1 day'))); ?>">
                        <p class="text-xs text-gray-500 mt-1">Logs created before this date will be deleted</p>
                    </div>
                    <div class="flex items-center">
                        <input type="checkbox" id="confirmClear" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="confirmClear" class="ml-2 block text-sm text-gray-900">
                            I understand this action cannot be undone
                        </label>
                    </div>
                </div>
                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button" onclick="closeClearLogsModal()" class="btn-secondary">Cancel</button>
                    <button type="button" onclick="clearOldLogs()" class="btn-danger">Clear Logs</button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Log Details Modal -->
<div id="logDetailsModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-10 mx-auto p-5 border w-4/5 max-w-4xl shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-medium text-gray-900">Log Details</h3>
                <button onclick="closeLogDetailsModal()" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
            <div id="logDetailsContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<script>
function showExportModal() {
    document.getElementById('exportModal').classList.remove('hidden');
}

function closeExportModal() {
    document.getElementById('exportModal').classList.add('hidden');
}

function showClearLogsModal() {
    const modal = document.getElementById('clearLogsModal');
    if (modal) {
        modal.classList.remove('hidden');
    }
}

function closeClearLogsModal() {
    const modal = document.getElementById('clearLogsModal');
    if (modal) {
        modal.classList.add('hidden');
        document.getElementById('confirmClear').checked = false;
        document.getElementById('clearDate').value = '';
    }
}

function clearOldLogs() {
    const dateBefore = document.getElementById('clearDate').value;
    const confirmed = document.getElementById('confirmClear').checked;
    
    if (!dateBefore) {
        alert('Please select a date.');
        return;
    }
    
    if (!confirmed) {
        alert('Please confirm that you understand this action cannot be undone.');
        return;
    }
    
    if (!confirm(`Are you sure you want to delete all logs before ${dateBefore}? This action cannot be undone.`)) {
        return;
    }
    
    fetch('<?php echo e(route("admin.settings.security-logs.clear")); ?>', {
        method: 'DELETE',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            date_before: dateBefore,
            confirm: true
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            closeClearLogsModal();
            removeClearedLogsFromDOM(dateBefore);
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while clearing logs.');
    });
}

function viewLogDetails(logId) {
    fetch(`<?php echo e(route('admin.settings.security-logs.details', '')); ?>/${logId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const log = data.log;
                const content = `
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="text-md font-semibold text-gray-900 mb-3">Basic Information</h4>
                            <div class="space-y-2 text-sm">
                                <div><strong>ID:</strong> ${log.id}</div>
                                <div><strong>Action:</strong> ${log.action}</div>
                                <div><strong>Date:</strong> ${log.formatted_date}</div>
                                <div><strong>IP Address:</strong> ${log.ip_address}</div>
                                ${log.target_type ? `<div><strong>Target:</strong> ${log.target_type} #${log.target_id || 'N/A'}</div>` : ''}
                            </div>
                        </div>
                        
                        <div>
                            <h4 class="text-md font-semibold text-gray-900 mb-3">User Information</h4>
                            <div class="space-y-2 text-sm">
                                ${log.admin ? `
                                    <div><strong>Admin:</strong> ${log.admin.name}</div>
                                    <div><strong>Email:</strong> ${log.admin.email}</div>
                                    <div><strong>Role:</strong> ${log.admin.role}</div>
                                ` : '<div><strong>Admin:</strong> System</div>'}
                                ${log.user ? `
                                    <div><strong>User:</strong> ${log.user.name}</div>
                                    <div><strong>User Email:</strong> ${log.user.email}</div>
                                ` : ''}
                            </div>
                        </div>
                    </div>
                    
                    ${log.user_agent ? `
                        <div class="mt-6">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">User Agent</h4>
                            <div class="bg-gray-50 p-3 rounded-md text-sm font-mono">
                                ${log.user_agent}
                            </div>
                        </div>
                    ` : ''}
                    
                    ${log.old_values ? `
                        <div class="mt-6">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">Old Values</h4>
                            <div class="bg-red-50 p-3 rounded-md text-sm">
                                <pre class="whitespace-pre-wrap">${JSON.stringify(log.old_values, null, 2)}</pre>
                            </div>
                        </div>
                    ` : ''}
                    
                    ${log.new_values ? `
                        <div class="mt-6">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">New Values</h4>
                            <div class="bg-green-50 p-3 rounded-md text-sm">
                                <pre class="whitespace-pre-wrap">${JSON.stringify(log.new_values, null, 2)}</pre>
                            </div>
                        </div>
                    ` : ''}
                    
                    ${log.metadata ? `
                        <div class="mt-6">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">Metadata</h4>
                            <div class="bg-blue-50 p-3 rounded-md text-sm">
                                <pre class="whitespace-pre-wrap">${JSON.stringify(log.metadata, null, 2)}</pre>
                            </div>
                        </div>
                    ` : ''}
                    
                    ${log.data ? `
                        <div class="mt-6">
                            <h4 class="text-md font-semibold text-gray-900 mb-3">Additional Data</h4>
                            <div class="bg-gray-50 p-3 rounded-md text-sm">
                                <pre class="whitespace-pre-wrap">${JSON.stringify(log.data, null, 2)}</pre>
                            </div>
                        </div>
                    ` : ''}
                `;
                
                document.getElementById('logDetailsContent').innerHTML = content;
                document.getElementById('logDetailsModal').classList.remove('hidden');
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while loading log details.');
        });
}

function closeLogDetailsModal() {
    document.getElementById('logDetailsModal').classList.add('hidden');
}

function blockIP(ipAddress) {
    if(confirm(`Are you sure you want to block IP address: ${ipAddress}?\n\nThis will prevent future access from this IP address.`)) {
        fetch('<?php echo e(route("admin.settings.security-logs.block-ip")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                ip_address: ipAddress
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while blocking the IP address.');
        });
    }
}

// Close modals when clicking outside
window.onclick = function(event) {
    const exportModal = document.getElementById('exportModal');
    const clearModal = document.getElementById('clearLogsModal');
    const detailsModal = document.getElementById('logDetailsModal');
    
    if (event.target === exportModal) {
        closeExportModal();
    }
    if (event.target === clearModal) {
        closeClearLogsModal();
    }
    if (event.target === detailsModal) {
        closeLogDetailsModal();
    }
}

// Auto-submit form when filters change for real-time filtering
document.addEventListener('DOMContentLoaded', function() {
    const filterForm = document.querySelector('form[method="GET"]');
    const filterInputs = filterForm.querySelectorAll('input, select');
    
    filterInputs.forEach(input => {
        if (input.type !== 'submit') {
            input.addEventListener('change', function() {
                filterForm.submit();
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/settings/security-logs.blade.php ENDPATH**/ ?>