<?php $__env->startSection('title', 'Admin Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>
<?php $__env->startSection('page-description', 'Overview of your fintech platform'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Statistics Overview Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Total Users Card -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Users</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['total_users'])); ?></p>
                    <p class="text-sm text-emerald-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                            <?php echo e(number_format($stats['active_users'])); ?> active
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Pending KYC Card -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Pending KYC</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['pending_kyc'])); ?></p>
                    <p class="text-sm text-amber-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <?php echo e(number_format($stats['approved_kyc'])); ?> approved
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Transactions Card -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Transactions</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['total_transactions'])); ?></p>
                    <p class="text-sm text-emerald-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                            ₦<?php echo e(number_format($stats['total_transaction_volume'] / 1000000, 1)); ?>M volume
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Virtual Cards Card -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Active Cards</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['active_cards'])); ?></p>
                    <p class="text-sm text-purple-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            <?php echo e(number_format($stats['total_wallets'])); ?> wallets
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- System Health Alerts -->
    <?php if($stats['pending_kyc'] > 0 || $stats['blocked_users'] > 0 || $stats['frozen_wallets'] > 0): ?>
    <div class="bg-gradient-to-r from-amber-50 to-orange-50 border border-amber-200 rounded-xl p-6">
        <div class="flex items-center mb-4">
            <div class="w-8 h-8 bg-amber-500 rounded-lg flex items-center justify-center mr-3">
                <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.662-.833-2.464 0L3.34 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
            </div>
            <h3 class="text-lg font-semibold text-amber-800">System Alerts</h3>
        </div>
        <div class="grid md:grid-cols-3 gap-4">
            <?php if($stats['pending_kyc'] > 0): ?>
            <div class="flex items-center p-3 bg-white rounded-lg border border-amber-200">
                <svg class="w-5 h-5 text-amber-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <div>
                    <p class="text-sm font-medium text-amber-800"><?php echo e($stats['pending_kyc']); ?> Pending KYC</p>
                    <p class="text-xs text-amber-600">Require approval</p>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if($stats['blocked_users'] > 0): ?>
            <div class="flex items-center p-3 bg-white rounded-lg border border-amber-200">
                <svg class="w-5 h-5 text-amber-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636m12.728 12.728L18.364 5.636M5.636 18.364l12.728-12.728"></path>
                </svg>
                <div>
                    <p class="text-sm font-medium text-amber-800"><?php echo e($stats['blocked_users']); ?> Blocked Users</p>
                    <p class="text-xs text-amber-600">Need review</p>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if($stats['frozen_wallets'] > 0): ?>
            <div class="flex items-center p-3 bg-white rounded-lg border border-amber-200">
                <svg class="w-5 h-5 text-amber-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                </svg>
                <div>
                    <p class="text-sm font-medium text-amber-800"><?php echo e($stats['frozen_wallets']); ?> Frozen Wallets</p>
                    <p class="text-xs text-amber-600">Temporary freeze</p>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Quick Actions Grid -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-6">Quick Actions</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <a href="<?php echo e(route('admin.kyc.index', ['status' => 'pending'])); ?>" 
               class="group flex items-center p-4 bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg border border-blue-200 hover:from-blue-100 hover:to-blue-200 transition-all duration-200 transform hover:scale-105">
                <div class="w-10 h-10 bg-blue-500 rounded-lg flex items-center justify-center mr-4 group-hover:bg-blue-600 transition-colors">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div>
                    <p class="font-medium text-blue-900">Review KYC</p>
                    <p class="text-sm text-blue-700">Pending verifications</p>
                </div>
            </a>
            
            <a href="<?php echo e(route('admin.users.index')); ?>" 
               class="group flex items-center p-4 bg-gradient-to-br from-emerald-50 to-emerald-100 rounded-lg border border-emerald-200 hover:from-emerald-100 hover:to-emerald-200 transition-all duration-200 transform hover:scale-105">
                <div class="w-10 h-10 bg-emerald-500 rounded-lg flex items-center justify-center mr-4 group-hover:bg-emerald-600 transition-colors">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
                <div>
                    <p class="font-medium text-emerald-900">Manage Users</p>
                    <p class="text-sm text-emerald-700">User administration</p>
                </div>
            </a>
            
            <a href="#" 
               class="group flex items-center p-4 bg-gradient-to-br from-purple-50 to-purple-100 rounded-lg border border-purple-200 hover:from-purple-100 hover:to-purple-200 transition-all duration-200 transform hover:scale-105">
                <div class="w-10 h-10 bg-purple-500 rounded-lg flex items-center justify-center mr-4 group-hover:bg-purple-600 transition-colors">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <div>
                    <p class="font-medium text-purple-900">View Reports</p>
                    <p class="text-sm text-purple-700">Analytics & insights</p>
                </div>
            </a>
            
            <a href="#" 
               class="group flex items-center p-4 bg-gradient-to-br from-amber-50 to-amber-100 rounded-lg border border-amber-200 hover:from-amber-100 hover:to-amber-200 transition-all duration-200 transform hover:scale-105">
                <div class="w-10 h-10 bg-amber-500 rounded-lg flex items-center justify-center mr-4 group-hover:bg-amber-600 transition-colors">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                </div>
                <div>
                    <p class="font-medium text-amber-900">Settings</p>
                    <p class="text-sm text-amber-700">System configuration</p>
                </div>
            </a>
        </div>
    </div>

    <!-- Recent Activity Grid -->
    <div class="grid lg:grid-cols-2 gap-6">
        <!-- Recent Users -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-semibold text-gray-900">Recent Users</h3>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="text-sm text-blue-600 hover:text-blue-800 font-medium">View all</a>
            </div>
            <?php if($recentUsers->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $recentUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition-colors">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-gradient-to-br from-gray-400 to-gray-500 rounded-full flex items-center justify-center mr-3">
                                <span class="text-sm font-medium text-white">
                                    <?php echo e(strtoupper(substr($user->first_name, 0, 1) . substr($user->last_name, 0, 1))); ?>

                                </span>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e($user->full_name); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($user->email); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e($user->created_at->diffForHumans()); ?></p>
                            </div>
                        </div>
                        <a href="<?php echo e(route('admin.users.show', $user)); ?>" 
                           class="text-blue-600 hover:text-blue-800 text-sm font-medium">View</a>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <svg class="w-12 h-12 text-gray-400 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                    <p class="text-gray-500">No recent users</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Recent Transactions -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-semibold text-gray-900">Recent Transactions</h3>
                <a href="#" class="text-sm text-blue-600 hover:text-blue-800 font-medium">View all</a>
            </div>
            <?php if($recentTransactions->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition-colors">
                        <div class="flex items-center">
                            <div class="w-10 h-10 <?php echo e($transaction->type === 'credit' ? 'bg-emerald-100' : 'bg-red-100'); ?> rounded-full flex items-center justify-center mr-3">
                                <svg class="w-5 h-5 <?php echo e($transaction->type === 'credit' ? 'text-emerald-600' : 'text-red-600'); ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                          d="<?php echo e($transaction->type === 'credit' ? 'M13 7h8m0 0v8m0-8l-8 8-4-4-6 6' : 'M19 14l-7-7m0 0l-7 7m7-7v18'); ?>"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e(ucfirst(str_replace('_', ' ', $transaction->category))); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($transaction->user->full_name ?? 'Unknown User'); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e($transaction->created_at->format('M d, H:i')); ?></p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-medium <?php echo e($transaction->type === 'credit' ? 'text-emerald-600' : 'text-red-600'); ?>">
                                <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?>₦<?php echo e(number_format($transaction->amount, 2)); ?>

                            </p>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium 
                                         <?php echo e($transaction->status === 'completed' ? 'bg-emerald-100 text-emerald-800' : 
                                            ($transaction->status === 'pending' ? 'bg-amber-100 text-amber-800' : 'bg-red-100 text-red-800')); ?>">
                                <?php echo e(ucfirst($transaction->status)); ?>

                            </span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <svg class="w-12 h-12 text-gray-400 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                    <p class="text-gray-500">No recent transactions</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Pending KYC Section -->
    <?php if($pendingKyc->count() > 0): ?>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-semibold text-gray-900">Pending KYC Verifications</h3>
            <a href="<?php echo e(route('admin.kyc.index', ['status' => 'pending'])); ?>" class="text-sm text-blue-600 hover:text-blue-800 font-medium">View all</a>
        </div>
        <div class="space-y-4">
            <?php $__currentLoopData = $pendingKyc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-center justify-between p-4 bg-amber-50 rounded-lg border border-amber-200">
                <div class="flex items-center">
                    <div class="w-10 h-10 bg-gradient-to-br from-amber-400 to-amber-500 rounded-full flex items-center justify-center mr-4">
                        <span class="text-sm font-medium text-white">
                            <?php echo e(strtoupper(substr($kyc->user->first_name, 0, 1) . substr($kyc->user->last_name, 0, 1))); ?>

                        </span>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-900"><?php echo e($kyc->user->full_name); ?></p>
                        <p class="text-xs text-amber-700"><?php echo e(strtoupper($kyc->type)); ?> Verification</p>
                        <p class="text-xs text-gray-500"><?php echo e($kyc->created_at->diffForHumans()); ?></p>
                    </div>
                </div>
                <a href="<?php echo e(route('admin.kyc.show', $kyc)); ?>" 
                   class="inline-flex items-center px-3 py-2 bg-amber-600 text-white text-sm font-medium rounded-lg hover:bg-amber-700 transition-colors">
                    Review
                </a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>