<?php $__env->startSection('title', 'Pending Withdrawals'); ?>
<?php $__env->startSection('page-title', 'Pending Withdrawals'); ?>
<?php $__env->startSection('page-description', 'Review and process pending withdrawal requests'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Back to Wallets -->
    <div class="flex items-center">
        <a href="<?php echo e(route('admin.wallets.index')); ?>" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Wallet Management
        </a>
    </div>

    <!-- Withdrawal Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Pending Withdrawals -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Pending Requests</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['pending_count'])); ?></p>
                    <p class="text-sm text-amber-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <?php echo e(number_format($stats['urgent_count'])); ?> urgent (>24h)
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-amber-500 to-amber-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Pending Amount -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Pending Amount</p>
                    <p class="text-3xl font-bold text-gray-900">₦<?php echo e(number_format($stats['pending_amount'], 2)); ?></p>
                    <p class="text-sm text-blue-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                            Awaiting approval
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Approved Today -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Approved Today</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['approved_today'])); ?></p>
                    <p class="text-sm text-emerald-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            ₦<?php echo e(number_format($stats['approved_amount_today'], 2)); ?>

                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Declined Today -->
        <div class="stat-card rounded-xl p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Declined Today</p>
                    <p class="text-3xl font-bold text-gray-900"><?php echo e(number_format($stats['declined_today'])); ?></p>
                    <p class="text-sm text-red-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            ₦<?php echo e(number_format($stats['declined_amount_today'], 2)); ?>

                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <?php if($withdrawals->where('status', 'pending')->count() > 0): ?>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <input type="checkbox" id="select-all" class="mr-3">
                <label for="select-all" class="text-sm font-medium text-gray-700">Select All</label>
            </div>
            <div class="flex space-x-2">
                <button onclick="bulkApprove()" class="inline-flex items-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-lg hover:bg-green-700 transition-colors" disabled id="bulk-approve-btn">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Bulk Approve
                </button>
                <button onclick="showBulkDeclineModal()" class="inline-flex items-center px-4 py-2 bg-red-600 text-white text-sm font-medium rounded-lg hover:bg-red-700 transition-colors" disabled id="bulk-decline-btn">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Bulk Decline
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <form method="GET" action="<?php echo e(route('admin.wallets.pending-withdrawals')); ?>" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <!-- Search -->
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" id="search" value="<?php echo e(request('search')); ?>" 
                       placeholder="User, reference..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <!-- Amount Range -->
            <div>
                <label for="min_amount" class="block text-sm font-medium text-gray-700 mb-1">Min Amount</label>
                <input type="number" name="min_amount" id="min_amount" value="<?php echo e(request('min_amount')); ?>" 
                       placeholder="0.00" step="0.01"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <div>
                <label for="max_amount" class="block text-sm font-medium text-gray-700 mb-1">Max Amount</label>
                <input type="number" name="max_amount" id="max_amount" value="<?php echo e(request('max_amount')); ?>" 
                       placeholder="0.00" step="0.01"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <!-- Date Filter -->
            <div>
                <label for="date_from" class="block text-sm font-medium text-gray-700 mb-1">Date From</label>
                <input type="date" name="date_from" id="date_from" value="<?php echo e(request('date_from')); ?>" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <!-- Filter Button -->
            <div class="flex items-end">
                <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 transition-colors">
                    Filter
                </button>
            </div>
        </form>
    </div>

    <!-- Withdrawals Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">Pending Withdrawals (<?php echo e($withdrawals->total()); ?>)</h3>
        </div>

        <?php if($withdrawals->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <input type="checkbox" id="select-all-header">
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Bank Details</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Priority</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Requested</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 <?php echo e($withdrawal->created_at->lt(now()->subHours(24)) ? 'bg-red-50' : ''); ?>">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <input type="checkbox" class="withdrawal-checkbox" value="<?php echo e($withdrawal->id); ?>">
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="w-10 h-10 bg-gradient-to-br from-gray-400 to-gray-500 rounded-full flex items-center justify-center mr-3">
                                    <span class="text-sm font-medium text-white">
                                        <?php echo e(strtoupper(substr($withdrawal->user->first_name, 0, 1) . substr($withdrawal->user->last_name, 0, 1))); ?>

                                    </span>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($withdrawal->user->full_name); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($withdrawal->user->email); ?></div>
                                    <div class="text-xs text-gray-400">ID: <?php echo e($withdrawal->user->id); ?></div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-lg font-bold text-gray-900">₦<?php echo e(number_format($withdrawal->amount, 2)); ?></div>
                            <?php if($withdrawal->fee > 0): ?>
                                <div class="text-xs text-gray-500">Fee: ₦<?php echo e(number_format($withdrawal->fee, 2)); ?></div>
                            <?php endif; ?>
                            <div class="text-xs text-gray-400"><?php echo e($withdrawal->reference); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($withdrawal->bank_name); ?></div>
                            <div class="text-xs text-gray-500"><?php echo e($withdrawal->account_number); ?></div>
                            <div class="text-xs text-gray-400"><?php echo e($withdrawal->account_name); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if($withdrawal->created_at->lt(now()->subHours(48))): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                    Critical
                                </span>
                            <?php elseif($withdrawal->created_at->lt(now()->subHours(24))): ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-amber-100 text-amber-800">
                                    Urgent
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    Normal
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900"><?php echo e($withdrawal->created_at->format('M d, Y')); ?></div>
                            <div class="text-xs text-gray-500"><?php echo e($withdrawal->created_at->format('H:i:s')); ?></div>
                            <div class="text-xs text-gray-400"><?php echo e($withdrawal->created_at->diffForHumans()); ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                            <button onclick="viewWithdrawal(<?php echo e($withdrawal->id); ?>)" class="text-blue-600 hover:text-blue-900">View</button>
                            <button onclick="approveWithdrawal(<?php echo e($withdrawal->id); ?>)" class="text-green-600 hover:text-green-900">Approve</button>
                            <button onclick="showDeclineModal(<?php echo e($withdrawal->id); ?>)" class="text-red-600 hover:text-red-900">Decline</button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 bg-gray-50 border-t">
            <?php echo e($withdrawals->links()); ?>

        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No pending withdrawals</h3>
            <p class="mt-1 text-sm text-gray-500">All withdrawal requests have been processed.</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Withdrawal Details Modal -->
<div id="withdrawalModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Withdrawal Details</h3>
            <div id="withdrawalDetails">
                <!-- Withdrawal details will be loaded here -->
            </div>
            <div class="flex justify-end space-x-2 mt-4">
                <button onclick="hideWithdrawalModal()" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Decline Modal -->
<div id="declineModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Decline Withdrawal</h3>
            <form id="decline-form" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="withdrawal_id" id="decline-withdrawal-id">
                <div class="mb-4">
                    <label for="decline_reason" class="block text-sm font-medium text-gray-700 mb-1">Reason for Decline</label>
                    <textarea name="reason" id="decline_reason" required rows="3" 
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                              placeholder="Provide reason for declining this withdrawal..."></textarea>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideDeclineModal()" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">Decline</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Bulk Decline Modal -->
<div id="bulkDeclineModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Bulk Decline Withdrawals</h3>
            <form id="bulk-decline-form" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="withdrawal_ids" id="bulk-decline-ids">
                <div class="mb-4">
                    <label for="bulk_decline_reason" class="block text-sm font-medium text-gray-700 mb-1">Reason for Decline</label>
                    <textarea name="reason" id="bulk_decline_reason" required rows="3" 
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                              placeholder="Provide reason for declining selected withdrawals..."></textarea>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideBulkDeclineModal()" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">Decline Selected</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Bulk selection functionality
document.addEventListener('DOMContentLoaded', function() {
    const selectAllCheckboxes = document.querySelectorAll('#select-all, #select-all-header');
    const withdrawalCheckboxes = document.querySelectorAll('.withdrawal-checkbox');
    const bulkApproveBtn = document.getElementById('bulk-approve-btn');
    const bulkDeclineBtn = document.getElementById('bulk-decline-btn');

    // Handle select all
    selectAllCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            withdrawalCheckboxes.forEach(cb => {
                cb.checked = this.checked;
            });
            updateBulkButtons();
            selectAllCheckboxes.forEach(cb => cb.checked = this.checked);
        });
    });

    // Handle individual checkboxes
    withdrawalCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateBulkButtons);
    });

    function updateBulkButtons() {
        const checkedBoxes = document.querySelectorAll('.withdrawal-checkbox:checked');
        const hasSelected = checkedBoxes.length > 0;
        
        if (bulkApproveBtn) bulkApproveBtn.disabled = !hasSelected;
        if (bulkDeclineBtn) bulkDeclineBtn.disabled = !hasSelected;
    }
});

function viewWithdrawal(withdrawalId) {
    document.getElementById('withdrawalModal').classList.remove('hidden');
    document.getElementById('withdrawalDetails').innerHTML = `
        <div class="animate-pulse">
            <div class="h-4 bg-gray-200 rounded w-3/4 mb-2"></div>
            <div class="h-4 bg-gray-200 rounded w-1/2 mb-2"></div>
            <div class="h-4 bg-gray-200 rounded w-5/6"></div>
        </div>
    `;
    
    // Simulate loading withdrawal details
    setTimeout(() => {
        document.getElementById('withdrawalDetails').innerHTML = `
            <div class="space-y-3">
                <div><strong>Withdrawal ID:</strong> ${withdrawalId}</div>
                <div><strong>User:</strong> John Doe</div>
                <div><strong>Amount:</strong> ₦50,000.00</div>
                <div><strong>Bank:</strong> First Bank Nigeria</div>
                <div><strong>Account:</strong> 1234567890</div>
                <div><strong>Account Name:</strong> John Doe</div>
                <div><strong>Wallet Balance:</strong> ₦75,000.00</div>
                <div><strong>Requested:</strong> 2 hours ago</div>
            </div>
        `;
    }, 1000);
}

function hideWithdrawalModal() {
    document.getElementById('withdrawalModal').classList.add('hidden');
}

function approveWithdrawal(withdrawalId) {
    if (confirm('Are you sure you want to approve this withdrawal?')) {
        // This would make an AJAX call to approve the withdrawal
        alert('Withdrawal approved successfully!');
        window.location.reload();
    }
}

function showDeclineModal(withdrawalId) {
    document.getElementById('decline-withdrawal-id').value = withdrawalId;
    document.getElementById('declineModal').classList.remove('hidden');
}

function hideDeclineModal() {
    document.getElementById('declineModal').classList.add('hidden');
}

function bulkApprove() {
    const checkedBoxes = document.querySelectorAll('.withdrawal-checkbox:checked');
    if (checkedBoxes.length === 0) return;
    
    if (confirm(`Are you sure you want to approve ${checkedBoxes.length} withdrawal(s)?`)) {
        // This would make an AJAX call to approve withdrawals
        alert(`${checkedBoxes.length} withdrawal(s) approved successfully!`);
        window.location.reload();
    }
}

function showBulkDeclineModal() {
    const checkedBoxes = document.querySelectorAll('.withdrawal-checkbox:checked');
    if (checkedBoxes.length === 0) return;
    
    const ids = Array.from(checkedBoxes).map(cb => cb.value);
    document.getElementById('bulk-decline-ids').value = JSON.stringify(ids);
    document.getElementById('bulkDeclineModal').classList.remove('hidden');
}

function hideBulkDeclineModal() {
    document.getElementById('bulkDeclineModal').classList.add('hidden');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/admin/wallets/pending-withdrawals.blade.php ENDPATH**/ ?>