<?php $__env->startSection('title', 'Card Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-6">
    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <div class="flex items-center">
            <a href="<?php echo e(route('cards.index')); ?>" class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center mr-4 hover:bg-dark-700 transition-colors">
                <i class="fas fa-arrow-left text-gray-300"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold text-white">Card Details</h1>
                <p class="text-sm text-gray-400">Manage your virtual card</p>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <button class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center hover:bg-dark-700 transition-colors" 
                    onclick="toggleCardDetails()" id="toggle-btn">
                <i class="fas fa-eye text-gray-300"></i>
            </button>
            <div class="relative">
                <button class="w-10 h-10 bg-dark-800 rounded-xl flex items-center justify-center hover:bg-dark-700 transition-colors" 
                        onclick="toggleDropdown()">
                    <i class="fas fa-ellipsis-v text-gray-300"></i>
                </button>
                <div id="card-menu" class="absolute right-0 mt-2 w-48 bg-dark-800 rounded-xl shadow-lg border border-gray-600 hidden z-10">
                    <a href="#" onclick="copyCardNumber()" class="flex items-center px-4 py-3 text-gray-300 hover:bg-dark-700 rounded-t-xl">
                        <i class="fas fa-copy w-4 mr-3"></i>
                        Copy Card Number
                    </a>
                    <a href="#" onclick="downloadStatement()" class="flex items-center px-4 py-3 text-gray-300 hover:bg-dark-700">
                        <i class="fas fa-download w-4 mr-3"></i>
                        Download Statement
                    </a>
                    <a href="#" onclick="shareCard()" class="flex items-center px-4 py-3 text-gray-300 hover:bg-dark-700 rounded-b-xl">
                        <i class="fas fa-share w-4 mr-3"></i>
                        Share Card Info
                    </a>
                </div>
            </div>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-500/20 border border-green-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-check-circle text-green-400 mr-2"></i>
                <span class="text-green-400 text-sm"><?php echo e(session('success')); ?></span>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="bg-red-500/20 border border-red-500 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-red-400 mr-2"></i>
                <span class="text-red-400 text-sm"><?php echo e(session('error')); ?></span>
            </div>
        </div>
    <?php endif; ?>

    <!-- Card Display -->
    <div class="relative mb-8">
        <div class="card-preview bg-gradient-to-br from-primary-600 via-primary-700 to-primary-800 rounded-2xl p-6 text-white shadow-2xl relative overflow-hidden">
            <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent"></div>
            <div class="relative z-10">
                <div class="flex justify-between items-start mb-8">
                    <div>
                        <h3 class="text-lg font-semibold"><?php echo e($displayCard->card_name ?? 'Virtual Card'); ?></h3>
                        <p class="text-sm opacity-80 capitalize"><?php echo e($displayCard->card_type); ?> Card</p>
                        <div class="mt-2">
                            <?php if($displayCard->status === 'active'): ?>
                                <span class="inline-flex items-center px-2 py-1 bg-green-500/20 text-green-400 text-xs font-medium rounded-full">
                                    <i class="fas fa-check-circle w-3 h-3 mr-1"></i>
                                    Active
                                </span>
                            <?php elseif($displayCard->status === 'frozen'): ?>
                                <span class="inline-flex items-center px-2 py-1 bg-yellow-500/20 text-yellow-400 text-xs font-medium rounded-full">
                                    <i class="fas fa-snowflake w-3 h-3 mr-1"></i>
                                    Frozen
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2 py-1 bg-red-500/20 text-red-400 text-xs font-medium rounded-full">
                                    <i class="fas fa-times-circle w-3 h-3 mr-1"></i>
                                    <?php echo e(ucfirst($displayCard->status)); ?>

                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-xs opacity-80">Currency</p>
                        <p class="font-semibold"><?php echo e($displayCard->currency); ?></p>
                    </div>
                </div>
                
                <div class="mb-6">
                    <p class="text-xs opacity-80 mb-2">Card Number</p>
                    <p class="text-2xl font-mono tracking-wider" id="card-number"><?php echo e($displayCard->card_number); ?></p>
                </div>
                
                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <p class="text-xs opacity-80">CVV</p>
                        <p class="font-semibold" id="card-cvv">***</p>
                    </div>
                    <div>
                        <p class="text-xs opacity-80">Expiry</p>
                        <p class="font-semibold">**/**</p>
                    </div>
                    <div>
                        <p class="text-xs opacity-80">Balance</p>
                        <p class="font-semibold"><?php echo e($displayCard->currency === 'USD' ? '$' : '₦'); ?><?php echo e(number_format($displayCard->balance, 2)); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Card Stats -->
    <div class="grid grid-cols-2 gap-4 mb-6">
        <div class="card-gradient rounded-xl p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-400 text-sm">Spending Limit</p>
                    <p class="text-white font-semibold"><?php echo e($displayCard->currency === 'USD' ? '$' : '₦'); ?><?php echo e(number_format($displayCard->spending_limit)); ?></p>
                </div>
                <div class="w-10 h-10 bg-blue-500/20 rounded-lg flex items-center justify-center">
                    <i class="fas fa-credit-card text-blue-400"></i>
                </div>
            </div>
        </div>
        
        <div class="card-gradient rounded-xl p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-400 text-sm">Available Limit</p>
                    <p class="text-white font-semibold"><?php echo e($displayCard->currency === 'USD' ? '$' : '₦'); ?><?php echo e(number_format($displayCard->spending_limit - $displayCard->balance)); ?></p>
                </div>
                <div class="w-10 h-10 bg-green-500/20 rounded-lg flex items-center justify-center">
                    <i class="fas fa-wallet text-green-400"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="grid grid-cols-2 gap-4 mb-6">
        <?php if($displayCard->status === 'active'): ?>
            <form method="POST" action="<?php echo e(route('cards.freeze', $displayCard->id)); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="w-full bg-yellow-600 hover:bg-yellow-700 text-white font-semibold py-4 rounded-xl transition-colors duration-200">
                    <i class="fas fa-snowflake mr-2"></i>
                    Freeze Card
                </button>
            </form>
        <?php elseif($displayCard->status === 'frozen'): ?>
            <form method="POST" action="<?php echo e(route('cards.unfreeze', $displayCard->id)); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-4 rounded-xl transition-colors duration-200">
                    <i class="fas fa-play mr-2"></i>
                    Unfreeze Card
                </button>
            </form>
        <?php endif; ?>
        
        <button onclick="showFundModal()" class="w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-4 rounded-xl transition-colors duration-200">
            <i class="fas fa-plus mr-2"></i>
            Fund Card
        </button>
    </div>

    <!-- Transactions Section -->
    <div class="space-y-4">
        <div class="flex justify-between items-center">
            <h2 class="text-lg font-semibold text-white">Recent Transactions</h2>
            <a href="<?php echo e(route('transactions.index')); ?>?card_id=<?php echo e($displayCard->id); ?>" class="text-primary-400 text-sm hover:text-primary-300 transition-colors">View All</a>
        </div>

        <?php if($transactions->count() > 0): ?>
            <div class="space-y-3">
                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card-gradient rounded-xl p-4">
                        <div class="flex justify-between items-start">
                            <div class="flex items-center">
                                <div class="w-10 h-10 <?php echo e($transaction->type === 'credit' ? 'bg-green-500/20' : 'bg-red-500/20'); ?> rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas <?php echo e($transaction->type === 'credit' ? 'fa-arrow-down text-green-400' : 'fa-arrow-up text-red-400'); ?>"></i>
                                </div>
                                <div>
                                    <p class="text-white font-medium"><?php echo e($transaction->description); ?></p>
                                    <p class="text-gray-400 text-sm"><?php echo e($transaction->created_at->format('M j, Y h:i A')); ?></p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-white font-semibold <?php echo e($transaction->type === 'credit' ? 'text-green-400' : 'text-red-400'); ?>">
                                    <?php echo e($transaction->type === 'credit' ? '+' : '-'); ?><?php echo e($displayCard->currency === 'USD' ? '$' : '₦'); ?><?php echo e(number_format($transaction->amount, 2)); ?>

                                </p>
                                <p class="text-gray-400 text-xs capitalize"><?php echo e($transaction->status); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="card-gradient rounded-xl p-8 text-center">
                <div class="w-16 h-16 bg-gray-600/20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-receipt text-gray-400 text-xl"></i>
                </div>
                <p class="text-gray-400 mb-2">No transactions yet</p>
                <p class="text-gray-500 text-sm">Your card transactions will appear here</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Fund Card Modal -->
<div id="fund-modal" class="fixed inset-0 z-50 overflow-y-auto hidden">
    <div class="flex items-center justify-center min-h-screen px-4">
        <div class="fixed inset-0 bg-black opacity-50" onclick="hideFundModal()"></div>
        <div class="relative bg-dark-800 rounded-xl p-6 w-full max-w-md">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold text-white">Fund Card</h3>
                <button onclick="hideFundModal()" class="text-gray-400 hover:text-white">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <form method="POST" action="<?php echo e(route('cards.fund', $displayCard->id)); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>
                <div>
                    <label class="text-white font-medium">Amount</label>
                    <input type="number" name="amount" placeholder="Enter amount" min="100" 
                           class="w-full p-3 bg-dark-700 border border-gray-600 rounded-lg text-white placeholder-gray-400 focus:border-primary-500 focus:outline-none">
                </div>
                
                <button type="submit" class="w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-3 rounded-lg transition-colors duration-200">
                    Fund Card
                </button>
            </form>
        </div>
    </div>
</div>

<script>
let cardDetailsVisible = false;

function toggleCardDetails() {
    const cardNumber = document.getElementById('card-number');
    const cardCvv = document.getElementById('card-cvv');
    const toggleBtn = document.getElementById('toggle-btn');
    
    if (cardDetailsVisible) {
        cardNumber.textContent = '<?php echo e($displayCard->card_number); ?>';
        cardCvv.textContent = '***';
        toggleBtn.innerHTML = '<i class="fas fa-eye text-gray-300"></i>';
    } else {
        // Show full details (in real app, this would require authentication)
        cardNumber.textContent = '4532 1234 5678 9012'; // Sample full number
        cardNumber.textContent = '<?php echo e($displayCard->card_number); ?>';
        cardCvv.textContent = '<?php echo e($displayCard->cvv); ?>';
        toggleBtn.innerHTML = '<i class="fas fa-eye-slash text-gray-300"></i>';
    }
    cardDetailsVisible = !cardDetailsVisible;
}

function toggleDropdown() {
    const menu = document.getElementById('card-menu');
    menu.classList.toggle('hidden');
}

function copyCardNumber() {
    const cardNumber = <?php echo json_encode($displayCard->card_number, 15, 512) ?>; // Securely injected from backend
    navigator.clipboard.writeText(cardNumber).then(() => {
        alert('Card number copied to clipboard');
    });
    toggleDropdown();
}

function downloadStatement() {
    // Implement statement download
    alert('Statement download feature coming soon');
    toggleDropdown();
}

function shareCard() {
    // Implement card sharing
    alert('Card sharing feature coming soon');
    toggleDropdown();
}

function showFundModal() {
    document.getElementById('fund-modal').classList.remove('hidden');
}

function hideFundModal() {
    document.getElementById('fund-modal').classList.add('hidden');
}

// Close dropdown when clicking outside
document.addEventListener('click', function(event) {
    const menu = document.getElementById('card-menu');
    const button = event.target.closest('button');
    if (!button?.onclick?.toString().includes('toggleDropdown')) {
        menu.classList.add('hidden');
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.mobile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/freedemo/public_html/fintechcom/resources/views/virtual-cards/show.blade.php ENDPATH**/ ?>