<?php

namespace App\Services\Airtime\Contracts;

interface AirtimeProviderInterface
{
    /**
     * Initialize the provider with configuration.
     */
    public function configure(array $credentials): void;

    /**
     * Purchase airtime.
     */
    public function purchaseAirtime(array $params): array;

    /**
     * Purchase data bundle.
     */
    public function purchaseData(array $params): array;

    /**
     * Get available data plans for a network.
     */
    public function getDataPlans(string $network): array;

    /**
     * Check transaction status.
     */
    public function checkTransactionStatus(string $reference): array;

    /**
     * Get account balance.
     */
    public function getBalance(): array;

    /**
     * Test connection to the provider.
     */
    public function testConnection(): array;

    /**
     * Get supported networks.
     */
    public function getSupportedNetworks(): array;

    /**
     * Verify phone number and network.
     */
    public function verifyPhoneNumber(string $phoneNumber): array;
}