<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cron_logs', function (Blueprint $table) {
            $table->id();
            $table->string('task_name');
            $table->enum('status', ['success', 'failed', 'warning'])->default('success');
            $table->text('message')->nullable();
            $table->timestamp('executed_at');
            $table->float('execution_time')->nullable();
            $table->integer('memory_usage')->nullable();
            $table->json('error_details')->nullable();
            $table->timestamps();
            
            $table->index(['task_name', 'executed_at']);
            $table->index(['status', 'executed_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cron_logs');
    }
};