<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('airtime_margins', function (Blueprint $table) {
            $table->id();
            $table->string('network'); // mtn, glo, airtel, 9mobile
            $table->string('service_type'); // airtime, data
            $table->decimal('margin_percentage', 5, 2); // Profit margin percentage
            $table->decimal('fixed_fee', 10, 2)->default(0.00); // Fixed fee per transaction
            $table->decimal('min_margin_amount', 10, 2)->default(0.00); // Minimum margin in Naira
            $table->decimal('max_margin_amount', 10, 2)->nullable(); // Maximum margin in Naira
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->unique(['network', 'service_type']);
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('airtime_margins');
    }
};
