<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vtu_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('transaction_id')->constrained()->onDelete('cascade');
            $table->string('service_type'); // airtime, data, electricity, cable
            $table->string('provider'); // MTN, GLO, AIRTEL, 9MOBILE, EKEDC, etc.
            $table->string('recipient_phone')->nullable(); // For airtime/data
            $table->string('meter_number')->nullable(); // For electricity
            $table->string('smartcard_number')->nullable(); // For cable TV
            $table->decimal('amount', 15, 2);
            $table->decimal('discount', 15, 2)->default(0.00);
            $table->string('plan_code')->nullable(); // Data plan or electricity package
            $table->string('plan_name')->nullable();
            $table->enum('status', ['pending', 'processing', 'completed', 'failed', 'cancelled'])->default('pending');
            $table->string('provider_reference')->nullable();
            $table->string('provider_transaction_id')->nullable();
            $table->text('provider_response')->nullable();
            $table->text('failure_reason')->nullable();
            $table->integer('retry_count')->default(0);
            $table->timestamp('processed_at')->nullable();
            $table->json('metadata')->nullable(); // Additional service data
            $table->timestamps();
            
            $table->index(['user_id', 'service_type', 'status']);
            $table->index(['provider', 'status']);
            $table->index(['provider_reference']);
            $table->index(['created_at', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vtu_transactions');
    }
};