<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vc_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('virtual_card_id')->constrained()->onDelete('cascade');
            $table->string('provider_transaction_id');
            $table->decimal('amount', 15, 2);
            $table->string('currency', 3)->default('USD');
            $table->decimal('naira_amount', 15, 2)->nullable(); // Converted amount
            $table->decimal('exchange_rate', 10, 4)->nullable();
            $table->string('merchant_name')->nullable();
            $table->string('merchant_category')->nullable();
            $table->string('merchant_country')->nullable();
            $table->string('transaction_type'); // debit, credit, refund
            $table->enum('status', ['pending', 'approved', 'declined', 'reversed'])->default('pending');
            $table->string('authorization_code')->nullable();
            $table->string('response_code')->nullable();
            $table->text('response_message')->nullable();
            $table->boolean('is_international')->default(false);
            $table->json('metadata')->nullable();
            $table->timestamp('transaction_date');
            $table->timestamps();
            
            $table->index(['user_id', 'status']);
            $table->index(['virtual_card_id', 'status']);
            $table->index(['provider_transaction_id']);
            $table->index(['transaction_date', 'status']);
            // Using short index name to comply with MySQL's 64-character limit
            $table->index(['merchant_category', 'transaction_date'], 'vc_mc_td_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vc_transactions');
    }
};