<?php

namespace Tests\Feature\Admin;

use App\Models\Admin;
use App\Models\User;
use App\Models\KycVerification;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class KycControllerSyntaxTest extends TestCase
{
    use RefreshDatabase, WithFaker;

    /**
     * Test that the KycController has valid PHP syntax.
     */
    public function test_kyc_controller_syntax_is_valid(): void
    {
        // This test simply instantiates the controller to check if syntax is valid
        $this->assertInstanceOf(
            \App\Http\Controllers\Admin\KycController::class,
            new \App\Http\Controllers\Admin\KycController()
        );
    }

    /**
     * Test that the KYC rejection method can be called without syntax errors.
     */
    public function test_kyc_rejection_method_syntax(): void
    {
        // Create a user with KYC verification
        $user = User::create([
            'first_name' => 'John',
            'last_name' => 'Doe',
            'email' => 'john.doe@example.com',
            'phone' => '+1234567890',
            'password' => bcrypt('password'),
        ]);

        $kycVerification = KycVerification::create([
            'user_id' => $user->id,
            'type' => 'bvn',
            'status' => 'pending',
            'verification_id' => 'test-verification-123',
        ]);

        // Create an admin user for authentication (if needed)
        $admin = Admin::create([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'password' => bcrypt('password'),
        ]);

        // Mock the admin authentication
        $this->actingAs($admin, 'admin');

        // Test that the controller method exists and can be instantiated
        $controller = new \App\Http\Controllers\Admin\KycController();
        $this->assertTrue(method_exists($controller, 'reject'));

        // Verify the controller has the necessary methods for KYC processing
        $this->assertTrue(method_exists($controller, 'approve'));
        $this->assertTrue(method_exists($controller, 'reset'));
    }
}