<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('virtual_accounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('account_number')->unique();
            $table->string('account_name');
            $table->string('bank_code');
            $table->string('bank_name');
            $table->string('provider'); // monnify, anchor, etc.
            $table->string('provider_reference')->unique();
            $table->string('currency', 3)->default('NGN');
            $table->boolean('is_active')->default(true);
            $table->json('metadata')->nullable(); // Additional provider data
            $table->timestamps();
            
            $table->index(['user_id', 'is_active']);
            $table->index('provider_reference');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('virtual_accounts');
    }
};