@extends('layouts.admin-sidebar')

@section('title', 'Airtime & Data Providers')
@section('page-title', 'Service Providers')
@section('page-description', 'Manage airtime and data service providers and their settings')

@section('content')
<div class="space-y-6">
    <!-- Page Header with Actions -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Service Provider Management</h2>
            <p class="text-gray-600 mt-1">Configure and monitor your airtime and data service providers</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="testAllProviders()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                Test All
            </button>
            <button class="btn-primary" onclick="openProviderModal()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Add Provider
            </button>
        </div>
    </div>

    <!-- Providers Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6">
        @foreach($providers as $provider)
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow">
            <!-- Provider Header -->
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                        <span class="text-white font-bold text-lg">{{ strtoupper(substr($provider['name'], 0, 2)) }}</span>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-lg font-semibold text-gray-900">{{ $provider['name'] }}</h3>
                        <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                            {{ $provider['type'] === 'Primary' ? 'bg-green-100 text-green-800' : 
                               ($provider['type'] === 'Secondary' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800') }}">
                            {{ $provider['type'] }}
                        </span>
                    </div>
                </div>
                <div class="flex items-center">
                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                        {{ $provider['status'] === 'active' ? 'bg-emerald-100 text-emerald-800' : 'bg-red-100 text-red-800' }}">
                        {{ ucfirst($provider['status']) }}
                    </span>
                </div>
            </div>

            <!-- Provider Stats -->
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div class="text-center p-3 bg-gray-50 rounded-lg">
                    <div class="text-2xl font-bold text-gray-900">{{ $provider['success_rate'] }}%</div>
                    <div class="text-xs text-gray-600">Success Rate</div>
                </div>
                <div class="text-center p-3 bg-gray-50 rounded-lg">
                    <div class="text-2xl font-bold text-gray-900">{{ $provider['avg_response_time'] }}s</div>
                    <div class="text-xs text-gray-600">Avg Response</div>
                </div>
            </div>

            <!-- Transaction Stats -->
            <div class="flex justify-between items-center mb-4 text-sm">
                <span class="text-gray-600">Total Transactions:</span>
                <span class="font-semibold text-gray-900">{{ number_format($provider['total_transactions']) }}</span>
            </div>
            <div class="flex justify-between items-center mb-4 text-sm">
                <span class="text-gray-600">Last Used:</span>
                <span class="font-semibold text-gray-900">{{ $provider['last_used'] }}</span>
            </div>

            <!-- Supported Services -->
            <div class="mb-4">
                <label class="text-sm font-medium text-gray-700 mb-2 block">Supported Services</label>
                <div class="flex flex-wrap gap-1">
                    @foreach($provider['supported_services'] as $service)
                    <span class="inline-flex px-2 py-1 text-xs font-medium bg-blue-100 text-blue-800 rounded">
                        {{ $service }}
                    </span>
                    @endforeach
                </div>
            </div>

            <!-- Provider Actions -->
            <div class="flex space-x-2 pt-4 border-t border-gray-200">
                <button class="flex-1 btn-secondary text-sm py-2" 
                        onclick="testProvider({{ $provider['id'] }})">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Test
                </button>
                <button class="flex-1 btn-primary text-sm py-2" 
                        onclick="configureProvider({{ $provider['id'] }})">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    Configure
                </button>
                @if($provider['status'] === 'active')
                <button class="btn-danger text-sm py-2 px-3" 
                        onclick="toggleProviderStatus({{ $provider['id'] }}, 'inactive')">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </button>
                @else
                <button class="btn-success text-sm py-2 px-3" 
                        onclick="toggleProviderStatus({{ $provider['id'] }}, 'active')">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </button>
                @endif
            </div>
        </div>
        @endforeach
    </div>

    <!-- Provider Performance Chart -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Provider Performance Overview</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Success Rate Comparison -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Success Rate Comparison</h4>
                @foreach($providers as $provider)
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm text-gray-600">{{ $provider['name'] }}</span>
                    <div class="flex items-center">
                        <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                            <div class="h-2 bg-gradient-to-r from-emerald-500 to-emerald-600 rounded-full" 
                                 style="width: {{ $provider['success_rate'] }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ $provider['success_rate'] }}%</span>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Response Time Comparison -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Response Time Comparison</h4>
                @foreach($providers as $provider)
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm text-gray-600">{{ $provider['name'] }}</span>
                    <div class="flex items-center">
                        <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                            <div class="h-2 bg-gradient-to-r from-blue-500 to-blue-600 rounded-full" 
                                 style="width: {{ 100 - ($provider['avg_response_time'] * 10) }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ $provider['avg_response_time'] }}s</span>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Transaction Volume -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Transaction Volume</h4>
                @foreach($providers as $provider)
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm text-gray-600">{{ $provider['name'] }}</span>
                    <span class="text-sm font-medium text-gray-900">{{ number_format($provider['total_transactions']) }}</span>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Quick Actions Panel -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h3>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="bulkTest()">
                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">Bulk Test</div>
                <div class="text-xs text-gray-500">Test all providers</div>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="viewLogs()">
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">View Logs</div>
                <div class="text-xs text-gray-500">Provider activity</div>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="manageFailover()">
                <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">Failover Rules</div>
                <div class="text-xs text-gray-500">Manage switching</div>
            </button>

            <button class="p-4 border border-gray-200 rounded-lg hover:bg-gray-50 text-center" 
                    onclick="exportReport()">
                <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                    <svg class="w-4 h-4 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div class="text-sm font-medium text-gray-900">Export Report</div>
                <div class="text-xs text-gray-500">Download analytics</div>
            </button>
        </div>
    </div>
</div>

<script>
function testProvider(providerId) {
    // Implementation for testing individual provider
    alert('Testing provider: ' + providerId);
}

function testAllProviders() {
    // Implementation for testing all providers
    alert('Testing all providers...');
}

function configureProvider(providerId) {
    // Implementation for configuring provider
    alert('Configure provider: ' + providerId);
}

function toggleProviderStatus(providerId, status) {
    // Implementation for toggling provider status
    if(confirm('Are you sure you want to ' + status + ' this provider?')) {
        alert('Provider status updated to: ' + status);
    }
}

function openProviderModal() {
    // Implementation for opening add provider modal
    alert('Add new provider modal');
}

function bulkTest() {
    // Implementation for bulk testing
    alert('Running bulk tests...');
}

function viewLogs() {
    // Implementation for viewing logs
    alert('Viewing provider logs...');
}

function manageFailover() {
    // Implementation for managing failover rules
    alert('Managing failover rules...');
}

function exportReport() {
    // Implementation for exporting report
    alert('Exporting provider report...');
}
</script>
@endsection