@extends('layouts.admin-sidebar')

@section('title', 'Security Logs')
@section('page-title', 'Security & Audit Logs')
@section('page-description', 'Monitor admin activities and security events')

@section('content')
<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900">Security & Audit Logs</h2>
            <p class="text-gray-600 mt-1">Monitor admin activities, user actions, and security events</p>
        </div>
        <div class="flex space-x-3">
            <button class="btn-secondary" onclick="exportLogs()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Export Logs
            </button>
            <button class="btn-danger" onclick="clearOldLogs()">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
                Clear Old Logs
            </button>
        </div>
    </div>

    <!-- Statistics Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Total Logs -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Logs</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($stats['total_logs']) }}</p>
                    <p class="text-sm text-blue-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                            All time records
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Today's Actions -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Today's Actions</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($stats['today_actions']) }}</p>
                    <p class="text-sm text-emerald-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Last 24 hours
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Unique Admins -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Active Admins</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($stats['unique_admins']) }}</p>
                    <p class="text-sm text-purple-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                            With activities
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Login Attempts -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Login Attempts</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($stats['login_attempts']) }}</p>
                    <p class="text-sm text-orange-600 mt-1">
                        <span class="inline-flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                            </svg>
                            All attempts
                        </span>
                    </p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-orange-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Filter Security Logs</h3>
        <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" value="{{ request('search') }}" 
                       placeholder="Search actions, IPs..."
                       class="input-primary">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Action</label>
                <select name="action" class="input-primary">
                    <option value="">All Actions</option>
                    @foreach($actions as $action)
                    <option value="{{ $action }}" {{ request('action') === $action ? 'selected' : '' }}>
                        {{ ucwords(str_replace('_', ' ', $action)) }}
                    </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Admin</label>
                <select name="admin_id" class="input-primary">
                    <option value="">All Admins</option>
                    <!-- In a real implementation, this would list actual admins -->
                    <option value="1" {{ request('admin_id') === '1' ? 'selected' : '' }}>Super Admin</option>
                    <option value="2" {{ request('admin_id') === '2' ? 'selected' : '' }}>Admin User</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Date From</label>
                <input type="date" name="date_from" value="{{ request('date_from') }}" class="input-primary">
            </div>
            <div class="flex items-end">
                <button type="submit" class="btn-primary w-full">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    Filter
                </button>
            </div>
        </form>
    </div>

    <!-- Security Logs Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-900">Security & Audit Logs</h3>
            <p class="text-sm text-gray-600 mt-1">Track all admin activities and security events</p>
        </div>

        @if($logs->count() > 0)
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Admin & Action
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Target & Details
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            IP Address & Location
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Timestamp
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($logs as $log)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-10 w-10">
                                    <div class="h-10 w-10 rounded-full bg-gray-300 flex items-center justify-center">
                                        <span class="text-sm font-medium text-gray-700">
                                            {{ $log->admin ? strtoupper(substr($log->admin->name, 0, 2)) : 'SY' }}
                                        </span>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ $log->admin ? $log->admin->name : 'System' }}
                                    </div>
                                    <div class="text-sm text-gray-500">
                                        <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full
                                            {{ $this->getActionColor($log->action) }}">
                                            {{ ucwords(str_replace('_', ' ', $log->action)) }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                @if($log->target_type && $log->target_id)
                                    {{ $log->target_type }} #{{ $log->target_id }}
                                @else
                                    General Action
                                @endif
                            </div>
                            <div class="text-sm text-gray-500">
                                @if($log->data)
                                    @php $data = json_decode($log->data, true); @endphp
                                    @if(is_array($data) && count($data) > 0)
                                        {{ collect($data)->take(2)->map(function($value, $key) {
                                            return ucfirst($key) . ': ' . (is_string($value) ? Str::limit($value, 20) : $value);
                                        })->implode(', ') }}
                                    @endif
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900">{{ $log->ip_address }}</div>
                            <div class="text-sm text-gray-500">
                                <!-- In a real implementation, you would have location data -->
                                {{ $this->getLocationFromIP($log->ip_address) }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div>{{ $log->created_at->format('M j, Y') }}</div>
                            <div>{{ $log->created_at->format('g:i A') }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <button class="text-blue-600 hover:text-blue-900 mr-3"
                                    onclick="viewLogDetails({{ $log->id }})">
                                <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                Details
                            </button>
                            @if($log->ip_address !== '127.0.0.1')
                            <button class="text-orange-600 hover:text-orange-900"
                                    onclick="blockIP('{{ $log->ip_address }}')">
                                <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636m12.728 12.728L18.364 5.636M5.636 18.364l12.728-12.728"></path>
                                </svg>
                                Block IP
                            </button>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $logs->links() }}
        </div>
        @else
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No logs found</h3>
            <p class="mt-1 text-sm text-gray-500">No security logs match your current filters.</p>
        </div>
        @endif
    </div>

    <!-- Recent Activity Summary -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Activity Summary</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Most Active Actions -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Most Common Actions</h4>
                <div class="space-y-2">
                    @php
                    $commonActions = [
                        'user_login' => 45,
                        'update_settings' => 23,
                        'view_user' => 18,
                        'kyc_approval' => 12,
                        'transaction_review' => 8
                    ];
                    @endphp
                    @foreach($commonActions as $action => $count)
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-600">{{ ucwords(str_replace('_', ' ', $action)) }}</span>
                        <div class="flex items-center">
                            <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                                <div class="h-2 bg-gradient-to-r from-blue-500 to-blue-600 rounded-full" 
                                     style="width: {{ ($count / 45) * 100 }}%"></div>
                            </div>
                            <span class="text-sm font-medium text-gray-900">{{ $count }}</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Time Distribution -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Activity by Time</h4>
                <div class="space-y-2">
                    @php
                    $timeDistribution = [
                        'Morning (6-12)' => 35,
                        'Afternoon (12-18)' => 45,
                        'Evening (18-24)' => 15,
                        'Night (0-6)' => 5
                    ];
                    @endphp
                    @foreach($timeDistribution as $time => $percentage)
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-600">{{ $time }}</span>
                        <div class="flex items-center">
                            <div class="w-16 h-2 bg-gray-200 rounded-full mr-2">
                                <div class="h-2 bg-gradient-to-r from-green-500 to-emerald-600 rounded-full" 
                                     style="width: {{ $percentage }}%"></div>
                            </div>
                            <span class="text-sm font-medium text-gray-900">{{ $percentage }}%</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Security Alerts -->
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-3">Security Alerts</h4>
                <div class="space-y-3">
                    <div class="p-3 bg-green-50 rounded-lg">
                        <div class="flex items-start">
                            <svg class="w-4 h-4 text-green-600 mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div>
                                <p class="text-xs font-medium text-green-800">No suspicious activity</p>
                                <p class="text-xs text-green-700">All login attempts from known IPs</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-3 bg-blue-50 rounded-lg">
                        <div class="flex items-start">
                            <svg class="w-4 h-4 text-blue-600 mt-0.5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div>
                                <p class="text-xs font-medium text-blue-800">Regular backup completed</p>
                                <p class="text-xs text-blue-700">Audit logs backed up successfully</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function viewLogDetails(logId) {
    alert('View log details: ' + logId);
}

function blockIP(ipAddress) {
    if(confirm('Are you sure you want to block IP address: ' + ipAddress + '?')) {
        alert('IP address blocked: ' + ipAddress);
    }
}

function exportLogs() {
    alert('Exporting security logs...');
}

function clearOldLogs() {
    if(confirm('Are you sure you want to clear logs older than 90 days? This action cannot be undone.')) {
        alert('Old logs cleared successfully!');
    }
}
</script>

@php
// Helper methods that would be in the controller
function getActionColor($action) {
    $colors = [
        'login' => 'bg-green-100 text-green-800',
        'logout' => 'bg-gray-100 text-gray-800',
        'create' => 'bg-blue-100 text-blue-800',
        'update' => 'bg-yellow-100 text-yellow-800',
        'delete' => 'bg-red-100 text-red-800',
        'approve' => 'bg-emerald-100 text-emerald-800',
        'reject' => 'bg-red-100 text-red-800',
    ];
    
    foreach($colors as $key => $color) {
        if(str_contains($action, $key)) {
            return $color;
        }
    }
    
    return 'bg-gray-100 text-gray-800';
}

function getLocationFromIP($ip) {
    // Mock location data - in a real implementation, use a GeoIP service
    $locations = [
        '127.0.0.1' => 'Local',
        '192.168.1.1' => 'Local Network',
    ];
    
    return $locations[$ip] ?? 'Lagos, Nigeria';
}
@endphp
@endsection